/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization.model.metadata;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.serialization.api.TypeConverter;
import org.exoplatform.commons.serialization.model.metadata.ClassTypeMetaData;
import org.exoplatform.commons.serialization.model.metadata.ConvertedTypeMetaData;
import org.exoplatform.commons.serialization.model.metadata.TypeMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainMetaData {
    private final Map<String, TypeMetaData> state;

    public DomainMetaData(DomainMetaData domainMetaData) {
        if (domainMetaData == null) {
            throw new NullPointerException();
        }
        this.state = new HashMap<String, TypeMetaData>(domainMetaData.state);
    }

    public DomainMetaData() {
        this.state = new HashMap<String, TypeMetaData>();
    }

    public TypeMetaData getTypeMetaData(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return this.state.get(clazz.getName());
    }

    public TypeMetaData getTypeMetaData(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.state.get(name);
    }

    public void addConvertedType(Class<?> clazz, Class<? extends TypeConverter<?, ?>> converterClass) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.state.put(clazz.getName(), new ConvertedTypeMetaData(clazz.getName(), converterClass));
    }

    public void addClassType(Class<?> clazz, boolean serialized) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.state.put(clazz.getName(), new ClassTypeMetaData(clazz.getName(), serialized));
    }

    public void addConvertedType(String name, Class<? extends TypeConverter<?, ?>> converterClass) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.state.put(name, new ConvertedTypeMetaData(name, converterClass));
    }

    public void addClassType(String name, boolean serialized) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.state.put(name, new ClassTypeMetaData(name, serialized));
    }
}

