/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.seo;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.jcr.Node;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.seo.PageMetadataModel;
import org.exoplatform.services.seo.SEOService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.seo.UISEOForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/webui/seo/UISEOPortletToolbar.gtmpl", events={@EventConfig(listeners={AddSEOActionListener.class})})
public class UISEOToolbarForm
extends UIForm {
    public static final String SEO_POPUP_WINDOW = "UISEOPopupWindow";
    private static ArrayList<String> paramsArray = null;
    private String pageReference = null;
    PageMetadataModel metaModel = null;
    private String fullStatus = "Empty";

    public void processRender(WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String portalName = pcontext.getPortalOwner();
        this.metaModel = null;
        if (!pcontext.useAjax()) {
            this.fullStatus = "Empty";
            paramsArray = null;
            String contentParam = null;
            Enumeration params = pcontext.getRequest().getParameterNames();
            if (params.hasMoreElements()) {
                paramsArray = new ArrayList();
                while (params.hasMoreElements()) {
                    contentParam = params.nextElement().toString();
                    try {
                        paramsArray.add(Text.unescape((String)pcontext.getRequestParameter(contentParam)));
                    }
                    catch (Exception ex) {
                        paramsArray.add(pcontext.getRequestParameter(contentParam));
                    }
                }
            }
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SEOService seoService = (SEOService)container.getComponentInstanceOfType(SEOService.class);
        this.pageReference = Util.getUIPortal().getSelectedUserNode().getPageRef();
        if (this.pageReference != null) {
            SiteKey siteKey = Util.getUIPortal().getSelectedUserNode().getNavigation().getKey();
            SiteKey portalKey = SiteKey.portal((String)portalName);
            if (siteKey != null && siteKey.equals((Object)portalKey)) {
                this.metaModel = seoService.getPageMetadata(this.pageReference);
                if (paramsArray != null) {
                    PageMetadataModel tmpModel = seoService.getContentMetadata(paramsArray);
                    if (tmpModel != null) {
                        this.metaModel = tmpModel;
                    } else {
                        for (int i = 0; i < paramsArray.size(); ++i) {
                            if (seoService.getContentNode(paramsArray.get(i).toString()) == null) continue;
                            this.metaModel = null;
                            break;
                        }
                    }
                }
            } else {
                this.fullStatus = "Disabled";
            }
        }
        if (this.metaModel != null) {
            this.fullStatus = this.metaModel.getFullStatus();
        }
        super.processRender(context);
    }

    public String getFullStatus() {
        return this.fullStatus;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddSEOActionListener
    extends EventListener<UISEOToolbarForm> {
        public void execute(Event<UISEOToolbarForm> event) throws Exception {
            String[] arrCoordinate;
            UISEOToolbarForm uiSEOToolbar = (UISEOToolbarForm)((Object)event.getSource());
            UISEOForm uiSEOForm = (UISEOForm)uiSEOToolbar.createUIComponent(UISEOForm.class, null, null);
            String params = event.getRequestContext().getRequestParameter("objectId");
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            SEOService seoService = (SEOService)container.getComponentInstanceOfType(SEOService.class);
            if (paramsArray != null) {
                for (int i = 0; i < paramsArray.size(); ++i) {
                    Node contentNode = seoService.getContentNode(((String)paramsArray.get(i)).toString());
                    if (contentNode == null) continue;
                    uiSEOForm.setOnContent(true);
                    break;
                }
            } else {
                uiSEOForm.setOnContent(false);
            }
            uiSEOForm.setParamsArray(paramsArray);
            uiSEOForm.initSEOForm(uiSEOToolbar.metaModel);
            int top = -1;
            int left = -1;
            if (params != null && params.length() > 0 && (arrCoordinate = params.split(",")) != null && arrCoordinate.length == 2) {
                top = Integer.parseInt(arrCoordinate[0]);
                left = Integer.parseInt(arrCoordinate[1]);
            }
            if (top > -1 && left > -1) {
                Utils.createPopupWindow((UIContainer)uiSEOToolbar, (UIComponent)uiSEOForm, (String)UISEOToolbarForm.SEO_POPUP_WINDOW, (int)325, (int)top, (int)left);
            } else {
                Utils.createPopupWindow((UIContainer)uiSEOToolbar, (UIComponent)uiSEOForm, (String)UISEOToolbarForm.SEO_POPUP_WINDOW, (int)325);
            }
        }
    }
}

