/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIPublicationManager;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.ecm.publication.AlreadyInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationPresentationService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.ecm.publication.plugins.webui.UIPublicationLogList;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={EnrolActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIActivePublication
extends UIPagingGrid
implements UIPopupComponent {
    public static final String LIFECYCLE_NAME = "LifecycleName";
    public static final String LIFECYCLE_DESC = "LifecycleDesc";
    public static String[] LIFECYCLE_FIELDS = new String[]{"LifecycleName", "LifecycleDesc"};
    public static String[] LIFECYCLE_ACTION = new String[]{"Enrol"};
    public static final String LIFECYCLE_SELECTED = "LifecycleSelected";
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UIActivePublication");

    public UIActivePublication() throws Exception {
        this.configure(LIFECYCLE_NAME, LIFECYCLE_FIELDS, LIFECYCLE_ACTION);
        this.getUIPageIterator().setId("LifecyclesIterator");
    }

    public String[] getActions() {
        return new String[]{"Cancel"};
    }

    public void refresh(int currentPage) throws Exception {
        ArrayList<PublicationLifecycleBean> publicationLifecycleBeans = new ArrayList<PublicationLifecycleBean>();
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        Collection publicationPlugins = publicationService.getPublicationPlugins().values();
        if (publicationPlugins.size() != 0) {
            for (PublicationPlugin publicationPlugin : publicationPlugins) {
                PublicationLifecycleBean lifecycleBean = new PublicationLifecycleBean();
                lifecycleBean.setLifecycleName(publicationPlugin.getLifecycleName());
                lifecycleBean.setLifecycleDesc(publicationPlugin.getDescription());
                publicationLifecycleBeans.add(lifecycleBean);
            }
        }
        ListAccessImpl beanList = new ListAccessImpl(PublicationLifecycleBean.class, publicationLifecycleBeans);
        LazyPageList dataPageList = new LazyPageList((ListAccess)beanList, this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setPageList((PageList)dataPageList);
        this.getUIPageIterator().setTotalItems(publicationLifecycleBeans.size());
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public void enrolNodeInLifecycle(Node currentNode, String lifecycleName, WebuiRequestContext requestContext) throws Exception {
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        UIPublicationManager uiPublicationManager = (UIPublicationManager)uiJCRExplorer.createUIComponent(UIPublicationManager.class, null, null);
        uiJCRExplorer.addLockToken(currentNode);
        Node parentNode = currentNode.getParent();
        uiJCRExplorer.addLockToken(parentNode);
        WCMPublicationService wcmPublicationService = (WCMPublicationService)this.getApplicationComponent(WCMPublicationService.class);
        PublicationPresentationService publicationPresentationService = (PublicationPresentationService)this.getApplicationComponent(PublicationPresentationService.class);
        try {
            if (!currentNode.isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
                return;
            }
            String siteName = Util.getPortalRequestContext().getPortalOwner();
            String remoteUser = Util.getPortalRequestContext().getRemoteUser();
            if ("Authoring publication".equals(lifecycleName)) {
                wcmPublicationService.enrollNodeInLifecycle(currentNode, siteName, remoteUser);
            } else {
                wcmPublicationService.enrollNodeInLifecycle(currentNode, lifecycleName);
            }
        }
        catch (AlreadyInPublicationLifecycleException e) {
            uiApp.addMessage(new ApplicationMessage("UIActivePublication.msg.already-enroled", null, 0));
            return;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
            uiApp.addMessage(new ApplicationMessage("UIActivePublication.msg.unknow-error", (Object[])new String[]{e.getMessage()}, 0));
            return;
        }
        currentNode.refresh(true);
        UIContainer container = (UIContainer)this.createUIComponent(UIContainer.class, null, null);
        UIForm uiFormPublicationManager = publicationPresentationService.getStateUI(currentNode, (UIComponent)container);
        UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiJCRExplorer.getChild(UIPopupContainer.class);
        if (uiFormPublicationManager instanceof UIPopupComponent) {
            UIPopupContainer2.activate((UIComponent)uiFormPublicationManager, 700, 500);
        } else {
            uiPublicationManager.addChild((UIComponent)uiFormPublicationManager);
            ((UIPublicationLogList)uiPublicationManager.addChild(UIPublicationLogList.class, null, null)).setRendered(false);
            UIPublicationLogList uiPublicationLogList = (UIPublicationLogList)uiPublicationManager.getChild(UIPublicationLogList.class);
            UIPopupContainer2.activate((UIComponent)uiPublicationManager, 700, 500);
            uiPublicationLogList.setNode(currentNode);
            uiPublicationLogList.updateGrid();
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnrolActionListener
    extends EventListener<UIActivePublication> {
        public void execute(Event<UIActivePublication> event) throws Exception {
            UIActivePublication uiActivePub = (UIActivePublication)((Object)event.getSource());
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uiActivePub.getAncestorOfType(UIJCRExplorer.class);
            String selectedLifecycle = event.getRequestContext().getRequestParameter("objectId");
            Node currentNode = uiJCRExplorer.getCurrentNode();
            uiActivePub.enrolNodeInLifecycle(currentNode, selectedLifecycle, event.getRequestContext());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIActivePublication> {
        public void execute(Event<UIActivePublication> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIActivePublication)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    public class PublicationLifecycleBean {
        private String lifecycleName;
        private String lifecycleDesc;

        public String getLifecycleName() {
            return this.lifecycleName;
        }

        public void setLifecycleName(String lifecycleName) {
            this.lifecycleName = lifecycleName;
        }

        public String getLifecycleDesc() {
            return this.lifecycleDesc;
        }

        public void setLifecycleDesc(String lifecycleDesc) {
            this.lifecycleDesc = lifecycleDesc;
        }
    }
}

