/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.upload;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIMultiLanguageForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIMultiLanguageManager;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadBehaviorWithSameName;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadContainer;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadContent;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadManager;
import org.exoplatform.ecm.webui.form.validator.IllegalDMSCharValidator;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.documents.DocumentTypeService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/upload/UIUploadForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddUploadActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveUploadActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIFormMultiValueInputSet.class, id="UploadMultipleInputset", events={@EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIUploadForm
extends UIForm
implements UIPopupComponent,
UISelectable {
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.upload.UIUploadForm");
    public static final String FIELD_NAME = "name";
    public static final String FIELD_UPLOAD = "upload";
    public static final String JCRCONTENT = "jcr:content";
    public static final String FIELD_TAXONOMY = "fieldTaxonomy";
    public static final String FIELD_LISTTAXONOMY = "fieldListTaxonomy";
    public static final String POPUP_TAXONOMY = "UIPopupTaxonomy";
    public static final String ACCESSIBLE_MEDIA = "accessibleMedia";
    private boolean isMultiLanguage_;
    private String language_;
    private boolean isDefault_;
    private List<String> listTaxonomy = new ArrayList<String>();
    private List<String> listTaxonomyName = new ArrayList<String>();
    private int numberUploadFile = 1;
    private HashMap<String, List<String>> mapTaxonomies = new HashMap();
    private List<NodeLocation> listUploadedNodes = new ArrayList<NodeLocation>();
    private boolean taxonomyMandatory = false;
    private DocumentTypeService docService;

    public UIUploadForm() throws Exception {
        this.setMultiPart(true);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(IllegalDMSCharValidator.class, new Object[0]));
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String limitPref = portletPref.getValue("uploadFileSizeLimitMB", "");
        UIFormUploadInput uiInput = null;
        if (limitPref != null) {
            try {
                uiInput = new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD, Integer.parseInt(limitPref.trim()));
            }
            catch (NumberFormatException e) {
                uiInput = new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD);
            }
        } else {
            uiInput = new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD);
        }
        uiInput.setAutoUpload(true);
        this.addUIFormInput((UIFormInput)uiInput);
        this.docService = (DocumentTypeService)WCMCoreUtils.getService(DocumentTypeService.class);
    }

    public int getNumberUploadFile() {
        return this.numberUploadFile;
    }

    public void setNumberUploadFile(int numberUpload) {
        this.numberUploadFile = numberUpload;
    }

    public HashMap<String, List<String>> getMapTaxonomies() {
        return this.mapTaxonomies;
    }

    public void setMapTaxonomies(HashMap<String, List<String>> mapTaxonomiesAvaiable) {
        this.mapTaxonomies = mapTaxonomiesAvaiable;
    }

    public List<String> getListTaxonomy() {
        return this.listTaxonomy;
    }

    public List<String> getlistTaxonomyName() {
        return this.listTaxonomyName;
    }

    public void setListTaxonomy(List<String> listTaxonomyNew) {
        this.listTaxonomy = listTaxonomyNew;
    }

    public void setListTaxonomyName(List<String> listTaxonomyNameNew) {
        this.listTaxonomyName = listTaxonomyNameNew;
    }

    public boolean getTaxonomyMandatory() {
        return this.taxonomyMandatory;
    }

    public void setTaxonomyMandatory(boolean taxoMandatory) {
        this.taxonomyMandatory = taxoMandatory;
    }

    public String getPathTaxonomy() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        DMSConfiguration dmsConfig = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        DMSRepositoryConfiguration dmsRepoConfig = dmsConfig.getConfig();
        String workspaceName = dmsRepoConfig.getSystemWorkspace();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        Session session = uiExplorer.getSessionByWorkspace(workspaceName);
        return ((Node)session.getItem(nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath"))).getPath();
    }

    public void initFieldInput() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String categoryMandatoryWhenFileUpload = portletPref.getValue("categoryMandatoryWhenFileUpload", "").trim();
        UIFormMultiValueInputSet uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, "UploadMultipleInputset", null);
        uiFormMultiValue.setId(FIELD_LISTTAXONOMY);
        uiFormMultiValue.setName(FIELD_LISTTAXONOMY);
        uiFormMultiValue.setType(UIFormStringInput.class);
        uiFormMultiValue.setEditable(false);
        if (categoryMandatoryWhenFileUpload.equalsIgnoreCase("true")) {
            uiFormMultiValue.addValidator(MandatoryValidator.class, new Object[0]);
            this.setTaxonomyMandatory(true);
        } else {
            this.setTaxonomyMandatory(false);
        }
        uiFormMultiValue.setValue(this.listTaxonomyName);
        this.addUIFormInput((UIFormInput)uiFormMultiValue);
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void setIsMultiLanguage(boolean isMultiLanguage, String language) {
        this.isMultiLanguage_ = isMultiLanguage;
        this.language_ = language;
    }

    public void resetComponent() {
        this.removeChildById(FIELD_UPLOAD);
        this.addUIFormInput((UIFormInput)new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD));
    }

    public boolean isMultiLanguage() {
        return this.isMultiLanguage_;
    }

    public void setIsDefaultLanguage(boolean isDefault) {
        this.isDefault_ = isDefault;
    }

    private String getLanguageSelected() {
        return this.language_;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String valueTaxonomy = String.valueOf(value).trim();
        List<String> indexMapTaxonomy = new ArrayList<String>();
        if (this.mapTaxonomies.containsKey(selectField)) {
            indexMapTaxonomy = this.mapTaxonomies.get(selectField);
            this.mapTaxonomies.remove(selectField);
        }
        if (!indexMapTaxonomy.contains(valueTaxonomy)) {
            indexMapTaxonomy.add(valueTaxonomy);
        }
        this.mapTaxonomies.put(selectField, indexMapTaxonomy);
        this.updateAdvanceTaxonomy(selectField);
        UIUploadManager uiUploadManager = (UIUploadManager)this.getParent();
        uiUploadManager.removeChildById(POPUP_TAXONOMY);
    }

    public List<String> getListSameNames(Event<UIUploadForm> event) throws Exception {
        ArrayList<String> sameNameList = new ArrayList<String>();
        Node selectedNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        int index = 0;
        String name = null;
        for (UIComponent uiComp : this.getChildren()) {
            UIFormUploadInput uiFormUploadInput;
            if (!(uiComp instanceof UIFormUploadInput)) continue;
            String[] arrayId = uiComp.getId().split(FIELD_UPLOAD);
            if (arrayId.length > 0 && arrayId[0].length() > 0) {
                index = new Integer(arrayId[0]);
            }
            if ((uiFormUploadInput = index == 0 ? (UIFormUploadInput)this.getUIInput(FIELD_UPLOAD) : (UIFormUploadInput)this.getUIInput(index + FIELD_UPLOAD)).getUploadResource() == null) {
                return sameNameList;
            }
            String fileName = uiFormUploadInput.getUploadResource().getFileName();
            name = index == 0 ? (String)this.getUIStringInput(FIELD_NAME).getValue() : (String)this.getUIStringInput(index + FIELD_NAME).getValue();
            name = name == null ? fileName : name.trim();
            if (!this.passNameValidation(name = Text.escapeIllegalJcrChars((String)name))) {
                return new ArrayList<String>();
            }
            if (!selectedNode.hasNode(name)) continue;
            sameNameList.add(name);
        }
        return sameNameList;
    }

    /*
     * WARNING - void declaration
     */
    public void doUpload(Event event, boolean isKeepFile) throws Exception {
        String lockToken;
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIUploadManager uiManager = (UIUploadManager)this.getParent();
        UIUploadContainer uiUploadContainer = (UIUploadContainer)uiManager.getChild(UIUploadContainer.class);
        UploadService uploadService = (UploadService)this.getApplicationComponent(UploadService.class);
        UIUploadContent uiUploadContent = (UIUploadContent)uiManager.findFirstComponentOfType(UIUploadContent.class);
        ArrayList<String[]> listArrValues = new ArrayList<String[]>();
        CmsService cmsService = (CmsService)this.getApplicationComponent(CmsService.class);
        List listFormChildren = this.getChildren();
        int index = 0;
        String name = null;
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        MultiLanguageService multiLangService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        if (uiExplorer.getCurrentNode().isLocked() && (lockToken = LockUtil.getLockToken((Node)uiExplorer.getCurrentNode())) != null) {
            uiExplorer.getSession().addLockToken(lockToken);
        }
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String categoryMandatoryWhenFileUpload = portletPref.getValue("categoryMandatoryWhenFileUpload", "").trim();
        DMSMimeTypeResolver mimeTypeSolver = DMSMimeTypeResolver.getInstance();
        Node selectedNode = uiExplorer.getCurrentNode();
        if (categoryMandatoryWhenFileUpload.equalsIgnoreCase("true") && this.getMapTaxonomies().size() == 0 && !uiExplorer.getCurrentNode().hasNode(JCRCONTENT)) {
            uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.taxonomyPath-error", null, 1));
            return;
        }
        String pers = "add_node,set_property";
        selectedNode.getSession().checkPermission(selectedNode.getPath(), pers);
        try {
            String fileName;
            UIFormUploadInput uiFormUploadInput;
            int indexValidate = 0;
            for (UIComponent uiCompValidate : listFormChildren) {
                if (!(uiCompValidate instanceof UIFormUploadInput)) continue;
                String[] arrayIdValidate = uiCompValidate.getId().split(FIELD_UPLOAD);
                if (arrayIdValidate.length > 0 && arrayIdValidate[0].length() > 0) {
                    indexValidate = new Integer(arrayIdValidate[0]);
                }
                if ((uiFormUploadInput = indexValidate == 0 ? (UIFormUploadInput)this.getUIInput(FIELD_UPLOAD) : (UIFormUploadInput)this.getUIInput(indexValidate + FIELD_UPLOAD)).getUploadResource() == null) {
                    uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.fileName-error", null, 1));
                    return;
                }
                fileName = uiFormUploadInput.getUploadResource().getFileName();
                if (fileName != null && fileName.length() != 0) continue;
                uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.fileName-error", null, 1));
                return;
            }
            for (UIComponent uiComp : listFormChildren) {
                BufferedInputStream inputStream;
                if (!(uiComp instanceof UIFormUploadInput)) continue;
                String[] arrayId = uiComp.getId().split(FIELD_UPLOAD);
                if (arrayId.length > 0 && arrayId[0].length() > 0) {
                    index = new Integer(arrayId[0]);
                }
                if ((uiFormUploadInput = index == 0 ? (UIFormUploadInput)this.getUIInput(FIELD_UPLOAD) : (UIFormUploadInput)this.getUIInput(index + FIELD_UPLOAD)).getUploadResource() == null) {
                    if (this.listUploadedNodes != null && this.listUploadedNodes.size() > 0) {
                        for (Object uploadedNode : NodeLocation.getNodeListByLocationList(this.listUploadedNodes)) {
                            ((Node)uploadedNode).remove();
                        }
                        uiExplorer.getCurrentNode().save();
                        this.listUploadedNodes.clear();
                    }
                    uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.fileName-error", null, 1));
                    return;
                }
                fileName = uiFormUploadInput.getUploadResource().getFileName();
                if (fileName == null || fileName.length() == 0) {
                    if (this.listUploadedNodes != null && this.listUploadedNodes.size() > 0) {
                        for (Object uploadedNode : NodeLocation.getNodeListByLocationList(this.listUploadedNodes)) {
                            ((Node)uploadedNode).remove();
                        }
                        uiExplorer.getCurrentNode().save();
                        this.listUploadedNodes.clear();
                    }
                    uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.fileName-error", null, 1));
                    return;
                }
                try {
                    inputStream = new BufferedInputStream(uiFormUploadInput.getUploadDataAsStream());
                }
                catch (FileNotFoundException e) {
                    inputStream = new BufferedInputStream(new ByteArrayInputStream(new byte[0]));
                }
                name = index == 0 ? (String)this.getUIStringInput(FIELD_NAME).getValue() : (String)this.getUIStringInput(index + FIELD_NAME).getValue();
                name = name == null ? fileName : name.trim();
                if (!this.passNameValidation(name)) {
                    uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.fileName-invalid-with-name", new Object[]{name}, 1));
                    return;
                }
                name = Text.escapeIllegalJcrChars((String)name);
                String mimeType = mimeTypeSolver.getMimeType(fileName);
                String ext = "." + fileName.substring(fileName.lastIndexOf(".") + 1);
                if (name.lastIndexOf(ext) < 0 && !mimeTypeSolver.getMimeType(name).equals(mimeType)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(name).append(ext);
                    name = sb.toString();
                }
                List<Object> listTaxonomyNameNew = new ArrayList();
                listTaxonomyNameNew = index == 0 ? this.mapTaxonomies.get(FIELD_LISTTAXONOMY) : this.mapTaxonomies.get(index + FIELD_LISTTAXONOMY);
                String taxonomyTree = null;
                String taxonomyPath = null;
                if (listTaxonomyNameNew != null) {
                    for (String string : listTaxonomyNameNew) {
                        try {
                            void var35_48;
                            if (string.startsWith("/")) {
                                String string2 = string.substring(1);
                            }
                            if (var35_48.indexOf("/") > 0) {
                                taxonomyTree = var35_48.substring(0, var35_48.indexOf("/"));
                                taxonomyPath = var35_48.substring(var35_48.indexOf("/") + 1);
                                taxonomyService.getTaxonomyTree(taxonomyTree).hasNode(taxonomyPath);
                                continue;
                            }
                            taxonomyTree = var35_48;
                            taxonomyPath = "";
                        }
                        catch (ItemNotFoundException e) {
                            uiApp.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.non-categories", null, 1));
                            return;
                        }
                        catch (RepositoryException re) {
                            uiApp.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.non-categories", null, 1));
                            return;
                        }
                        catch (Exception e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)"An unexpected error occurs", (Throwable)e);
                            }
                            uiApp.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.non-categories", null, 1));
                            return;
                        }
                    }
                }
                boolean isExist = selectedNode.hasNode(name);
                Object var35_49 = null;
                if (this.isMultiLanguage()) {
                    ValueFactoryImpl valueFactory = (ValueFactoryImpl)uiExplorer.getSession().getValueFactory();
                    Value contentValue = valueFactory.createValue((InputStream)inputStream);
                    multiLangService.addFileLanguage(selectedNode, name, contentValue, mimeType, this.getLanguageSelected(), uiExplorer.getRepositoryName(), this.isDefault_);
                    uiExplorer.setIsHidePopup(true);
                    UIMultiLanguageManager uiLanguageManager = (UIMultiLanguageManager)this.getAncestorOfType(UIMultiLanguageManager.class);
                    UIMultiLanguageForm uIMultiLanguageForm = (UIMultiLanguageForm)uiLanguageManager.getChild(UIMultiLanguageForm.class);
                    uIMultiLanguageForm.doSelect(uiExplorer.getCurrentNode());
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiLanguageManager);
                } else {
                    if (selectedNode.getPrimaryNodeType().isNodeType("nt:file")) {
                        Node contentNode;
                        if (!selectedNode.isCheckedOut()) {
                            selectedNode.checkout();
                        }
                        if ((contentNode = selectedNode.getNode(JCRCONTENT)).getProperty("jcr:mimeType").getString().equals(mimeType)) {
                            contentNode.setProperty("jcr:data", (InputStream)inputStream);
                            contentNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
                            selectedNode.save();
                            uiManager.setRendered(false);
                            uiExplorer.updateAjax(event);
                            return;
                        }
                    }
                    if (!isExist || isKeepFile) {
                        String nodeType = this.contains(this.docService.getMimeTypes(ACCESSIBLE_MEDIA), mimeType) ? "exo:accessibleMedia" : "nt:file";
                        String string = cmsService.storeNodeByUUID(nodeType, selectedNode, this.getInputProperties(name, inputStream, mimeType), true);
                        selectedNode.save();
                        selectedNode.getSession().save();
                        if (listTaxonomyNameNew != null && listTaxonomyNameNew.size() > 0) {
                            Node newNode = null;
                            try {
                                newNode = selectedNode.getSession().getNodeByUUID(string);
                            }
                            catch (ItemNotFoundException e) {
                                newNode = Utils.findNodeByUUID((String)string);
                            }
                            if (newNode != null) {
                                for (String string3 : listTaxonomyNameNew) {
                                    try {
                                        void var39_69;
                                        if (string3.startsWith("/")) {
                                            String string4 = string3.substring(1);
                                        }
                                        if (var39_69.indexOf("/") > 0) {
                                            taxonomyTree = var39_69.substring(0, var39_69.indexOf("/"));
                                            taxonomyPath = var39_69.substring(var39_69.indexOf("/") + 1);
                                        } else {
                                            taxonomyTree = var39_69;
                                            taxonomyPath = "";
                                        }
                                        taxonomyService.addCategory(newNode, taxonomyTree, taxonomyPath);
                                    }
                                    catch (ItemExistsException itemExistsException) {
                                        uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.ItemExistsException", null, 1));
                                        return;
                                    }
                                    catch (RepositoryException repositoryException) {
                                        if (LOG.isErrorEnabled()) {
                                            LOG.error((Object)"Unexpected error", (Throwable)repositoryException);
                                        }
                                        JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)repositoryException));
                                        return;
                                    }
                                }
                            }
                        }
                    } else {
                        Node node = selectedNode.getNode(name);
                        if (this.isTaxonomyChildNode(node)) {
                            LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
                            node = linkManager.getTarget(node);
                        }
                        if (!node.getPrimaryNodeType().isNodeType("nt:file")) {
                            Object[] args = new Object[]{name};
                            uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.name-is-exist", args, 1));
                            return;
                        }
                        if (!node.isNodeType("mix:versionable") && node.canAddMixin("mix:versionable")) {
                            node.addMixin("mix:versionable");
                        }
                        Node contentNode = node.getNode(JCRCONTENT);
                        if (!node.isCheckedOut()) {
                            node.checkout();
                        }
                        contentNode.setProperty("jcr:data", (InputStream)inputStream);
                        contentNode.setProperty("jcr:mimeType", mimeType);
                        contentNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
                        if (node.isNodeType("exo:datetime")) {
                            node.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
                        }
                        node.save();
                        ListenerService listenerService = (ListenerService)this.getApplicationComponent(ListenerService.class);
                        listenerService.broadcast("CmsService.event.postEdit", (Object)this, (Object)node);
                        if (listTaxonomyNameNew != null) {
                            for (String string : listTaxonomyNameNew) {
                                try {
                                    void var40_80;
                                    if (string.startsWith("/")) {
                                        String string5 = string.substring(1);
                                    }
                                    if (var40_80.indexOf("/") > 0) {
                                        taxonomyTree = var40_80.substring(0, var40_80.indexOf("/"));
                                        taxonomyPath = var40_80.substring(var40_80.indexOf("/") + 1);
                                    } else {
                                        taxonomyTree = var40_80;
                                        taxonomyPath = "";
                                    }
                                    taxonomyService.addCategory(node, taxonomyTree, taxonomyPath);
                                }
                                catch (ItemExistsException e) {
                                    uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.ItemExistsException", null, 1));
                                    return;
                                }
                                catch (RepositoryException e) {
                                    if (LOG.isErrorEnabled()) {
                                        LOG.error((Object)"Unexpected error", (Throwable)e);
                                    }
                                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                                    return;
                                }
                            }
                        }
                    }
                }
                uiExplorer.getSession().save();
                Node uploadedNode = null;
                if (this.isMultiLanguage_) {
                    uiUploadContainer.setUploadedNode(selectedNode);
                    uploadedNode = selectedNode;
                } else {
                    Node newNode = null;
                    if (!isExist) {
                        void var35_44;
                        try {
                            newNode = selectedNode.getSession().getNodeByUUID((String)var35_44);
                        }
                        catch (ItemNotFoundException e) {
                            newNode = Utils.findNodeByUUID((String)var35_44);
                        }
                    } else {
                        newNode = selectedNode.getNode(name);
                    }
                    if (newNode != null) {
                        uiUploadContainer.setUploadedNode(newNode);
                        uploadedNode = newNode;
                    }
                }
                double size = 0.0;
                if (uploadedNode.hasNode(JCRCONTENT)) {
                    Node node = uploadedNode.getNode(JCRCONTENT);
                    if (node.hasProperty("jcr:data")) {
                        size = node.getProperty("jcr:data").getLength();
                    }
                } else {
                    size = uploadService.getUploadResource(uiFormUploadInput.getUploadId()).getEstimatedSize();
                }
                String string = Utils.calculateFileSize((double)size);
                String string6 = Utils.getNodeTypeIcon((Node)uploadedNode, (String)"16x16Icon").replaceAll("nt_file16x16Icon ", "");
                String[] arrValues = new String[]{string6, Text.unescapeIllegalJcrChars((String)fileName), Text.unescapeIllegalJcrChars((String)name), string, mimeType, uploadedNode.getPath()};
                this.listUploadedNodes.add(NodeLocation.getNodeLocationByNode((Node)uploadedNode));
                listArrValues.add(arrValues);
                ((InputStream)inputStream).close();
            }
            uiUploadContent.setListUploadValues(listArrValues);
            uiManager.setRenderedChild(UIUploadContainer.class);
            uiExplorer.setIsHidePopup(true);
            uiExplorer.updateAjax(event);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
        catch (ConstraintViolationException con) {
            Object[] args = new Object[]{name};
            throw new MessageException(new ApplicationMessage("UIUploadForm.msg.contraint-violation", args, 1));
        }
        catch (LockException lock) {
            throw new MessageException(new ApplicationMessage("UIUploadForm.msg.lock-exception", null, 1));
        }
        catch (AccessDeniedException ade) {
            throw new MessageException(new ApplicationMessage("UIActionBar.msg.access-add-denied", null, 1));
        }
        catch (AccessControlException ace) {
            throw new MessageException(new ApplicationMessage("UIActionBar.msg.access-add-denied", null, 1));
        }
        catch (ItemExistsException iee) {
            uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.item-existed", null, 1));
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An unexpected error occurs", (Throwable)e);
            }
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
    }

    private boolean isTaxonomyChildNode(Node node) throws RepositoryException {
        Node parrentNode = node.getParent();
        while (!((NodeImpl)parrentNode).isRoot()) {
            if (parrentNode.isNodeType("exo:taxonomy")) {
                return true;
            }
            parrentNode = parrentNode.getParent();
        }
        return false;
    }

    private Map<String, JcrInputProperty> getInputProperties(String name, InputStream inputStream, String mimeType) {
        HashMap<String, JcrInputProperty> inputProperties = new HashMap<String, JcrInputProperty>();
        JcrInputProperty nodeInput = new JcrInputProperty();
        nodeInput.setJcrPath("/node");
        nodeInput.setValue((Object)name);
        nodeInput.setMixintype("mix:i18n,mix:votable,mix:commentable");
        nodeInput.setType(1);
        inputProperties.put("/node", nodeInput);
        JcrInputProperty jcrContent = new JcrInputProperty();
        jcrContent.setJcrPath("/node/jcr:content");
        jcrContent.setValue((Object)"");
        jcrContent.setMixintype("dc:elementSet");
        jcrContent.setNodetype("nt:resource");
        jcrContent.setType(1);
        inputProperties.put("/node/jcr:content", jcrContent);
        JcrInputProperty jcrData = new JcrInputProperty();
        jcrData.setJcrPath("/node/jcr:content/jcr:data");
        jcrData.setValue((Object)inputStream);
        inputProperties.put("/node/jcr:content/jcr:data", jcrData);
        JcrInputProperty jcrMimeType = new JcrInputProperty();
        jcrMimeType.setJcrPath("/node/jcr:content/jcr:mimeType");
        jcrMimeType.setValue((Object)mimeType);
        inputProperties.put("/node/jcr:content/jcr:mimeType", jcrMimeType);
        JcrInputProperty jcrLastModified = new JcrInputProperty();
        jcrLastModified.setJcrPath("/node/jcr:content/jcr:lastModified");
        jcrLastModified.setValue((Object)new GregorianCalendar());
        inputProperties.put("/node/jcr:content/jcr:lastModified", jcrLastModified);
        JcrInputProperty jcrEncoding = new JcrInputProperty();
        jcrEncoding.setJcrPath("/node/jcr:content/jcr:encoding");
        jcrEncoding.setValue((Object)"UTF-8");
        inputProperties.put("/node/jcr:content/jcr:encoding", jcrEncoding);
        return inputProperties;
    }

    private void updateAdvanceTaxonomy(String selectField) throws Exception {
        List listChildren = this.getChildren();
        for (UIComponent uiComp : listChildren) {
            if (!uiComp.getId().equals(selectField)) continue;
            UIFormMultiValueInputSet uiFormMultiValueInputSet = (UIFormMultiValueInputSet)this.getChildById(selectField);
            if (!this.mapTaxonomies.containsKey(selectField)) continue;
            uiFormMultiValueInputSet.setValue(this.getTaxonomyLabel(this.mapTaxonomies.get(selectField)));
        }
    }

    private List<String> getTaxonomyLabel(List<String> taxonomyPaths) {
        ArrayList<String> taxonomyLabels = new ArrayList<String>();
        String[] taxonomyPathSplit = null;
        for (String taxonomyPath : taxonomyPaths) {
            if (taxonomyPath.startsWith("/")) {
                taxonomyPath = taxonomyPath.substring(1);
            }
            taxonomyPathSplit = taxonomyPath.split("/");
            StringBuilder buildlabel = new StringBuilder();
            StringBuilder buildPathlabel = new StringBuilder();
            for (int i = 0; i < taxonomyPathSplit.length; ++i) {
                buildlabel = new StringBuilder("eXoTaxonomies");
                try {
                    for (int j = 0; j <= i; ++j) {
                        buildlabel.append(".").append(taxonomyPathSplit[j]);
                    }
                    buildPathlabel.append(Utils.getResourceBundle((String)buildlabel.append(".label").toString())).append("/");
                    continue;
                }
                catch (MissingResourceException me) {
                    buildPathlabel.append(taxonomyPathSplit[i]).append("/");
                }
            }
            taxonomyLabels.add(buildPathlabel.substring(0, buildPathlabel.length() - 1));
        }
        return taxonomyLabels;
    }

    private boolean passNameValidation(String name) throws Exception {
        if (name == null || name.contains("[") || name.contains("]") || name.contains("\"") || name.contains("/")) {
            return false;
        }
        int count = 0;
        for (char c : name.toCharArray()) {
            if (c == ':') {
                ++count;
            }
            if (count <= 1) continue;
            return false;
        }
        if (count == 1) {
            String[] prefixs;
            if (name.split(":").length < 2) {
                return false;
            }
            String namespace = name.split(":")[0];
            NamespaceRegistry namespaceRegistry = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName()).getNamespaceRegistry();
            for (String prefix : prefixs = namespaceRegistry.getPrefixes()) {
                if (!namespace.equals(prefix)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean contains(String[] arr, String item) {
        if (arr != null) {
            for (String arrItem : arr) {
                if (arrItem != null && arrItem.equals(item)) {
                    return true;
                }
                if (arrItem != item) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveUploadActionListener
    extends EventListener<UIUploadForm> {
        public void execute(Event<UIUploadForm> event) throws Exception {
            String id = event.getRequestContext().getRequestParameter("objectId");
            UIUploadForm uiUploadForm = (UIUploadForm)((Object)event.getSource());
            List listChildren = uiUploadForm.getChildren();
            int index = 0;
            for (UIComponent uiComp : listChildren) {
                if (!(uiComp instanceof UIFormUploadInput)) continue;
                ++index;
            }
            String[] arrayId = id.split(UIUploadForm.FIELD_NAME);
            int indexRemove = 0;
            if (arrayId.length > 0 && arrayId[0].length() > 0) {
                indexRemove = new Integer(arrayId[0]);
            }
            if (indexRemove == 0) {
                uiUploadForm.removeChildById(UIUploadForm.FIELD_NAME);
                uiUploadForm.removeChildById(UIUploadForm.FIELD_UPLOAD);
                uiUploadForm.removeChildById(UIUploadForm.FIELD_LISTTAXONOMY);
                if (uiUploadForm.mapTaxonomies.containsKey(UIUploadForm.FIELD_LISTTAXONOMY)) {
                    uiUploadForm.mapTaxonomies.remove(UIUploadForm.FIELD_LISTTAXONOMY);
                }
            } else {
                uiUploadForm.removeChildById(indexRemove + UIUploadForm.FIELD_NAME);
                uiUploadForm.removeChildById(indexRemove + UIUploadForm.FIELD_UPLOAD);
                uiUploadForm.removeChildById(indexRemove + UIUploadForm.FIELD_LISTTAXONOMY);
                if (uiUploadForm.mapTaxonomies.containsKey(indexRemove + UIUploadForm.FIELD_LISTTAXONOMY)) {
                    uiUploadForm.mapTaxonomies.remove(indexRemove + UIUploadForm.FIELD_LISTTAXONOMY);
                }
            }
            uiUploadForm.setNumberUploadFile(index - 1);
            uiUploadForm.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiUploadForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddUploadActionListener
    extends EventListener<UIUploadForm> {
        public void execute(Event<UIUploadForm> event) throws Exception {
            String[] arrayId;
            UIUploadForm uiUploadForm = (UIUploadForm)((Object)event.getSource());
            List listChildren = uiUploadForm.getChildren();
            int index = 0;
            int numberUploadFile = 0;
            String fieldFieldUpload = null;
            for (UIComponent uiComp : listChildren) {
                if (!(uiComp instanceof UIFormUploadInput)) continue;
                fieldFieldUpload = uiComp.getId();
                ++numberUploadFile;
            }
            if (fieldFieldUpload != null && (arrayId = fieldFieldUpload.split(UIUploadForm.FIELD_UPLOAD)).length > 0 && arrayId[0].length() > 0) {
                index = new Integer(arrayId[0]);
            }
            uiUploadForm.addUIFormInput((UIFormInput)new UIFormStringInput(++index + UIUploadForm.FIELD_NAME, index + UIUploadForm.FIELD_NAME, null));
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences portletPref = pcontext.getRequest().getPreferences();
            String limitPref = portletPref.getValue("uploadFileSizeLimitMB", "");
            UIFormUploadInput uiInput = null;
            if (limitPref != null) {
                try {
                    uiInput = new UIFormUploadInput(index + UIUploadForm.FIELD_UPLOAD, index + UIUploadForm.FIELD_UPLOAD, Integer.parseInt(limitPref.trim()));
                }
                catch (NumberFormatException e) {
                    uiInput = new UIFormUploadInput(index + UIUploadForm.FIELD_UPLOAD, index + UIUploadForm.FIELD_UPLOAD);
                }
            } else {
                uiInput = new UIFormUploadInput(index + UIUploadForm.FIELD_UPLOAD, index + UIUploadForm.FIELD_UPLOAD);
            }
            uiInput.setAutoUpload(true);
            uiUploadForm.addUIFormInput((UIFormInput)uiInput);
            UIFormMultiValueInputSet uiFormMultiValue = (UIFormMultiValueInputSet)uiUploadForm.createUIComponent(UIFormMultiValueInputSet.class, "UploadMultipleInputset", null);
            uiFormMultiValue.setId(index + UIUploadForm.FIELD_LISTTAXONOMY);
            uiFormMultiValue.setName(index + UIUploadForm.FIELD_LISTTAXONOMY);
            uiFormMultiValue.setType(UIFormStringInput.class);
            uiFormMultiValue.setEditable(false);
            uiUploadForm.addUIFormInput((UIFormInput)uiFormMultiValue);
            uiUploadForm.setNumberUploadFile(numberUploadFile + 1);
            uiUploadForm.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiUploadForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)event.getSource();
            UIUploadForm uiUploadForm = (UIUploadForm)uiSet.getParent();
            UIApplication uiApp = (UIApplication)uiUploadForm.getAncestorOfType(UIApplication.class);
            try {
                String idFieldUpload;
                UIFormUploadInput uiFormUploadInput;
                UploadResource uploadResource;
                String fieldTaxonomyId = event.getRequestContext().getRequestParameter("objectId");
                String[] arrayId = fieldTaxonomyId.split(UIUploadForm.FIELD_LISTTAXONOMY);
                int index = 0;
                if (arrayId.length > 0 && arrayId[0].length() > 0) {
                    index = new Integer(arrayId[0]);
                }
                if ((uploadResource = (uiFormUploadInput = (UIFormUploadInput)uiUploadForm.getChildById(idFieldUpload = index == 0 ? UIUploadForm.FIELD_UPLOAD : index + UIUploadForm.FIELD_UPLOAD)).getUploadResource()) == null) {
                    uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.upload-not-null", null, 1));
                    return;
                }
                UIUploadManager uiUploadManager = (UIUploadManager)uiUploadForm.getParent();
                UIJCRExplorer uiExplorer = (UIJCRExplorer)uiUploadForm.getAncestorOfType(UIJCRExplorer.class);
                String repository = uiExplorer.getRepositoryName();
                UIPopupWindow uiPopupWindow = uiUploadManager.initPopupTaxonomy(UIUploadForm.POPUP_TAXONOMY);
                UIOneTaxonomySelector uiOneTaxonomySelector = (UIOneTaxonomySelector)uiUploadManager.createUIComponent(UIOneTaxonomySelector.class, null, null);
                uiPopupWindow.setUIComponent((UIComponent)uiOneTaxonomySelector);
                TaxonomyService taxonomyService = (TaxonomyService)uiUploadForm.getApplicationComponent(TaxonomyService.class);
                List lstTaxonomyTree = taxonomyService.getAllTaxonomyTrees();
                if (lstTaxonomyTree.size() == 0) {
                    throw new AccessDeniedException();
                }
                String workspaceName = ((Node)lstTaxonomyTree.get(0)).getSession().getWorkspace().getName();
                uiOneTaxonomySelector.setIsDisable(workspaceName, false);
                uiOneTaxonomySelector.setRootNodeLocation(repository, workspaceName, ((Node)lstTaxonomyTree.get(0)).getPath());
                uiOneTaxonomySelector.setExceptedNodeTypesInPathPanel(new String[]{"exo:symlink"});
                uiOneTaxonomySelector.init(uiExplorer.getSystemProvider());
                String param = "returnField=" + fieldTaxonomyId;
                uiOneTaxonomySelector.setSourceComponent((UIComponent)uiUploadForm, new String[]{param});
                uiPopupWindow.setRendered(true);
                uiPopupWindow.setShow(true);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadManager);
            }
            catch (AccessDeniedException accessDeniedException) {
                uiApp.addMessage(new ApplicationMessage("Taxonomy.msg.AccessDeniedException", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)event.getSource();
            UIComponent uiComponent = uiSet.getParent();
            if (uiComponent instanceof UIUploadForm) {
                UIUploadForm uiUploadForm = (UIUploadForm)uiComponent;
                String id = event.getRequestContext().getRequestParameter("objectId");
                String[] arrayId = id.split(UIUploadForm.FIELD_LISTTAXONOMY);
                int index = 0;
                int indexRemove = 0;
                if (arrayId.length > 0 && arrayId[0].length() > 0) {
                    index = new Integer(arrayId[0]);
                }
                if (arrayId.length > 0 && arrayId[1].length() > 0) {
                    indexRemove = new Integer(arrayId[1]);
                }
                String idFieldListTaxonomy = index == 0 ? UIUploadForm.FIELD_LISTTAXONOMY : index + UIUploadForm.FIELD_LISTTAXONOMY;
                if (uiUploadForm.mapTaxonomies.containsKey(idFieldListTaxonomy)) {
                    List indexMapTaxonomy = new ArrayList();
                    indexMapTaxonomy = (List)uiUploadForm.mapTaxonomies.get(idFieldListTaxonomy);
                    uiUploadForm.mapTaxonomies.remove(idFieldListTaxonomy);
                    if (indexMapTaxonomy.size() > indexRemove) {
                        indexMapTaxonomy.remove(indexRemove);
                    }
                    uiUploadForm.mapTaxonomies.put(idFieldListTaxonomy, indexMapTaxonomy);
                }
                uiSet.removeChildById(id);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadForm);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIUploadForm> {
        public void execute(Event<UIUploadForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIUploadForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIUploadForm> {
        public void execute(Event<UIUploadForm> event) throws Exception {
            UIUploadForm uiForm = (UIUploadForm)((Object)event.getSource());
            UIUploadManager uiManager = (UIUploadManager)uiForm.getParent();
            if (uiForm.getListSameNames(event).size() > 0) {
                UIPopupWindow uiPopupWindow = uiManager.initPopupWhenHaveSameName();
                UIUploadBehaviorWithSameName uiUploadBehavior = (UIUploadBehaviorWithSameName)uiManager.createUIComponent(UIUploadBehaviorWithSameName.class, null, null);
                uiUploadBehavior.setMessageKey("UIUploadForm.msg.confirm-behavior");
                uiUploadBehavior.setArguments(uiForm.getListSameNames(event).toArray(new String[uiForm.getListSameNames(event).size()]));
                uiPopupWindow.setUIComponent((UIComponent)uiUploadBehavior);
                uiPopupWindow.setShow(true);
                uiPopupWindow.setRendered(true);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
                return;
            }
            uiForm.doUpload(event, false);
        }
    }
}

