/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application;

import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.web.application.Application;
import org.exoplatform.webui.Util;
import org.exoplatform.webui.application.ConfigurationManager;
import org.exoplatform.webui.application.StateManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.Component;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebuiApplication
extends Application {
    private ConfigurationManager configManager_;
    private StateManager stateManager_;

    public void onInit() throws Exception {
        String configPath = this.getApplicationInitParam("webui.configuration");
        InputStream is = this.getResourceResolver().getInputStream(configPath);
        this.configManager_ = new ConfigurationManager(is);
        String stateManagerClass = this.configManager_.getApplication().getStateManager();
        StateManager stManager = (StateManager)Util.createObject(stateManagerClass, null);
        this.setStateManager(stManager);
        this.setApplicationLifecycle(this.configManager_.getApplication().getApplicationLifecycleListeners());
        super.onInit();
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configManager_;
    }

    public StateManager getStateManager() {
        return this.stateManager_;
    }

    public void setStateManager(StateManager sm) {
        this.stateManager_ = sm;
    }

    public abstract String getApplicationInitParam(String var1);

    public <T> void broadcast(Event<T> event) throws Exception {
        List<EventListener> listeners = this.configManager_.getApplication().getApplicationEventListeners(event.getName());
        if (listeners == null) {
            return;
        }
        for (EventListener listener : listeners) {
            listener.execute(event);
        }
    }

    public <T extends UIComponent> T createUIComponent(Class<T> type, String configId, String id, WebuiRequestContext context) throws Exception {
        Component config = this.configManager_.getComponentConfig(type, configId);
        if (config == null) {
            throw new Exception("Cannot find the configuration for the component " + type.getName() + ", configId " + configId);
        }
        UIComponent uicomponent = (UIComponent)Util.createObject(type, config.getInitParams());
        uicomponent.setComponentConfig(id, config);
        return (T)uicomponent;
    }

    public Set<UIComponent> getDefaultUIComponentToUpdateByAjax(WebuiRequestContext context) {
        LinkedHashSet<UIComponent> list = new LinkedHashSet<UIComponent>(3);
        list.add(context.getUIApplication());
        return list;
    }
}

