/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions.activation;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.actions.ActionPlugin;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ScriptActionActivationJob
implements Job {
    private static final String COUNTER_PROP = "exo:counter";
    private static final Log LOG = ExoLogger.getLogger(ScriptActionActivationJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)exoContainer.getComponentInstanceOfType(RepositoryService.class);
        ActionServiceContainer actionServiceContainer = (ActionServiceContainer)exoContainer.getComponentInstanceOfType(ActionServiceContainer.class);
        IdentityRegistry identityRegistry = (IdentityRegistry)exoContainer.getComponentInstanceOfType(IdentityRegistry.class);
        ActionPlugin scriptActionService = actionServiceContainer.getActionPlugin("exo:scriptAction");
        Session jcrSession = null;
        Node actionNode = null;
        JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
        String userId = jdatamap.getString("initiator");
        String srcWorkspace = jdatamap.getString("srcWorkspace");
        String srcPath = jdatamap.getString("srcPath");
        String actionName = jdatamap.getString("actionName");
        String executable = jdatamap.getString("executable");
        String repository = null;
        Map variables = jdatamap.getWrappedMap();
        try {
            repository = repositoryService.getCurrentRepository().getConfiguration().getName();
            jcrSession = repositoryService.getCurrentRepository().getSystemSession(srcWorkspace);
            Node node = (Node)jcrSession.getItem(srcPath);
            actionNode = actionServiceContainer.getAction(node, actionName);
            Property rolesProp = actionNode.getProperty("exo:roles");
            Value[] roles = rolesProp.getValues();
            boolean hasPermission = this.checkExcetuteable(userId, roles, identityRegistry);
            if (!hasPermission) {
                jcrSession.logout();
                return;
            }
            scriptActionService.activateAction(userId, executable, variables, repository);
            int currentCounter = (int)actionNode.getProperty(COUNTER_PROP).getValue().getLong();
            actionNode.setProperty(COUNTER_PROP, (long)(currentCounter + 1));
            actionNode.save();
            jcrSession.save();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
        finally {
            if (jcrSession != null) {
                jcrSession.logout();
            }
        }
    }

    private boolean checkExcetuteable(String userId, Value[] roles, IdentityRegistry identityRegistry) throws Exception {
        if (IdentityConstants.SYSTEM.equalsIgnoreCase(userId)) {
            return true;
        }
        Identity identity = identityRegistry.getIdentity(userId);
        if (identity == null) {
            return false;
        }
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i].getString();
            if ("*".equalsIgnoreCase(role)) {
                return true;
            }
            MembershipEntry membershipEntry = MembershipEntry.parse((String)role);
            if (!identity.isMemberOf(membershipEntry)) continue;
            return true;
        }
        return false;
    }
}

