/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MSXExcelDocumentReader
extends BaseDocumentReader {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.document.impl.MSXExcelDocumentReader");
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSZ";

    public String[] getMimeTypes() {
        return new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(final InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        StringBuilder builder = new StringBuilder("");
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        try {
            XSSFWorkbook wb;
            if (is.available() == 0) {
                String string = "";
                return string;
            }
            try {
                wb = (XSSFWorkbook)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<XSSFWorkbook>(){

                    @Override
                    public XSSFWorkbook run() throws Exception {
                        return new XSSFWorkbook(is);
                    }
                });
            }
            catch (IOException e) {
                throw new DocumentReadException("Can't open spreadsheet.", e);
            }
            catch (OpenXML4JRuntimeException e) {
                String string;
                block31: {
                    string = builder.toString();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            if (!LOG.isTraceEnabled()) break block31;
                            LOG.trace((Object)("An exception occurred: " + e2.getMessage()));
                        }
                    }
                }
                return string;
            }
            for (int sheetNum = 0; sheetNum < wb.getNumberOfSheets(); ++sheetNum) {
                XSSFSheet sheet = wb.getSheetAt(sheetNum);
                if (sheet == null) continue;
                for (int rowNum = sheet.getFirstRowNum(); rowNum <= sheet.getLastRowNum(); ++rowNum) {
                    XSSFRow row = sheet.getRow(rowNum);
                    if (row == null) continue;
                    int lastcell = row.getLastCellNum();
                    block25: for (int k = 0; k < lastcell; ++k) {
                        XSSFCell cell = row.getCell(k);
                        if (cell == null) continue;
                        switch (cell.getCellType()) {
                            case 0: {
                                double d = cell.getNumericCellValue();
                                if (MSXExcelDocumentReader.isCellDateFormatted(cell)) {
                                    Date date = HSSFDateUtil.getJavaDate((double)d);
                                    String cellText = dateFormat.format(date);
                                    builder.append(cellText).append(" ");
                                    continue block25;
                                }
                                builder.append(d).append(" ");
                                continue block25;
                            }
                            case 2: {
                                builder.append(cell.getCellFormula().toString()).append(" ");
                                continue block25;
                            }
                            case 4: {
                                builder.append(cell.getBooleanCellValue()).append(" ");
                                continue block25;
                            }
                            case 5: {
                                builder.append(cell.getErrorCellValue()).append(" ");
                                continue block25;
                            }
                            case 1: {
                                builder.append(cell.getStringCellValue().toString()).append(" ");
                                continue block25;
                            }
                        }
                    }
                }
            }
        }
        finally {
            block33: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block33;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
        return builder.toString();
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(final InputStream is) throws IOException, DocumentReadException {
        POIPropertiesReader reader = new POIPropertiesReader();
        reader.readDCProperties((POIXMLDocument)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<XSSFWorkbook>(){

            @Override
            public XSSFWorkbook run() throws Exception {
                return new XSSFWorkbook(is);
            }
        }));
        return reader.getProperties();
    }

    public static boolean isCellDateFormatted(XSSFCell cell) {
        boolean bDate = false;
        double d = cell.getNumericCellValue();
        if (HSSFDateUtil.isValidExcelDate((double)d)) {
            XSSFCellStyle style = cell.getCellStyle();
            short i = style.getDataFormat();
            switch (i) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 45: 
                case 46: 
                case 47: 
                case 165: 
                case 167: 
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: {
                    bDate = true;
                    break;
                }
                default: {
                    bDate = false;
                }
            }
        }
        return bDate;
    }
}

