/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.observation;

import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ExtendedWorkspace;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.CompositeChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.jcr.impl.core.observation.EventImpl;
import org.exoplatform.services.jcr.impl.core.observation.ListenerCriteria;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerRegistry;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ActionLauncher
implements ItemsPersistenceListener {
    public final int SKIP_EVENT = Integer.MIN_VALUE;
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.ActionLauncher");
    private final ObservationManagerRegistry observationRegistry;
    private final WorkspacePersistentDataManager workspaceDataManager;
    private final SessionRegistry sessionRegistry;

    public ActionLauncher(ObservationManagerRegistry registry, WorkspacePersistentDataManager workspaceDataManager, SessionRegistry sessionRegistry) {
        this.observationRegistry = registry;
        this.workspaceDataManager = workspaceDataManager;
        this.sessionRegistry = sessionRegistry;
        this.workspaceDataManager.addItemPersistenceListener(this);
    }

    public void onSaveItems(ItemStateChangesLog changesLog) {
        EventListenerIterator eventListeners = this.observationRegistry.getEventListeners();
        while (eventListeners.hasNext()) {
            EventListener listener = eventListeners.nextEventListener();
            ListenerCriteria criteria = this.observationRegistry.getListenerFilter(listener);
            EntityCollection events = new EntityCollection();
            ChangesLogIterator logIterator = ((CompositeChangesLog)changesLog).getLogIterator();
            while (logIterator.hasNextLog()) {
                PlainChangesLog subLog = logIterator.nextLog();
                String sessionId = subLog.getSessionId();
                ExtendedSession userSession = subLog.getSession() != null ? subLog.getSession() : this.sessionRegistry.getSession(sessionId);
                if (userSession == null) continue;
                for (ItemState itemState : subLog.getAllStates()) {
                    if (!itemState.isEventFire()) continue;
                    ItemData item = itemState.getData();
                    try {
                        int eventType = this.eventType(itemState);
                        if (eventType == Integer.MIN_VALUE || !this.isTypeMatch(criteria, eventType) || !this.isPathMatch(criteria, item, userSession) || !this.isIdentifierMatch(criteria, item) || !this.isNodeTypeMatch(criteria, item, userSession, subLog) || !this.isSessionMatch(criteria, sessionId)) continue;
                        String path = userSession.getLocationFactory().createJCRPath(item.getQPath()).getAsString(false);
                        events.add(new EventImpl(eventType, path, userSession.getUserID()));
                    }
                    catch (RepositoryException e) {
                        this.log.error((Object)("Can not fire ActionLauncher.onSaveItems() for " + item.getQPath().getAsString() + " reason: " + e.getMessage()));
                    }
                }
            }
            if (events.getSize() <= 0L) continue;
            listener.onEvent((EventIterator)events);
        }
    }

    private boolean isTypeMatch(ListenerCriteria criteria, int state) {
        return (criteria.getEventTypes() & state) > 0;
    }

    private boolean isSessionMatch(ListenerCriteria criteria, String sessionId) {
        return !criteria.getNoLocal() || !criteria.getSessionId().equals(sessionId);
    }

    private boolean isPathMatch(ListenerCriteria criteria, ItemData item, ExtendedSession userSession) {
        if (criteria.getAbsPath() == null) {
            return true;
        }
        try {
            QPath cLoc = userSession.getLocationFactory().parseAbsPath(criteria.getAbsPath()).getInternalPath();
            QPath itemPath = item.getQPath();
            return itemPath.isDescendantOf(cLoc, !criteria.isDeep());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private boolean isIdentifierMatch(ListenerCriteria criteria, ItemData item) {
        if (criteria.getIdentifier() == null) {
            return true;
        }
        for (int i = 0; i < criteria.getIdentifier().length; ++i) {
            if (item.isNode() && criteria.getIdentifier()[i].equals(item.getIdentifier())) {
                return true;
            }
            if (item.isNode() || !criteria.getIdentifier()[i].equals(item.getParentIdentifier())) continue;
            return true;
        }
        return false;
    }

    private boolean isNodeTypeMatch(ListenerCriteria criteria, ItemData item, ExtendedSession userSession, PlainChangesLog changesLog) throws RepositoryException {
        if (criteria.getNodeTypeName() == null) {
            return true;
        }
        NodeData node = (NodeData)this.workspaceDataManager.getItemData(item.getParentIdentifier());
        if (node == null) {
            List<ItemState> states = changesLog.getAllStates();
            for (int i = states.size() - 1; i >= 0; --i) {
                if (!states.get(i).getData().getIdentifier().equals(item.getParentIdentifier())) continue;
                node = (NodeData)states.get(i).getData();
                break;
            }
            if (node == null) {
                this.log.warn((Object)("Item's " + item.getQPath().getAsString() + " associated parent (" + item.getParentIdentifier() + ") can't be found nor in workspace nor in current changes. Nodetype filter is rejected."));
                return false;
            }
        }
        NodeTypeDataManager ntManager = ((ExtendedWorkspace)userSession.getWorkspace()).getNodeTypesHolder();
        LocationFactory locationFactory = userSession.getLocationFactory();
        for (int i = 0; i < criteria.getNodeTypeName().length; ++i) {
            InternalQName name = locationFactory.parseJCRName(criteria.getNodeTypeName()[i]).getInternalName();
            NodeTypeData criteriaNT = ntManager.getNodeType(name);
            InternalQName[] testQNames = criteriaNT.isMixin() ? node.getMixinTypeNames() : new InternalQName[]{node.getPrimaryTypeName()};
            if (!ntManager.isNodeType(criteriaNT.getName(), testQNames)) continue;
            return true;
        }
        return false;
    }

    private int eventType(ItemState state) throws RepositoryException {
        if (state.getData().isNode()) {
            if (state.isAdded() || state.isRenamed() || state.isUpdated()) {
                return 1;
            }
            if (state.isDeleted()) {
                return 2;
            }
            if (state.isUpdated()) {
                return Integer.MIN_VALUE;
            }
            if (state.isUnchanged()) {
                return Integer.MIN_VALUE;
            }
        } else {
            if (state.isAdded()) {
                return 4;
            }
            if (state.isDeleted()) {
                return 8;
            }
            if (state.isUpdated()) {
                return 16;
            }
            if (state.isUnchanged()) {
                return Integer.MIN_VALUE;
            }
        }
        throw new RepositoryException("Unexpected ItemState for Node " + ItemState.nameFromValue(state.getState()) + " " + state.getData().getQPath().getAsString());
    }

    public boolean isTXAware() {
        return false;
    }
}

