/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;

public class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static Class loadClass(String className) {
        try {
            return ClassLoaderUtil.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new JbpmException("class not found: " + className, e);
        }
    }

    public static Class classForName(String className) {
        try {
            return Class.forName(className, false, ClassLoaderUtil.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new JbpmException("class not found: " + className, e);
        }
    }

    public static Class classForName(String className, boolean useConfiguredLoader) {
        if (useConfiguredLoader) {
            return ClassLoaderUtil.classForName(className);
        }
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className, false, ClassLoaderUtil.class.getClassLoader());
            }
            catch (ClassNotFoundException e2) {
                throw new JbpmException("class not found: " + className, e2);
            }
        }
    }

    public static ClassLoader getClassLoader() {
        if (JbpmConfiguration.Configs.hasObject("jbpm.class.loader")) {
            String jbpmClassLoader = JbpmConfiguration.Configs.getString("jbpm.class.loader");
            if (jbpmClassLoader.equals("jbpm")) {
                return ClassLoaderUtil.class.getClassLoader();
            }
            if (jbpmClassLoader.equals("context")) {
                return Thread.currentThread().getContextClassLoader();
            }
            Object bean = JbpmConfiguration.Configs.getObject(jbpmClassLoader);
            if (!(bean instanceof ClassLoader)) {
                throw new JbpmException("bean '" + jbpmClassLoader + "' is not a class loader");
            }
            return (ClassLoader)bean;
        }
        return ClassLoaderUtil.class.getClassLoader();
    }

    public static InputStream getStream(String resource) {
        return ClassLoaderUtil.getClassLoader().getResourceAsStream(resource);
    }

    public static InputStream getStream(String resource, boolean useConfiguredLoader) {
        if (useConfiguredLoader) {
            return ClassLoaderUtil.getStream(resource);
        }
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            stream = ClassLoaderUtil.class.getClassLoader().getResourceAsStream(resource);
        }
        return stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getProperties(String resource) {
        Properties properties2;
        InputStream inStream = ClassLoaderUtil.getStream(resource);
        if (inStream == null) {
            throw new JbpmException("resource not found: " + resource);
        }
        try {
            Properties properties = new Properties();
            properties.load(inStream);
            properties2 = properties;
        }
        catch (IOException e) {
            try {
                throw new JbpmException("could not load properties from resource: " + resource, e);
            }
            catch (Throwable throwable) {
                try {
                    inStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    Log log = LogFactory.getLog((Class)ClassLoaderUtil.class);
                    log.warn((Object)("failed to close resource: " + resource), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            inStream.close();
            return properties2;
        }
        catch (IOException e) {
            Log log = LogFactory.getLog((Class)ClassLoaderUtil.class);
            log.warn((Object)("failed to close resource: " + resource), (Throwable)e);
        }
        return properties2;
    }
}

