/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion;

import javax.jcr.Node;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.BaseWebSchemaHandler;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;

public class StageAndVersionPublicationHandler
extends BaseWebSchemaHandler {
    private static final Log LOG = ExoLogger.getLogger(StageAndVersionPublicationHandler.class);
    private TemplateService templateService;
    private WCMPublicationService publicationService;

    public StageAndVersionPublicationHandler(TemplateService templateService, WCMPublicationService publicationService) {
        this.templateService = templateService;
        this.publicationService = publicationService;
    }

    protected String getHandlerNodeType() {
        return null;
    }

    protected String getParentNodeType() {
        return null;
    }

    public boolean matchHandler(Node node, SessionProvider sessionProvider) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)container.getComponentInstanceOfType(WebSchemaConfigService.class);
        WebContentSchemaHandler webContentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        if (webContentSchemaHandler.isWebcontentChildNode(node)) {
            return false;
        }
        if (node.isNodeType("exo:cssFile") || node.isNodeType("exo:jsFile")) {
            return false;
        }
        String primaryNodeType = node.getPrimaryNodeType().getName();
        return this.templateService.isManagedNodeType(primaryNodeType);
    }

    public void onCreateNode(Node node, SessionProvider sessionProvider) throws Exception {
        String remoteUser;
        String siteName;
        Node checkNode;
        block6: {
            checkNode = node;
            if (node.isNodeType("nt:file")) {
                Node parentNode;
                if (node.canAddMixin("exo:rss-enable")) {
                    node.addMixin("exo:rss-enable");
                    if (!node.hasProperty("exo:title")) {
                        node.setProperty("exo:title", node.getName());
                    }
                }
                if ((parentNode = node.getParent()).isNodeType("exo:webContent")) {
                    checkNode = parentNode;
                }
            }
            siteName = null;
            remoteUser = null;
            try {
                siteName = Util.getPortalRequestContext().getPortalOwner();
                remoteUser = Util.getPortalRequestContext().getRemoteUser();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block6;
                LOG.warn((Object)e.getMessage());
            }
        }
        this.publicationService.updateLifecyleOnChangeContent(checkNode, siteName, remoteUser);
    }

    public void onModifyNode(Node node, SessionProvider sessionProvider) throws Exception {
        Node parentNode;
        if (node.isNew()) {
            return;
        }
        Node checkNode = node;
        if (node.isNodeType("nt:file") && (parentNode = node.getParent()).isNodeType("exo:webContent")) {
            checkNode = parentNode;
        }
        String siteName = Util.getPortalRequestContext().getPortalOwner();
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        this.publicationService.updateLifecyleOnChangeContent(checkNode, siteName, remoteUser);
    }
}

