/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.lexer.Keyword;
import com.google.caja.util.SafeIdentifierMaker;
import junit.framework.TestCase;

public class SafeIdentifierMakerTest
extends TestCase {
    public final void testSeries() {
        SafeIdentifierMaker maker = new SafeIdentifierMaker("abc".toCharArray());
        SafeIdentifierMakerTest.assertEquals((String)"a", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"b", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"c", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"aa", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"ab", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"ac", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"ba", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"bb", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"bc", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"ca", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"cb", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"cc", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"aaa", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"aab", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"aac", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"aba", (String)((String)maker.next()));
    }

    public final void testNoKeywords() {
        SafeIdentifierMakerTest.assertTrue((boolean)Keyword.isKeyword("in"));
        SafeIdentifierMaker maker = new SafeIdentifierMaker("in".toCharArray());
        SafeIdentifierMakerTest.assertEquals((String)"i", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"n", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"ii", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"ni", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"nn", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"iii", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"iin", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"ini", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"inn", (String)((String)maker.next()));
    }

    public final void testNoEval() {
        String s;
        SafeIdentifierMaker maker = new SafeIdentifierMaker("aelv".toCharArray());
        SafeIdentifierMakerTest.assertEquals((String)"a", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"e", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"l", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"v", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"aa", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"ae", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"al", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"av", (String)((String)maker.next()));
        int i = 12;
        while (--i >= 0) {
            s = (String)maker.next();
            SafeIdentifierMakerTest.assertEquals((String)s, (int)2, (int)s.length());
        }
        i = 64;
        while (--i >= 0) {
            s = (String)maker.next();
            SafeIdentifierMakerTest.assertEquals((String)s, (int)3, (int)s.length());
        }
        i = 64;
        while (--i >= 0) {
            s = (String)maker.next();
            SafeIdentifierMakerTest.assertEquals((String)s, (int)4, (int)s.length());
            SafeIdentifierMakerTest.assertTrue((String)s, (boolean)s.startsWith("a"));
        }
        i = 48;
        while (--i >= 0) {
            s = (String)maker.next();
            SafeIdentifierMakerTest.assertEquals((String)s, (int)4, (int)s.length());
            SafeIdentifierMakerTest.assertTrue((String)s, (s.startsWith("e") && !s.startsWith("ev") ? 1 : 0) != 0);
        }
        SafeIdentifierMakerTest.assertEquals((String)"evaa", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"evae", (String)((String)maker.next()));
        SafeIdentifierMakerTest.assertEquals((String)"evav", (String)((String)maker.next()));
        i = 12;
        while (--i >= 0) {
            s = (String)maker.next();
            SafeIdentifierMakerTest.assertEquals((String)s, (int)4, (int)s.length());
            SafeIdentifierMakerTest.assertTrue((String)s, (s.startsWith("eve") || s.startsWith("evl") || s.startsWith("evv") ? 1 : 0) != 0);
        }
        i = 128;
        while (--i >= 0) {
            s = (String)maker.next();
            SafeIdentifierMakerTest.assertEquals((String)s, (int)4, (int)s.length());
            SafeIdentifierMakerTest.assertTrue((String)s, (s.startsWith("l") || s.startsWith("v") ? 1 : 0) != 0);
        }
        SafeIdentifierMakerTest.assertEquals((String)"aaaaa", (String)((String)maker.next()));
    }
}

