/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterCategoryHandler {
    private static Log log = ExoLogger.getLogger(NewsletterCategoryHandler.class);
    private RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
    private String workspace;
    private boolean isRemove;

    public boolean isRemove() {
        return this.isRemove;
    }

    public void setRemove(boolean isRemove) {
        this.isRemove = isRemove;
    }

    @Deprecated
    public NewsletterCategoryHandler(String repository, String workspace) {
        this.workspace = workspace;
    }

    public NewsletterCategoryHandler(String workspace) {
        this.workspace = workspace;
    }

    public NewsletterCategoryConfig getCategoryFromNode(Node categoryNode) throws Exception {
        NewsletterCategoryConfig categoryConfig = null;
        categoryConfig = new NewsletterCategoryConfig();
        categoryConfig.setName(categoryNode.getName());
        categoryConfig.setTitle(categoryNode.getProperty("exo:newsletterCategoryTitle").getString());
        if (categoryNode.hasProperty("exo:newsletterCategoryDescription")) {
            categoryConfig.setDescription(categoryNode.getProperty("exo:newsletterCategoryDescription").getString());
        }
        StringBuffer permission = new StringBuffer();
        for (String per : NewsletterConstant.getAllPermissionOfNode(categoryNode)) {
            if (permission.length() > 0) {
                permission.append(",");
            }
            permission.append(per);
        }
        categoryConfig.setModerator(permission.toString());
        return categoryConfig;
    }

    public Node getCategoryFromConfig(SessionProvider sessionProvider, String portalName, NewsletterCategoryConfig config) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
        Node categoriesNode = (Node)session.getItem(categoryPath);
        return categoriesNode.getNode(config.getName());
    }

    private List<String> updatePermissionForCategoryNode(Node categoryNode, NewsletterCategoryConfig categoryConfig, boolean isAddNew) {
        ArrayList<String> afterRemovePermisions;
        block8: {
            ExtendedNode extendedCategoryNode = (ExtendedNode)ExtendedNode.class.cast(categoryNode);
            afterRemovePermisions = new ArrayList<String>();
            try {
                if (extendedCategoryNode.canAddMixin("exo:privilegeable") || extendedCategoryNode.isNodeType("exo:privilegeable")) {
                    Node categoriesNode;
                    if (extendedCategoryNode.canAddMixin("exo:privilegeable")) {
                        extendedCategoryNode.addMixin("exo:privilegeable");
                    }
                    ArrayList<String> newModerators = new ArrayList<String>();
                    newModerators.addAll(Arrays.asList(categoryConfig.getModerator().split(",")));
                    String[] permissions = new String[]{"remove", "add_node", "set_property"};
                    NewsletterConstant.addPermissionsFromCateToSubs(categoryNode, newModerators.toArray(new String[0]), permissions);
                    permissions = new String[]{"read", "add_node", "remove", "set_property"};
                    for (String permission : newModerators) {
                        extendedCategoryNode.setPermission(permission, permissions);
                    }
                    if (isAddNew && (categoriesNode = categoryNode.getParent()).hasProperty("exo:newsletteraddministrator")) {
                        Value[] values = categoriesNode.getProperty("exo:newsletteraddministrator").getValues();
                        for (String admin : NewsletterConstant.convertValuesToArray(values)) {
                            if (newModerators.contains(admin)) continue;
                            extendedCategoryNode.setPermission(admin, permissions);
                            newModerators.add(admin);
                        }
                    }
                    for (String oldPer : NewsletterConstant.getAllPermissionOfNode(categoryNode)) {
                        if (newModerators.contains(oldPer)) continue;
                        extendedCategoryNode.removePermission(oldPer, "add_node");
                        extendedCategoryNode.removePermission(oldPer, "remove");
                        extendedCategoryNode.removePermission(oldPer, "set_property");
                        extendedCategoryNode.removePermission(oldPer, "add_node,set_property,remove");
                        extendedCategoryNode.setPermission(oldPer, new String[]{"read"});
                        afterRemovePermisions.add(oldPer);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block8;
                log.error((Object)("Update permission for category " + categoryConfig.getName() + " failed because of: "), (Throwable)e);
            }
        }
        return afterRemovePermisions;
    }

    public void add(SessionProvider sessionProvider, String portalName, NewsletterCategoryConfig categoryConfig) {
        block4: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Trying to add category " + categoryConfig.getName()));
            }
            try {
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(this.workspace, manageableRepository);
                String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
                Node categoriesNode = (Node)session.getItem(categoryPath);
                Node categoryNode = categoriesNode.addNode(categoryConfig.getName(), "exo:newsletterCategory");
                ExtendedNode extendedTemplateNode = (ExtendedNode)ExtendedNode.class.cast(categoryNode.addNode("Templates", "nt:unstructured"));
                if (extendedTemplateNode.canAddMixin("exo:privilegeable")) {
                    extendedTemplateNode.addMixin("exo:privilegeable");
                    extendedTemplateNode.setPermission("any", new String[]{"add_node", "read"});
                }
                ExtendedNode extendedCategoryNode = (ExtendedNode)ExtendedNode.class.cast(categoryNode);
                extendedCategoryNode.setProperty("exo:newsletterCategoryTitle", categoryConfig.getTitle());
                extendedCategoryNode.setProperty("exo:newsletterCategoryDescription", categoryConfig.getDescription());
                this.updatePermissionForCategoryNode(categoryNode, categoryConfig, true);
                session.save();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Add category " + categoryConfig.getName() + " failed because of: "), (Throwable)e);
            }
        }
    }

    public void edit(SessionProvider sessionProvider, String portalName, NewsletterCategoryConfig categoryConfig) {
        block6: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Trying to edit category " + categoryConfig.getName()));
            }
            try {
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(this.workspace, manageableRepository);
                String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
                Node categoryNode = ((Node)session.getItem(categoryPath)).getNode(categoryConfig.getName());
                categoryNode.setProperty("exo:newsletterCategoryDescription", categoryConfig.getDescription());
                categoryNode.setProperty("exo:newsletterCategoryTitle", categoryConfig.getTitle());
                List<String> candicateRemove = this.updatePermissionForCategoryNode(categoryNode, categoryConfig, false);
                if (this.isRemove) {
                    List<String> ableToRemove = NewsletterConstant.removePermission(null, categoryNode, candicateRemove, false, portalName, session);
                    String[] removePer = new String[ableToRemove.size()];
                    NewsletterConstant.removeAccessPermission(ableToRemove.toArray(removePer));
                }
                session.save();
            }
            catch (ItemNotFoundException ie) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Edit category " + categoryConfig.getName() + " failed because of "), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) break block6;
                log.info((Object)("Edit category " + categoryConfig.getName() + " failed because of "), (Throwable)e);
            }
        }
    }

    public void delete(SessionProvider sessionProvider, String portalName, String categoryName) {
        block4: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Trying to delete category " + categoryName));
            }
            try {
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(this.workspace, manageableRepository);
                String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
                Node categoryNode = ((Node)session.getItem(categoryPath)).getNode(categoryName);
                List<String> candicateRemove = NewsletterConstant.getAllPermissionOfNode((Node)session.getItem(categoryPath));
                if (this.isRemove) {
                    List<String> ableToRemove = NewsletterConstant.removePermission(null, categoryNode, candicateRemove, false, portalName, session);
                    String[] removePer = new String[ableToRemove.size()];
                    NewsletterConstant.removeAccessPermission(ableToRemove.toArray(removePer));
                }
                categoryNode.remove();
                session.save();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Delete category " + categoryName + " failed because of "), (Throwable)e);
            }
        }
    }

    public NewsletterCategoryConfig getCategoryByName(SessionProvider sessionProvider, String portalName, String categoryName) throws Exception {
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
            Node categoriesNode = (Node)session.getItem(categoryPath);
            return this.getCategoryFromNode(categoriesNode.getNode(categoryName));
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Error when getCategoryByName: " + ex));
            }
            return null;
        }
    }

    public List<NewsletterCategoryConfig> getListCategories(String portalName, SessionProvider sessionProvider) throws Exception {
        ArrayList<NewsletterCategoryConfig> listCategories;
        block3: {
            listCategories = new ArrayList<NewsletterCategoryConfig>();
            NodeIterator nodeIterator = null;
            try {
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(this.workspace, manageableRepository);
                String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
                Node categoriesNode = (Node)session.getItem(categoryPath);
                nodeIterator = categoriesNode.getNodes();
                while (nodeIterator.hasNext()) {
                    listCategories.add(this.getCategoryFromNode(nodeIterator.nextNode()));
                }
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Get category " + nodeIterator.nextNode().getName() + " failed because of "), (Throwable)ex);
            }
        }
        return listCategories;
    }

    public List<NewsletterCategoryConfig> getListCategoriesCanView(String portalName, String userName, SessionProvider sessionProvider) throws Exception {
        ArrayList<NewsletterCategoryConfig> listCategories = new ArrayList<NewsletterCategoryConfig>();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
        Node categoriesNode = (Node)session.getItem(categoryPath);
        Node categoryNode = null;
        Node subNode = null;
        NodeIterator categoryIterator = categoriesNode.getNodes();
        block0: while (categoryIterator.hasNext()) {
            categoryNode = categoryIterator.nextNode();
            if (NewsletterConstant.hasPermission(userName, categoryNode)) {
                listCategories.add(this.getCategoryFromNode(categoryNode));
                continue;
            }
            NodeIterator subscriptionIterator = categoriesNode.getNodes();
            while (subscriptionIterator.hasNext()) {
                subNode = subscriptionIterator.nextNode();
                if (!subNode.isNodeType("exo:newsletterSubscription") || !NewsletterConstant.hasPermission(userName, subNode)) continue;
                listCategories.add(this.getCategoryFromNode(categoryNode));
                continue block0;
            }
        }
        return listCategories;
    }
}

