/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.impl;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationPresentationService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;

public class PublicationPresentationServiceImpl
implements PublicationPresentationService {
    protected static Log log;
    private Map<String, PublicationPlugin> publicationPlugins_ = new HashMap<String, PublicationPlugin>();

    public PublicationPresentationServiceImpl() {
        log = ExoLogger.getLogger((String)"portal:PublicationPresentationServiceImpl");
        if (log.isInfoEnabled()) {
            log.info((Object)"# PublicationPresentationService initialization #");
        }
        this.publicationPlugins_ = new HashMap<String, PublicationPlugin>();
    }

    public UIForm getStateUI(Node node, UIComponent component) throws NotInPublicationLifecycleException, Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
        if (!publicationService.isNodeEnrolledInLifecycle(node)) {
            throw new NotInPublicationLifecycleException();
        }
        String lifecycleName = publicationService.getNodeLifecycleName(node);
        PublicationPlugin nodePlugin = this.publicationPlugins_.get(lifecycleName);
        return nodePlugin.getStateUI(node, component);
    }

    public void addPublicationPlugin(PublicationPlugin p) {
        this.publicationPlugins_.put(p.getLifecycleName(), p);
    }
}

