/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.post;

import javax.jcr.Item;
import javax.jcr.Node;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.webdav.WebDavService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostWebDavUploadEventListener
extends Listener<WebDavService, Node> {
    private WCMPublicationService publicationService;
    private static final Log LOG = ExoLogger.getLogger(PostWebDavUploadEventListener.class);

    public PostWebDavUploadEventListener(WCMPublicationService publicationService) {
        this.publicationService = publicationService;
    }

    public void onEvent(Event<WebDavService, Node> event) throws Exception {
        block4: {
            Node currentNode = null;
            try {
                currentNode = (Node)event.getData();
                LinkManager linkMng = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
                if (linkMng.isLink((Item)currentNode)) {
                    currentNode = linkMng.getTarget(currentNode);
                }
                if (currentNode == null || currentNode.isNodeType("exo:cssFile") || currentNode.isNodeType("exo:template") || currentNode.isNodeType("exo:jsFile") || currentNode.isNodeType("exo:action")) {
                    return;
                }
                this.publicationService.updateLifecyleOnChangeContent(currentNode, "", currentNode.getSession().getUserID());
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"An expected exception has occured: ", (Throwable)ex);
            }
        }
    }
}

