/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.comparator;

import java.util.Calendar;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyValueComparator
implements Comparator<Node> {
    public static final String ASCENDING_ORDER = "Ascending";
    public static final String DESCENDING_ORDER = "Descending";
    private String propertyName;
    private String orderType;
    private static final Log LOG = ExoLogger.getLogger((String)"webui.PropertyValueComparator");

    public PropertyValueComparator(String propertyName, String orderType) {
        this.propertyName = propertyName;
        this.orderType = orderType;
    }

    @Override
    public int compare(Node node0, Node node1) {
        int flipFlop = ASCENDING_ORDER.equals(this.orderType) ? 1 : -1;
        int requireType = this.getRequireType(node0);
        int requireType2 = this.getRequireType(node1);
        if (requireType == -1 && requireType2 == -1) {
            return 0;
        }
        if (requireType == -1 && requireType2 != -1) {
            return -1 * flipFlop;
        }
        if (requireType != -1 && requireType2 == -1) {
            return 1 * flipFlop;
        }
        try {
            switch (requireType) {
                case 2: {
                    return this.compareString(node0, node1);
                }
                case 6: {
                    return this.compareString(node0, node1);
                }
                case 7: {
                    return this.compareString(node0, node1);
                }
                case 8: {
                    return this.compareString(node0, node1);
                }
                case 1: {
                    return this.compareString(node0, node1);
                }
                case 3: {
                    return this.compareString(node0, node1);
                }
                case 4: {
                    return this.compareString(node0, node1);
                }
                case 5: {
                    return this.compareDate(node0, node1);
                }
                case 9: {
                    return this.compareString(node0, node1);
                }
            }
            throw new RepositoryException("Unknown type " + requireType);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Unexpected error", (Throwable)e);
            }
            return 0;
        }
    }

    private int getRequireType(Node node) {
        try {
            if (node.hasProperty(this.propertyName)) {
                return node.getProperty(this.propertyName).getDefinition().getRequiredType();
            }
            return -1;
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
            return -1;
        }
    }

    private int compareString(Node node0, Node node1) {
        try {
            String propertyValue1;
            String propertyValue0 = node0.getProperty(this.propertyName) == null ? "" : String.valueOf(node0.getProperty(this.propertyName).getString());
            String string = propertyValue1 = node1.getProperty(this.propertyName) == null ? "" : String.valueOf(node1.getProperty(this.propertyName).getString());
            if (ASCENDING_ORDER.equals(this.orderType)) {
                return propertyValue0.compareToIgnoreCase(propertyValue1);
            }
            return propertyValue1.compareToIgnoreCase(propertyValue0);
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
            return 0;
        }
    }

    public int compareDate(Node node0, Node node1) {
        try {
            Calendar date0 = node0.getProperty(this.propertyName).getDate();
            Calendar date1 = node1.getProperty(this.propertyName).getDate();
            if (ASCENDING_ORDER.equals(this.orderType)) {
                return date0.compareTo(date1);
            }
            return date1.compareTo(date0);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
            return 0;
        }
    }
}

