/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.InspectionLog;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataNotFoundException;
import org.exoplatform.services.jcr.impl.storage.value.ValueStorageNotFoundException;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JDBCWorkspaceDataContainerChecker {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCWorkspaceDataContainerChecker");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkDB(JDBCWorkspaceDataContainer jdbcDataContainer, InspectionLog inspectionLog) throws RepositoryException, IOException {
        HashSet<InspectionQuery> queries = new HashSet<InspectionQuery>();
        class InspectionQuery {
            private final String statement;
            private final String description;
            private final String[] fieldNames;
            private final InspectionLog.InspectionStatus status;

            public InspectionQuery(String statement, String[] fieldNames, String headerMessage, InspectionLog.InspectionStatus status) {
                this.statement = statement;
                this.description = headerMessage;
                this.fieldNames = fieldNames;
                this.status = status;
            }

            public String getStatement() {
                return this.statement;
            }

            public String getDescription() {
                return this.description;
            }

            public String[] getFieldNames() {
                return this.fieldNames;
            }

            public InspectionLog.InspectionStatus getStatus() {
                return this.status;
            }
        }
        queries.add(new InspectionQuery(jdbcDataContainer.multiDb ? "select * from JCR_MITEM I where NOT EXISTS(select * from JCR_MITEM P where P.ID = I.PARENT_ID)" : "select * from JCR_SITEM I where I.CONTAINER_NAME='" + jdbcDataContainer.containerName + "' and NOT EXISTS(select * from JCR_SITEM P where P.ID = I.PARENT_ID)", new String[]{"ID", "PARENT_ID", "NAME", "I_CLASS"}, "Items that do not have parent nodes", InspectionLog.InspectionStatus.ERR));
        queries.add(new InspectionQuery(jdbcDataContainer.multiDb ? "select * from JCR_MITEM N where N.I_CLASS=1 and NOT EXISTS (select * from JCR_MITEM P where P.I_CLASS=2 and P.PARENT_ID=N.ID)" : "select * from JCR_SITEM N where N.CONTAINER_NAME='" + jdbcDataContainer.containerName + "' and N.I_CLASS=1 and NOT EXISTS (select * from JCR_SITEM P " + "where P.I_CLASS=2 and P.PARENT_ID=N.ID and P.CONTAINER_NAME='" + jdbcDataContainer.containerName + "')", new String[]{"ID", "PARENT_ID", "NAME"}, "Nodes that do not have at least one property", InspectionLog.InspectionStatus.ERR));
        queries.add(new InspectionQuery(jdbcDataContainer.multiDb ? "select * from JCR_MVALUE V where NOT EXISTS(select * from JCR_MITEM P where V.PROPERTY_ID = P.ID and P.I_CLASS=2)" : "select V.* from JCR_SVALUE V, JCR_SITEM I where V.PROPERTY_ID = I.ID and I.CONTAINER_NAME='" + jdbcDataContainer.containerName + "' and NOT EXISTS(select * from JCR_SITEM P where P.CONTAINER_NAME='" + jdbcDataContainer.containerName + "' and V.PROPERTY_ID = P.ID and P.I_CLASS=2)", new String[]{"ID", "PROPERTY_ID"}, "All value records that has not owner-property record", InspectionLog.InspectionStatus.ERR));
        queries.add(new InspectionQuery(jdbcDataContainer.multiDb ? "select * from JCR_MITEM P where P.I_CLASS=2 and NOT EXISTS( select * from JCR_MVALUE V where V.PROPERTY_ID=P.ID)" : "select * from JCR_SITEM P where P.CONTAINER_NAME='" + jdbcDataContainer.containerName + "' and P.I_CLASS=2 and NOT EXISTS( select * from JCR_SVALUE V where V.PROPERTY_ID=P.ID)", new String[]{"ID", "PARENT_ID", "NAME"}, "All properties that have not value record.", InspectionLog.InspectionStatus.ERR));
        String statement = jdbcDataContainer.dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE) ? (jdbcDataContainer.multiDb ? "select * from JCR_MVALUE where (STORAGE_DESC is null and DATA like null) or (STORAGE_DESC is not null and not DATA like null)" : "select V.* from JCR_SVALUE V, JCR_SITEM I where V.PROPERTY_ID = I.ID and I.CONTAINER_NAME='" + jdbcDataContainer.containerName + "'  AND ((STORAGE_DESC is null and DATA like null) or (STORAGE_DESC is not null and not DATA like null))") : (jdbcDataContainer.dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLE) || jdbcDataContainer.dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLEOCI) ? (jdbcDataContainer.multiDb ? "select * from JCR_MVALUE where (STORAGE_DESC is not null and DATA is not null)" : "select V.* from JCR_SVALUE V, JCR_SITEM I where V.PROPERTY_ID = I.ID and I.CONTAINER_NAME='" + jdbcDataContainer.containerName + "'  AND (STORAGE_DESC is not null and DATA is not null)") : (jdbcDataContainer.multiDb ? "select * from JCR_MVALUE where (STORAGE_DESC is null and DATA is null) or (STORAGE_DESC is not null and DATA is not null)" : "select V.* from JCR_SVALUE V, JCR_SITEM I where V.PROPERTY_ID = I.ID and I.CONTAINER_NAME='" + jdbcDataContainer.containerName + "'  AND ((STORAGE_DESC is null and DATA is null) or (STORAGE_DESC is not null and DATA is not null))"));
        queries.add(new InspectionQuery(statement, new String[]{"ID"}, "Incorrect JCR_VALUE records", InspectionLog.InspectionStatus.ERR));
        queries.add(new InspectionQuery(jdbcDataContainer.multiDb ? "select * from JCR_MITEM P where P.P_TYPE=9 and NOT EXISTS (select * from JCR_MREF R where P.ID=R.PROPERTY_ID)" : "select * from JCR_SITEM P where P.CONTAINER_NAME='" + jdbcDataContainer.containerName + "' and P.P_TYPE=9 and NOT EXISTS( select * from JCR_SREF R where P.ID=R.PROPERTY_ID)", new String[]{"ID", "PARENT_ID", "NAME"}, "Reference properties without reference records", InspectionLog.InspectionStatus.ERR));
        queries.add(new InspectionQuery(jdbcDataContainer.multiDb ? "select * from JCR_MREF R where NOT EXISTS(select * from JCR_MITEM N where R.NODE_ID=N.ID)" : "select * from JCR_SREF R, JCR_SITEM I where R.PROPERTY_ID = I.ID and I.CONTAINER_NAME='" + jdbcDataContainer.containerName + "'  and NOT EXISTS(select * from JCR_SITEM N where N.CONTAINER_NAME='" + jdbcDataContainer.containerName + "' and R.NODE_ID=N.ID)", new String[]{"NODE_ID", "PROPERTY_ID", "ORDER_NUM"}, "Reference records that linked to unexisted nodes. Can be normal for some usecases.", InspectionLog.InspectionStatus.WARN));
        queries.add(new InspectionQuery(jdbcDataContainer.multiDb ? "select * from JCR_MITEM I where I.ID = I.PARENT_ID and I.NAME <> '__root_parent'" : "select * from JCR_SITEM I where I.ID = I.PARENT_ID and I.CONTAINER_NAME='" + jdbcDataContainer.containerName + "' and I.NAME <> '" + "__root_parent" + "'", new String[]{"ID", "PARENT_ID", "NAME"}, "An item is its own parent.", InspectionLog.InspectionStatus.ERR));
        queries.add(new InspectionQuery(jdbcDataContainer.multiDb ? "select * from JCR_MITEM I where EXISTS (select * from JCR_MITEM J WHERE I.PARENT_ID = J.PARENT_ID AND I.NAME = J.NAME and I.I_INDEX = J.I_INDEX and I.I_CLASS = J.I_CLASS and I.VERSION != J.VERSION)" : "select * from JCR_SITEM I where I.CONTAINER_NAME='" + jdbcDataContainer.containerName + "' and" + " EXISTS (select * from JCR_SITEM J WHERE I.CONTAINER_NAME = J.CONTAINER_NAME and" + " I.PARENT_ID = J.PARENT_ID AND I.NAME = J.NAME and I.I_INDEX = J.I_INDEX and I.I_CLASS = J.I_CLASS" + " and I.VERSION != J.VERSION)", new String[]{"ID", "PARENT_ID", "NAME", "VERSION", "I_CLASS", "I_INDEX"}, "Several versions of same item.", InspectionLog.InspectionStatus.ERR));
        Connection jdbcConn = jdbcDataContainer.getConnectionFactory().getJdbcConnection();
        for (InspectionQuery query : queries) {
            SQLException e2;
            PreparedStatement st;
            block23: {
                Object var15_15;
                st = null;
                ResultSet resultSet = null;
                try {
                    st = jdbcConn.prepareStatement(query.getStatement());
                    resultSet = st.executeQuery();
                    if (resultSet.next()) {
                        inspectionLog.logInspectionDescription(query.getDescription());
                        do {
                            StringBuilder record = new StringBuilder();
                            for (String fieldName : query.getFieldNames()) {
                                record.append(fieldName);
                                record.append('=');
                                if (fieldName.equals("N_ORDER_NUM") || fieldName.equals("ORDER_NUM")) {
                                    record.append(resultSet.getInt(fieldName));
                                } else {
                                    record.append(resultSet.getString(fieldName));
                                }
                                record.append(' ');
                            }
                            inspectionLog.logBrokenObjectInfo(record.toString(), "", query.getStatus());
                        } while (resultSet.next());
                    }
                    var15_15 = null;
                    if (resultSet == null) break block23;
                }
                catch (Throwable throwable) {
                    var15_15 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e2) {
                            LOG.error((Object)e2.getMessage(), (Throwable)e2);
                        }
                    }
                    if (st == null) throw throwable;
                    try {
                        st.close();
                        throw throwable;
                    }
                    catch (SQLException e2) {
                        LOG.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException e2) {
                    LOG.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
            if (st == null) continue;
            try {
                st.close();
            }
            catch (SQLException e2) {
                LOG.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        Object var18_18 = null;
        if (jdbcConn == null) return;
        try {
            jdbcConn.close();
            return;
        }
        catch (SQLException e3) {
            LOG.error((Object)e3.getMessage(), (Throwable)e3);
        }
        return;
        {
            catch (SQLException e) {
                inspectionLog.logException("Exception during DB inspection.", e);
                Object var18_19 = null;
                if (jdbcConn == null) return;
                try {
                    jdbcConn.close();
                    return;
                }
                catch (SQLException e3) {
                    LOG.error((Object)e3.getMessage(), (Throwable)e3);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            if (jdbcConn == null) throw throwable;
            try {
                jdbcConn.close();
                throw throwable;
            }
            catch (SQLException e3) {
                LOG.error((Object)e3.getMessage(), (Throwable)e3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void checkValueStorage(final JDBCWorkspaceDataContainer jdbcDataContainer, ValueStoragePluginProvider vsPlugin, InspectionLog inspectionLog) throws RepositoryException, IOException {
        block38: {
            SQLException e422;
            ResultSet resultSet;
            PreparedStatement st;
            Connection connection;
            block34: {
                block33: {
                    String valueRecordFormat = "ValueData[PROPERTY_ID=%s ORDER_NUM=%d STORAGE_DESC=%s]";
                    connection = jdbcDataContainer.getConnectionFactory().getJdbcConnection();
                    st = null;
                    resultSet = null;
                    st = connection.prepareStatement(jdbcDataContainer.multiDb ? "SELECT PROPERTY_ID, ORDER_NUM, STORAGE_DESC from JCR_MVALUE where STORAGE_DESC is not null" : "SELECT V.PROPERTY_ID, V.ORDER_NUM, V.STORAGE_DESC from JCR_SVALUE V, JCR_SITEM I where I.CONTAINER_NAME='" + jdbcDataContainer.containerName + "' and V.PROPERTY_ID = I.ID and STORAGE_DESC is not null");
                    resultSet = st.executeQuery();
                    if (!resultSet.next()) break block33;
                    ValueIOChannel channel = null;
                    do {
                        final String propertyId = resultSet.getString("PROPERTY_ID");
                        final int orderNumber = resultSet.getInt("ORDER_NUM");
                        String storageDesc = resultSet.getString("STORAGE_DESC");
                        if (channel == null || !channel.getStorageId().equals(storageDesc)) {
                            try {
                                if (channel != null) {
                                    channel.close();
                                }
                                channel = vsPlugin.getChannel(storageDesc);
                            }
                            catch (ValueStorageNotFoundException e2) {
                                inspectionLog.logBrokenObjectInfo("ValueStorage " + storageDesc + " not found. " + String.format("ValueData[PROPERTY_ID=%s ORDER_NUM=%d STORAGE_DESC=%s]", propertyId, orderNumber, storageDesc), e2.getMessage(), InspectionLog.InspectionStatus.ERR);
                                continue;
                            }
                        }
                        try {
                            final ValueIOChannel vdChannel = channel;
                            SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                @Override
                                public Object run() throws ValueDataNotFoundException, IOException {
                                    vdChannel.checkValueData(jdbcDataContainer.multiDb ? propertyId : propertyId.substring(jdbcDataContainer.containerName.length()), orderNumber);
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException e3) {
                            Throwable ex = e3.getCause();
                            if (ex instanceof ValueDataNotFoundException) {
                                inspectionLog.logBrokenObjectInfo(String.format("ValueData[PROPERTY_ID=%s ORDER_NUM=%d STORAGE_DESC=%s]", propertyId, orderNumber, storageDesc) + " not found.", ex.getMessage(), InspectionLog.InspectionStatus.ERR);
                                continue;
                            }
                            if (ex instanceof IOException) {
                                inspectionLog.logException(ex.getMessage(), (IOException)ex);
                                continue;
                            }
                            throw new RepositoryException(ex.getMessage(), ex);
                        }
                    } while (resultSet.next());
                }
                Object var14_16 = null;
                if (resultSet == null) break block34;
                try {
                    resultSet.close();
                }
                catch (SQLException e422) {
                    LOG.error((Object)e422.getMessage(), (Throwable)e422);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e422) {
                    LOG.error((Object)e422.getMessage(), (Throwable)e422);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e422) {
                    LOG.error((Object)e422.getMessage(), (Throwable)e422);
                }
            }
            break block38;
            {
                catch (SQLException e5) {
                    SQLException e422;
                    inspectionLog.logException("Exception during ValueStorage inspection.", e5);
                    Object var14_17 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e422) {
                            LOG.error((Object)e422.getMessage(), (Throwable)e422);
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e422) {
                            LOG.error((Object)e422.getMessage(), (Throwable)e422);
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e422) {
                            LOG.error((Object)e422.getMessage(), (Throwable)e422);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException e422;
                Object var14_18 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e422) {
                        LOG.error((Object)e422.getMessage(), (Throwable)e422);
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e422) {
                        LOG.error((Object)e422.getMessage(), (Throwable)e422);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e422) {
                        LOG.error((Object)e422.getMessage(), (Throwable)e422);
                    }
                }
                throw throwable;
            }
        }
    }
}

