/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.deployment;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.deployment.DeploymentPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.extensions.deployment.PublicationDeploymentDescriptor;
import org.exoplatform.services.wcm.publication.WCMPublicationService;

public class PublicationDeploymentPlugin
extends DeploymentPlugin {
    private InitParams initParams;
    private RepositoryService repositoryService;
    private WCMPublicationService wcmPublicationService;
    private PublicationService publicationService;
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    public static final String UPDATE_EVENT = "WCMPublicationService.event.updateState";

    public PublicationDeploymentPlugin(InitParams initParams, RepositoryService repositoryService, PublicationService publicationService, WCMPublicationService wcmPublicationService) {
        this.initParams = initParams;
        this.repositoryService = repositoryService;
        this.publicationService = publicationService;
        this.wcmPublicationService = wcmPublicationService;
    }

    public void deploy(SessionProvider sessionProvider) throws Exception {
        Iterator iterator = this.initParams.getObjectParamIterator();
        PublicationDeploymentDescriptor deploymentDescriptor = null;
        try {
            while (iterator.hasNext()) {
                ObjectParameter objectParameter = (ObjectParameter)iterator.next();
                deploymentDescriptor = (PublicationDeploymentDescriptor)objectParameter.getObject();
                List<String> contents = deploymentDescriptor.getContents();
                HashMap<String, String> context_ = new HashMap<String, String>();
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
                String containerName = containerInfo.getContainerName();
                context_.put("containerName", containerName);
                for (String sourcePath : contents) {
                    try {
                        String[] src = sourcePath.split(":");
                        if (src.length == 2) {
                            ManageableRepository repository = this.repositoryService.getCurrentRepository();
                            Session session = sessionProvider.getSession(src[0], repository);
                            Node nodeSrc = session.getRootNode().getNode(src[1].substring(1));
                            this.wcmPublicationService.updateLifecyleOnChangeContent(nodeSrc, "default", "__system", "published");
                            nodeSrc.save();
                        }
                        if (!this.log.isInfoEnabled()) continue;
                        this.log.info((Object)(sourcePath + " has been published."));
                    }
                    catch (Exception ex) {
                        if (!this.log.isErrorEnabled()) continue;
                        this.log.error((Object)("publication for " + sourcePath + " FAILED at " + new Date().toString() + "\n"), (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("publication plugin FAILED at " + new Date().toString() + "\n"), (Throwable)ex);
            }
            throw ex;
        }
    }
}

