/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.io.InputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

@Path(value="/contents/")
public class DownloadConnector
implements ResourceContainer {
    @GET
    @Path(value="/download/{workspace}/{path:.*}/")
    public Response download(@PathParam(value="workspace") String workspace, @PathParam(value="path") String path) throws Exception {
        InputStream is = null;
        Node node = null;
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        try {
            node = (Node)session.getItem(path);
            Node jrcNode = node.getNode("jcr:content");
            is = jrcNode.getProperty("jcr:data").getStream();
        }
        catch (PathNotFoundException pne) {
            return Response.status((int)404).build();
        }
        catch (AccessDeniedException ade) {
            return Response.status((int)401).build();
        }
        return Response.ok((Object)is, (String)"text/xml").header("Content-Disposition", (Object)("attachment; filename=" + Text.unescapeIllegalJcrChars((String)node.getName()))).build();
    }
}

