/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.JCRPathExt;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class JCRPath {
    public static final String ROOT_PATH = "/";
    public static final String ROOT_NAME = "";
    public static final String THIS_RELPATH = ".";
    public static final String PARENT_RELPATH = "..";
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JCRPath");

    public static JCRPath createJCRPath() {
        return JCRPathExt.ROOT;
    }

    public static JCRPath createJCRPath(NamespaceAccessor namespaces, QPath qpath) throws RepositoryException {
        return new JCRPathExt(namespaces, qpath.getEntries());
    }

    public static JCRPath createJCRPath(NamespaceAccessor namespaces, QPathEntry[] relPath) throws RepositoryException {
        return new JCRPathExt(namespaces, relPath);
    }

    public abstract boolean isAbsolute();

    abstract JCRPath addEntry(String var1, String var2, String var3, int var4);

    abstract JCRPath addEntry(PathElement var1);

    abstract JCRPath add(JCRPath var1);

    abstract JCRPath addEntries(PathElement ... var1);

    public abstract JCRPath makeParentPath();

    public abstract JCRPath makeAncestorPath(int var1);

    public abstract PathElement[] getRelPath(int var1);

    public abstract QPath getInternalPath();

    public abstract String getAsString(boolean var1);

    public abstract int getDepth();

    public abstract int getLength();

    public abstract PathElement getEntry(int var1);

    public abstract PathElement[] getEntries();

    public abstract boolean isDescendantOf(JCRPath var1, boolean var2);

    public abstract boolean isAncestorOf(JCRPath var1, boolean var2);

    public abstract PathElement getName();

    public abstract int getIndex();

    public abstract boolean isIndexSetExplicitly();

    public abstract boolean isSameNameSibling(JCRPath var1);

    public abstract boolean equals(Object var1);

    protected JCRPath() {
    }

    public static class PathElement
    extends JCRName {
        private final int index;
        private final boolean indexSetExplicitly;
        private String cachedToString;
        private String cachedToStringShowIndex;

        public PathElement(String namespace, String name, String prefix, int index) {
            super(namespace, name, prefix);
            if (index == -1) {
                this.index = 1;
                this.indexSetExplicitly = false;
            } else {
                this.index = index;
                this.indexSetExplicitly = true;
            }
        }

        public PathElement(InternalQName qname, String prefix, int index) {
            super(qname, prefix);
            if (index == -1) {
                this.index = 1;
                this.indexSetExplicitly = false;
            } else {
                this.index = index;
                this.indexSetExplicitly = true;
            }
        }

        public PathElement(PathElement that, int index) {
            super(that);
            if (index == -1) {
                this.index = 1;
                this.indexSetExplicitly = false;
            } else {
                this.index = index;
                this.indexSetExplicitly = true;
            }
        }

        public PathElement clone(int newIndex) {
            return new PathElement(this, newIndex);
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PathElement)) {
                return false;
            }
            return super.equals(obj) && this.index == ((PathElement)obj).getIndex();
        }

        public String getAsString(boolean showIndex) {
            if (showIndex) {
                if (this.cachedToStringShowIndex != null) {
                    return this.cachedToStringShowIndex;
                }
            } else if (this.cachedToString != null) {
                return this.cachedToString;
            }
            StringBuffer sb = new StringBuffer(super.getAsString());
            if (showIndex || this.getIndex() > 1) {
                sb.append("[").append(this.index).append("]");
            }
            String res = sb.toString();
            if (showIndex) {
                this.cachedToStringShowIndex = res;
            } else {
                this.cachedToString = res;
            }
            return res;
        }

        public boolean isIndexSetExplicitly() {
            return this.indexSetExplicitly;
        }
    }
}

