/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.model;

import org.apache.poi.xwpf.model.XWPFParagraphDecorator;
import org.apache.poi.xwpf.usermodel.XWPFComment;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;

public class XWPFCommentsDecorator
extends XWPFParagraphDecorator {
    private StringBuffer commentText = new StringBuffer();

    public XWPFCommentsDecorator(XWPFParagraphDecorator nextDecorator) {
        this(nextDecorator.paragraph, nextDecorator);
    }

    public XWPFCommentsDecorator(XWPFParagraph paragraph, XWPFParagraphDecorator nextDecorator) {
        super(paragraph, nextDecorator);
        for (CTMarkupRange anchor : paragraph.getCTP().getCommentRangeStartArray()) {
            XWPFComment comment = paragraph.getDocument().getCommentByID(anchor.getId().toString());
            if (comment == null) continue;
            this.commentText.append("\tComment by " + comment.getAuthor() + ": " + comment.getText());
        }
    }

    public String getText() {
        return super.getText() + this.commentText;
    }
}

