/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.folksonomy;

import java.util.ArrayList;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UITagPermissionInfo.msg.confirm-delete-permission")})
public class UITagPermissionInfo
extends UIContainer {
    public static String[] PERMISSION_BEAN_FIELD = new String[]{"usersOrGroups"};
    private static String[] PERMISSION_ACTION = new String[]{"Delete"};

    public UITagPermissionInfo() throws Exception {
        UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, "TagPermissionInfo");
        this.addChild((UIComponent)uiGrid);
        this.updateGrid();
        uiGrid.getUIPageIterator().setId("TagPermissionInfoIterator");
        uiGrid.configure(PERMISSION_BEAN_FIELD[0], PERMISSION_BEAN_FIELD, PERMISSION_ACTION);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.updateGrid();
        super.processRender(context);
    }

    public void updateGrid() throws Exception {
        ArrayList<TagPermissionData> tagPermissions = new ArrayList<TagPermissionData>();
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        for (String usersOrGroups : newFolksonomyService.getTagPermissionList()) {
            tagPermissions.add(new TagPermissionData(usersOrGroups));
        }
        UIGrid uiGrid = (UIGrid)this.findFirstComponentOfType(UIGrid.class);
        int currentPage = uiGrid.getUIPageIterator().getCurrentPage();
        ListAccessImpl tagPermList = new ListAccessImpl(TagPermissionData.class, tagPermissions);
        LazyPageList dataPageList = new LazyPageList((ListAccess)tagPermList, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)dataPageList);
        int total = uiGrid.getUIPageIterator().getAvailablePage();
        uiGrid.getUIPageIterator().setCurrentPage(currentPage < total ? currentPage : total);
    }

    public static class TagPermissionData {
        private String usersOrGroups;

        public TagPermissionData(String usersOrGroups) {
            this.usersOrGroups = usersOrGroups;
        }

        public String getUsersOrGroups() {
            return this.usersOrGroups;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UITagPermissionInfo> {
        public void execute(Event<UITagPermissionInfo> event) throws Exception {
            UITagPermissionInfo uiInfo = (UITagPermissionInfo)((Object)event.getSource());
            String name = event.getRequestContext().getRequestParameter("objectId");
            NewFolksonomyService folksonomyService = (NewFolksonomyService)uiInfo.getApplicationComponent(NewFolksonomyService.class);
            folksonomyService.removeTagPermission(name);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiInfo);
        }
    }
}

