/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.javascript;

import javax.jcr.Node;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.BaseWebSchemaHandler;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.javascript.XJavascriptService;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;

public class JSFileHandler
extends BaseWebSchemaHandler {
    private boolean isPortalJSFolder = false;

    protected String getHandlerNodeType() {
        return "nt:file";
    }

    protected String getParentNodeType() {
        return "exo:jsFolder";
    }

    public boolean matchHandler(SessionProvider sessionProvider, Node node) throws Exception {
        if (!this.matchNodeType(node)) {
            return false;
        }
        if (!this.matchMimeType(node)) {
            return false;
        }
        this.isPortalJSFolder = this.isInPortalJSFolder(sessionProvider, node);
        if (this.isPortalJSFolder) {
            return true;
        }
        return this.matchParenNodeType(node);
    }

    private boolean matchNodeType(Node node) throws Exception {
        return node.getPrimaryNodeType().getName().equals("nt:file");
    }

    private boolean matchParenNodeType(Node node) throws Exception {
        return node.getParent().isNodeType("exo:jsFolder");
    }

    private boolean matchMimeType(Node node) throws Exception {
        String mimeType = this.getFileMimeType(node);
        if ("text/javascript".equals(mimeType)) {
            return true;
        }
        if ("application/x-javascript".equals(mimeType)) {
            return true;
        }
        if ("text/ecmascript".equals(mimeType)) {
            return true;
        }
        return "text/plain".equals(mimeType);
    }

    private boolean isInPortalJSFolder(SessionProvider sessionProvider, Node file) throws Exception {
        Node portal = this.findPortalNode(sessionProvider, file);
        if (portal == null) {
            return false;
        }
        WebSchemaConfigService schemaConfigService = this.getService(WebSchemaConfigService.class);
        PortalFolderSchemaHandler schemaHandler = schemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
        Node jsFolder = schemaHandler.getJSFolder(portal);
        return file.getPath().startsWith(jsFolder.getPath());
    }

    public void onCreateNode(SessionProvider sessionProvider, Node file) throws Exception {
        this.addMixin(file, "exo:jsFile");
        this.addMixin(file, "exo:owneable");
        file.setProperty("exo:presentationType", "exo:jsFile");
        if (this.isPortalJSFolder) {
            file.setProperty("exo:sharedJS", true);
        }
    }

    public void onModifyNode(SessionProvider sessionProvider, Node file) throws Exception {
        if (this.isPortalJSFolder) {
            Node portal = this.findPortalNode(sessionProvider, file);
            XJavascriptService javascriptService = this.getService(XJavascriptService.class);
            javascriptService.updatePortalJSOnModify(portal, file);
        }
    }

    public void onRemoveNode(SessionProvider sessionProvider, Node file) throws Exception {
        if (this.isPortalJSFolder) {
            Node portal = this.findPortalNode(sessionProvider, file);
            XJavascriptService javascriptService = this.getService(XJavascriptService.class);
            javascriptService.updatePortalJSOnRemove(portal, file);
        }
    }
}

