/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayType<A, E> {
    public abstract A create(int var1);

    public abstract E get(A var1, int var2);

    public abstract void set(A var1, int var2, E var3);

    public abstract int size(A var1);

    public static <E> ArrayType<List<E>, E> list(Class<E> componentType) {
        return new ArrayType<List<E>, E>(){

            @Override
            public List<E> create(int size) {
                return new ArrayList();
            }

            @Override
            public E get(List<E> array, int index) {
                return array.get(index);
            }

            @Override
            public void set(List<E> array, int index, E element) {
                while (index >= array.size()) {
                    array.add(null);
                }
                array.set(index, element);
            }

            @Override
            public int size(List<E> array) {
                return array.size();
            }
        };
    }

    public static <E> ArrayType<E[], E> array(final Class<E> componentType) {
        if (componentType.isPrimitive()) {
            throw new IllegalArgumentException("Component type must not be primitive");
        }
        return new ArrayType<E[], E>(){

            @Override
            public E[] create(int size) {
                if (componentType == Boolean.TYPE) {
                    return new boolean[size];
                }
                return (Object[])Array.newInstance(componentType, size);
            }

            @Override
            public E get(E[] array, int index) {
                if (componentType == Boolean.TYPE) {
                    Boolean b = Array.getBoolean(array, index);
                    return b;
                }
                return array[index];
            }

            @Override
            public void set(E[] array, int index, E element) {
                if (componentType == Boolean.TYPE) {
                    Array.setBoolean(array, index, (Boolean)element);
                } else {
                    array[index] = element;
                }
            }

            @Override
            public int size(E[] array) {
                return array.length;
            }
        };
    }

    public static <E> ArrayType<Object, E> primitiveArray(final Class<E> componentType) {
        if (!componentType.isPrimitive()) {
            throw new IllegalArgumentException("Component type must be primitive");
        }
        return new ArrayType<Object, E>(){

            @Override
            public Object create(int size) {
                if (componentType == Boolean.TYPE) {
                    return new boolean[size];
                }
                if (componentType == Integer.TYPE) {
                    return new int[size];
                }
                if (componentType == Long.TYPE) {
                    return new long[size];
                }
                if (componentType == Float.TYPE) {
                    return new float[size];
                }
                if (componentType == Double.TYPE) {
                    return new double[size];
                }
                if (componentType == Byte.TYPE) {
                    return new byte[size];
                }
                if (componentType == Character.TYPE) {
                    return new char[size];
                }
                if (componentType == Short.TYPE) {
                    return new short[size];
                }
                throw new AssertionError();
            }

            @Override
            public E get(Object array, int index) {
                if (componentType == Boolean.TYPE) {
                    Boolean b = Array.getBoolean(array, index);
                    return b;
                }
                if (componentType == Integer.TYPE) {
                    Integer i = Array.getInt(array, index);
                    return i;
                }
                if (componentType == Long.TYPE) {
                    Long l = Array.getLong(array, index);
                    return l;
                }
                if (componentType == Float.TYPE) {
                    Float f = Float.valueOf(Array.getFloat(array, index));
                    return f;
                }
                if (componentType == Double.TYPE) {
                    Double d = Array.getDouble(array, index);
                    return d;
                }
                if (componentType == Byte.TYPE) {
                    Byte b = Array.getByte(array, index);
                    return b;
                }
                if (componentType == Character.TYPE) {
                    Character b = Character.valueOf(Array.getChar(array, index));
                    return b;
                }
                if (componentType == Short.TYPE) {
                    Short b = Array.getShort(array, index);
                    return b;
                }
                throw new AssertionError();
            }

            @Override
            public void set(Object array, int index, E element) {
                if (componentType == Boolean.TYPE) {
                    Array.setBoolean(array, index, (Boolean)element);
                } else if (componentType == Integer.TYPE) {
                    Array.setInt(array, index, (Integer)element);
                } else if (componentType == Long.TYPE) {
                    Array.setLong(array, index, (Long)element);
                } else if (componentType == Float.TYPE) {
                    Array.setFloat(array, index, ((Float)element).floatValue());
                } else if (componentType == Double.TYPE) {
                    Array.setDouble(array, index, (Double)element);
                } else if (componentType == Byte.TYPE) {
                    Array.setByte(array, index, (Byte)element);
                } else if (componentType == Character.TYPE) {
                    Array.setChar(array, index, ((Character)element).charValue());
                } else if (componentType == Short.TYPE) {
                    Array.setShort(array, index, (Short)element);
                } else {
                    throw new AssertionError();
                }
            }

            @Override
            public int size(Object array) {
                return Array.getLength(array);
            }
        };
    }
}

