/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.naming;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import javax.sql.DataSource;
import org.exoplatform.services.jdbc.impl.CloseableDataSource;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleContext
implements Context {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.common.SimpleContext");
    private static final NameParser NAME_PARSER = new SimpleNameParser();
    private static volatile Map<String, Object> BINDINGS = new HashMap<String, Object>();

    protected Map<String, Object> getBindings() {
        return BINDINGS;
    }

    protected void setBindings(Map<String, Object> bindings) {
        BINDINGS = bindings;
    }

    protected String nameToString(Name name) throws NamingException {
        return name.toString();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(this.nameToString(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(String name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        Object obj = this.getBindings().get(name);
        if (obj instanceof Reference) {
            Object object = obj;
            synchronized (object) {
                obj = this.getBindings().get(name);
                if (obj instanceof Reference) {
                    try {
                        obj = NamingManager.getObjectInstance(obj, NAME_PARSER.parse(name), this, this.getInternalEnv());
                        if (obj instanceof DataSource) {
                            obj = new CloseableDataSource((DataSource)obj);
                        }
                        this.bindRefValue(name, obj);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        NamingException ne = new NamingException("getObjectInstance failed");
                        ne.setRootCause(e);
                        throw ne;
                    }
                }
            }
        }
        if (obj == null) {
            throw new NameNotFoundException("No object has been binded with the name '" + name + "'");
        }
        return obj;
    }

    @Override
    public void bind(Name name, Object value) throws NamingException {
        this.bind(this.nameToString(name), value);
    }

    @Override
    public void bind(String name, Object value) throws NamingException {
        this.bind(name, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind(String name, Object value, boolean checkIfExists) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if ((value = NamingManager.getStateToBind(value, NAME_PARSER.parse(name), this, this.getInternalEnv())) instanceof Context) {
            throw new OperationNotSupportedException("Context not supported");
        }
        if (value instanceof LinkRef) {
            throw new OperationNotSupportedException("LinkRef not supported");
        }
        if (value instanceof Referenceable) {
            value = ((Referenceable)value).getReference();
        }
        Object object = this.getMutex();
        synchronized (object) {
            HashMap<String, Object> tmpObjects = new HashMap<String, Object>(this.getBindings());
            if (checkIfExists && tmpObjects.containsKey(name)) {
                throw new NameAlreadyBoundException("An object has already been binded with the name '" + name + "'");
            }
            tmpObjects.put(name, value);
            this.setBindings(tmpObjects);
        }
    }

    protected void bindRefValue(String name, Object value) throws NamingException {
    }

    @Override
    public void rebind(Name name, Object value) throws NamingException {
        this.rebind(this.nameToString(name), value);
    }

    @Override
    public void rebind(String name, Object value) throws NamingException {
        this.bind(name, value, false);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(this.nameToString(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        Object object = this.getMutex();
        synchronized (object) {
            HashMap<String, Object> tmpObjects = new HashMap<String, Object>(this.getBindings());
            if (tmpObjects.remove(name) == null) {
                throw new NameNotFoundException("No object has been binded with the name '" + name + "'");
            }
            this.setBindings(tmpObjects);
        }
    }

    @Override
    public void rename(Name name1, Name name2) throws NamingException {
        this.rename(this.nameToString(name1), this.nameToString(name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String name1, String name2) throws NamingException {
        if (name1.isEmpty() || name2.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        Object object = this.getMutex();
        synchronized (object) {
            HashMap<String, Object> tmpObjects = new HashMap<String, Object>(this.getBindings());
            if (tmpObjects.containsKey(name2)) {
                throw new NameAlreadyBoundException("An object has already been binded with the name '" + name2 + "'");
            }
            Object value = tmpObjects.remove(name1);
            if (value == null) {
                throw new NameNotFoundException("No object has been binded with the name '" + name1 + "'");
            }
            tmpObjects.put(name2, value);
            this.setBindings(tmpObjects);
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(this.nameToString(name));
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return NAME_PARSER;
    }

    @Override
    public Name composeName(Name nam1, Name name2) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public String composeName(String name1, String name2) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public Object addToEnvironment(String name1, Object name2) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public Object removeFromEnvironment(String name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return new Hashtable(3, 0.75f);
    }

    protected Hashtable<?, ?> getInternalEnv() {
        return null;
    }

    protected Object getMutex() {
        return SimpleContext.class;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    private static class SimpleNameParser
    implements NameParser {
        private SimpleNameParser() {
        }

        public Name parse(String name) throws NamingException {
            return new CompositeName(name);
        }
    }
}

