/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.IndexRecovery;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCException;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;
import org.exoplatform.services.rpc.TopologyChangeEvent;
import org.exoplatform.services.rpc.TopologyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexRecoveryImpl
implements IndexRecovery,
TopologyChangeListener {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexRecoveryImpl");
    public static final int BUFFER_SIZE = 0x100000;
    protected final RPCService rpcService;
    private RemoteCommand getIndexList;
    private RemoteCommand getIndexFile;
    private RemoteCommand changeIndexMode;
    private RemoteCommand checkIndexReady;
    private RemoteCommand requestForResponsibleToSetIndexOnline;
    protected Boolean isResponsibleToSetIndexOnline = false;
    protected Boolean isOnline = true;
    protected final SearchManager searchManager;

    public IndexRecoveryImpl(RPCService rpcService, final SearchManager searchManager) throws RepositoryConfigurationException {
        this.rpcService = rpcService;
        this.searchManager = searchManager;
        final String commandSuffix = searchManager.getWsId() + "-" + (searchManager.parentSearchManager == null);
        final File indexDirectory = searchManager.getIndexDirectory();
        this.changeIndexMode = rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.IndexRecoveryImpl-changeIndexMode-" + commandSuffix;
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                boolean isOnline = (Boolean)args[0];
                searchManager.setOnline(isOnline, false, false);
                IndexRecoveryImpl.this.isOnline = isOnline;
                return null;
            }
        });
        this.getIndexList = rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.IndexRecoveryImpl-getIndexList-" + commandSuffix;
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                return (Serializable)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ArrayList<String>>(){

                    @Override
                    public ArrayList<String> run() throws IOException {
                        int indexDirLen = indexDirectory.getAbsolutePath().length();
                        ArrayList<String> result = new ArrayList<String>();
                        for (File file : DirectoryHelper.listFiles(indexDirectory)) {
                            if (file.isDirectory() || file.getParent().endsWith("offline")) continue;
                            result.add(file.getAbsolutePath().substring(indexDirLen));
                        }
                        return result;
                    }
                });
            }
        });
        this.getIndexFile = rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.IndexRecoveryImpl-getIndexFile-" + commandSuffix;
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                String filePath = (String)((Object)args[0]);
                int offset = (Integer)args[1];
                RandomAccessFile file = new RandomAccessFile(new File(indexDirectory, filePath), "r");
                file.seek(offset);
                byte[] buffer = new byte[0x100000];
                int len = file.read(buffer);
                if (len == -1) {
                    return null;
                }
                byte[] data = new byte[len];
                System.arraycopy(buffer, 0, data, 0, len);
                return data;
            }
        });
        this.requestForResponsibleToSetIndexOnline = rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.IndexRecoveryImpl-requestForResponsibleToSetIndexOnline-" + commandSuffix;
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                return IndexRecoveryImpl.this.isResponsibleToSetIndexOnline;
            }
        });
        this.checkIndexReady = rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.IndexRecoveryImpl-checkIndexIsReady-" + commandSuffix;
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                return new Boolean(searchManager.isOnline());
            }
        });
        this.rpcService.registerTopologyChangeListener((TopologyChangeListener)this);
    }

    @Override
    public void close() {
        this.rpcService.unregisterCommand(this.changeIndexMode);
        this.rpcService.unregisterCommand(this.checkIndexReady);
        this.rpcService.unregisterCommand(this.getIndexFile);
        this.rpcService.unregisterCommand(this.getIndexList);
        this.rpcService.unregisterCommand(this.requestForResponsibleToSetIndexOnline);
        this.rpcService.unregisterTopologyChangeListener((TopologyChangeListener)this);
    }

    @Override
    public List<String> getIndexList() throws RepositoryException {
        try {
            return (List)this.rpcService.executeCommandOnCoordinator(this.getIndexList, true, new Serializable[0]);
        }
        catch (SecurityException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RPCException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void setIndexOffline() throws RepositoryException {
        try {
            this.isResponsibleToSetIndexOnline = true;
            this.rpcService.executeCommandOnCoordinator(this.changeIndexMode, true, new Serializable[]{Boolean.valueOf(false)});
        }
        catch (SecurityException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RPCException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void setIndexOnline() throws RepositoryException {
        try {
            this.rpcService.executeCommandOnCoordinator(this.changeIndexMode, true, new Serializable[]{Boolean.valueOf(true)});
            this.isResponsibleToSetIndexOnline = false;
        }
        catch (SecurityException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RPCException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public InputStream getIndexFile(String filePath) throws RepositoryException {
        try {
            return new RemoteInputStream(filePath);
        }
        catch (SecurityException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RPCException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public boolean checkIndexReady() throws RepositoryException {
        try {
            return (Boolean)this.rpcService.executeCommandOnCoordinator(this.checkIndexReady, true, new Serializable[0]);
        }
        catch (SecurityException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RPCException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void onChange(TopologyChangeEvent event) {
        try {
            if (this.rpcService.isCoordinator() && !this.isOnline.booleanValue()) {
                new Thread(){

                    public synchronized void run() {
                        try {
                            List results = IndexRecoveryImpl.this.rpcService.executeCommandOnAllNodes(IndexRecoveryImpl.this.requestForResponsibleToSetIndexOnline, true, new Serializable[0]);
                            for (Object result : results) {
                                if (result instanceof Boolean) {
                                    if (!((Boolean)result).booleanValue()) continue;
                                    return;
                                }
                                log.error((Object)("Result is not an instance of Boolean" + result));
                            }
                            log.error((Object)"Node responsible for setting index back online seems to leave the cluster. Setting back online.");
                            IndexRecoveryImpl.this.searchManager.setOnline(true, false, false);
                        }
                        catch (SecurityException e1) {
                            log.error((Object)"You haven't privileges to execute remote command", (Throwable)e1);
                        }
                        catch (RPCException e1) {
                            log.error((Object)"Exception during command execution", (Throwable)e1);
                        }
                        catch (IOException e2) {
                            log.error((Object)"Exception during setting index back online", (Throwable)e2);
                        }
                    }
                }.start();
            }
        }
        catch (RPCException e) {
            log.error((Object)"Can't check if node coordinator or not.");
        }
    }

    class RemoteInputStream
    extends InputStream {
        private final String filePath;
        private int fileOffset = 0;
        private int bufferOffset = 0;
        private byte[] buffer;

        RemoteInputStream(String filePath) throws SecurityException, RPCException {
            this.filePath = filePath;
            this.readNext();
        }

        public int read() throws IOException {
            throw new UnsupportedOperationException("RemoteStream.read() method is not supported");
        }

        public int available() throws IOException {
            return this.buffer == null ? 0 : this.buffer.length - this.bufferOffset;
        }

        public int read(byte[] b) throws IOException {
            if (this.buffer == null) {
                return -1;
            }
            if (this.available() == 0) {
                try {
                    this.readNext();
                    if (this.buffer == null) {
                        return -1;
                    }
                }
                catch (SecurityException e) {
                    throw new IOException(e);
                }
                catch (RPCException e) {
                    throw new IOException(e);
                }
            }
            int len = Math.min(b.length, this.available());
            System.arraycopy(this.buffer, this.bufferOffset, b, 0, len);
            this.bufferOffset += len;
            return len;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("RemoteStream.read(byte b[], int off, int len) method is not supported");
        }

        private void readNext() throws SecurityException, RPCException {
            this.buffer = (byte[])IndexRecoveryImpl.this.rpcService.executeCommandOnCoordinator(IndexRecoveryImpl.this.getIndexFile, true, new Serializable[]{this.filePath, Integer.valueOf(this.fileOffset)});
            if (this.buffer != null) {
                this.fileOffset += this.buffer.length;
                this.bufferOffset = 0;
            }
        }
    }
}

