/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.form;

import java.io.Writer;
import java.util.ResourceBundle;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputSet;

public class UIFormInputSetWithColspan
extends UIFormInputSet {
    private boolean isColspan = false;

    public UIFormInputSetWithColspan(String name) throws Exception {
        super(name);
    }

    public void allowColspan(boolean allowColspan) {
        this.isColspan = allowColspan;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.getComponentConfig() != null) {
            super.processRender(context);
            return;
        }
        Writer w = context.getWriter();
        w.write("<div class=\"UIFormInputSet\">");
        w.write("<table class=\"UIFormGrid " + this.getId() + "\">");
        ResourceBundle res = context.getApplicationResourceBundle();
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        for (UIComponent inputEntry : this.getChildren()) {
            if (!inputEntry.isRendered()) continue;
            String label = "";
            boolean hasLabel = false;
            if (inputEntry instanceof UIFormInputBase) {
                UIFormInputBase formInputBase = (UIFormInputBase)inputEntry;
                label = formInputBase.getLabel() != null ? uiForm.getLabel(res, formInputBase.getLabel()) : uiForm.getLabel(res, formInputBase.getId());
                if (formInputBase.getLabel() != null || label != formInputBase.getId()) {
                    hasLabel = true;
                }
            }
            w.write("<tr>");
            if (this.isColspan) {
                w.write("<td class=\"FieldLabel\" colspan=\"2\">");
            } else {
                w.write("<td class=\"FieldLabel\">");
                if (hasLabel) {
                    w.write(label);
                }
            }
            w.write("</td>");
            w.write("<td class=\"FieldComponent\">");
            this.renderUIComponent(inputEntry);
            w.write("</td>");
            w.write("</tr>");
        }
        w.write("</table>");
        w.write("</div>");
    }
}

