/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.action.UIActionManager;
import org.exoplatform.ecm.webui.component.admin.action.UIActionTypeForm;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={AddActionActionListener.class})})
public class UIActionTypeList
extends UIPagingGrid {
    private static String[] ACTIONTYPE_BEAN_FIELD = new String[]{"name", "extendType"};

    public UIActionTypeList() throws Exception {
        this.getUIPageIterator().setId("ActionTypeListIterator");
        this.configure("name", ACTIONTYPE_BEAN_FIELD, null);
    }

    public String[] getActions() {
        return new String[]{"AddAction"};
    }

    public void refresh(int currentPage) throws Exception {
        ActionServiceContainer actionsServiceContainer = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        List actionList = (List)actionsServiceContainer.getCreatedActionTypes(repository);
        ArrayList<ActionData> actions = new ArrayList<ActionData>(actionList.size());
        for (int i = 0; i < actionList.size(); ++i) {
            ActionData bean = new ActionData();
            NodeType action = (NodeType)actionList.get(i);
            bean.setName(action.getName());
            NodeType[] superTypes = action.getSupertypes();
            StringBuilder types = new StringBuilder();
            for (int j = 0; j < superTypes.length; ++j) {
                types.append("[").append(superTypes[j].getName()).append("] ");
            }
            bean.setExtendType(types.toString());
            actions.add(bean);
        }
        Collections.sort(actions, new ActionComparator());
        LazyPageList dataPageList = new LazyPageList((ListAccess)new ListAccessImpl(ActionData.class, actions), this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setTotalItems(actions.size());
        this.getUIPageIterator().setPageList((PageList)dataPageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public static class ActionData {
        private String name;
        private String extendType;

        public String getName() {
            return this.name;
        }

        public void setName(String s) {
            this.name = s;
        }

        public String getExtendType() {
            return this.extendType;
        }

        public void setExtendType(String s) {
            this.extendType = s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionActionListener
    extends EventListener<UIActionTypeList> {
        public void execute(Event<UIActionTypeList> event) throws Exception {
            UIActionManager uiActionMan = (UIActionManager)((UIActionTypeList)((Object)event.getSource())).getParent();
            UIActionTypeForm uiForm = (UIActionTypeForm)uiActionMan.findFirstComponentOfType(UIActionTypeForm.class);
            if (uiForm == null) {
                uiForm = (UIActionTypeForm)uiActionMan.createUIComponent(UIActionTypeForm.class, null, null);
            }
            uiForm.refresh();
            uiActionMan.initPopup((UIComponent)uiForm, 600);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionMan);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActionComparator
    implements Comparator<ActionData> {
        @Override
        public int compare(ActionData a1, ActionData a2) throws ClassCastException {
            String name1 = a1.getName();
            String name2 = a2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

