/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs.operations;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileOperation;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class DeleteValues
extends ValueFileOperation {
    private static final AtomicLong SEQUENCE = new AtomicLong();
    private final File[] files;
    private ValueFileOperation.ValueFileLock[] locks;
    protected File[] bckFiles;

    public DeleteValues(File[] files, ValueDataResourceHolder resources, FileCleaner cleaner, File tempDir) {
        super(resources, cleaner, tempDir);
        this.files = files;
    }

    public void execute() throws IOException {
        this.makePerformed();
        this.locks = new ValueFileOperation.ValueFileLock[this.files.length];
        for (int i = 0; i < this.files.length; ++i) {
            ValueFileOperation.ValueFileLock fl = new ValueFileOperation.ValueFileLock(this, this.files[i]);
            fl.lock();
            this.locks[i] = fl;
        }
    }

    public void prepare() throws IOException {
        if (this.locks != null) {
            this.bckFiles = new File[this.files.length];
            int length = this.files.length;
            for (int i = 0; i < length; ++i) {
                File file = this.files[i];
                if (!file.exists()) continue;
                this.bckFiles[i] = new File(file.getAbsolutePath() + "." + System.currentTimeMillis() + "_" + SEQUENCE.incrementAndGet());
                this.move(file, this.bckFiles[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IOException {
        if (this.locks != null) {
            try {
                int length = this.files.length;
                for (int i = 0; i < length; ++i) {
                    File f = this.bckFiles[i];
                    if (f == null) continue;
                    this.cleaner.removeFile(this.files[i]);
                    this.move(f, this.files[i]);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                for (ValueFileOperation.ValueFileLock fl : this.locks) {
                    fl.unlock();
                }
                throw throwable;
            }
            for (ValueFileOperation.ValueFileLock fl : this.locks) {
                fl.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void twoPhaseCommit() throws IOException {
        if (this.locks != null) {
            try {
                for (File f : this.bckFiles) {
                    if (f == null || f.delete()) continue;
                    this.cleaner.addFile(f);
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                for (ValueFileOperation.ValueFileLock fl : this.locks) {
                    fl.unlock();
                }
                throw throwable;
            }
            for (ValueFileOperation.ValueFileLock fl : this.locks) {
                fl.unlock();
            }
        }
    }
}

