/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIEditingTagsForm;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/sidebar/UITagExplorer.gtmpl", events={@EventConfig(listeners={ViewTagActionListener.class}), @EventConfig(listeners={EditTagsActionListener.class})})
public class UITagExplorer
extends UIContainer {
    public static final String PUBLIC_TAG_NODE_PATH = "exoPublicTagNode";
    private int tagScope;

    public int getTagScope() {
        return this.tagScope;
    }

    public void setTagScope(int scope) {
        this.tagScope = scope;
    }

    public List<Node> getPrivateTagLink() throws Exception {
        NewFolksonomyService folksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        return folksonomyService.getAllPrivateTags(this.getUserName());
    }

    public List<Node> getPublicTagLink() throws Exception {
        NewFolksonomyService folksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        String publicTagNodePath = nodeHierarchyCreator.getJcrPath(PUBLIC_TAG_NODE_PATH);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepo = repositoryService.getCurrentRepository();
        String workspace = manageableRepo.getConfiguration().getDefaultWorkspaceName();
        return folksonomyService.getAllPublicTags(publicTagNodePath, workspace);
    }

    public Map<String, String> getTagStyle() throws Exception {
        NewFolksonomyService folksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        String workspace = ((DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class)).getConfig().getSystemWorkspace();
        HashMap<String, String> tagStyle = new HashMap<String, String>();
        for (Node tag : folksonomyService.getAllTagStyle(workspace)) {
            tagStyle.put(tag.getProperty("exo:styleRange").getValue().getString(), tag.getProperty("exo:htmlStyle").getValue().getString());
        }
        return tagStyle;
    }

    public String getTagHtmlStyle(Map<String, String> tagStyles, int tagCount) throws Exception {
        for (Map.Entry<String, String> entry : tagStyles.entrySet()) {
            if (!this.checkTagRate(tagCount, entry.getKey())) continue;
            return entry.getValue();
        }
        return "";
    }

    private boolean checkTagRate(int numOfDocument, String range) throws Exception {
        String[] vals = StringUtils.split((String)range, (String)"..");
        int minValue = Integer.parseInt(vals[0]);
        int maxValue = vals[1].equals("*") ? Integer.MAX_VALUE : Integer.parseInt(vals[1]);
        return minValue <= numOfDocument && numOfDocument < maxValue;
    }

    public String getRepository() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
    }

    public String getWorkspace() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentWorkspace();
    }

    public String getUserName() {
        try {
            return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getSession().getUserID();
        }
        catch (Exception ex) {
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditTagsActionListener
    extends EventListener<UITagExplorer> {
        public void execute(Event<UITagExplorer> event) throws Exception {
            UITagExplorer uiTagExplorer = (UITagExplorer)((Object)event.getSource());
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiTagExplorer.getApplicationComponent(NewFolksonomyService.class);
            String scope = event.getRequestContext().getRequestParameter("objectId");
            int intScope = "Public".equals(scope) ? 0 : 1;
            ((UIJCRExplorer)uiTagExplorer.getAncestorOfType(UIJCRExplorer.class)).setTagScope(intScope);
            List memberships = Utils.getMemberships();
            if (newFolksonomyService.canEditTag(intScope, memberships)) {
                UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTagExplorer.getAncestorOfType(UIJCRExplorer.class);
                UIPopupContainer uiPopupContainer = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
                uiPopupContainer.activate(UIEditingTagsForm.class, 600);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
            } else {
                UIApplication uiApp = (UIApplication)uiTagExplorer.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.editTagAccessDenied", null, 1));
                ((UIJCRExplorer)uiTagExplorer.getAncestorOfType(UIJCRExplorer.class)).updateAjax(event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewTagActionListener
    extends EventListener<UITagExplorer> {
        public void execute(Event<UITagExplorer> event) throws Exception {
            UITagExplorer uiTagExplorer = (UITagExplorer)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiTagExplorer.getAncestorOfType(UIApplication.class);
            String tagPath = event.getRequestContext().getRequestParameter("objectId");
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTagExplorer.getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.setSelectRootNode();
            uiExplorer.setTagPath(tagPath);
            uiExplorer.setIsViewTag(true);
            try {
                uiExplorer.updateAjax(event);
            }
            catch (PathNotFoundException pne) {
                uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.path-not-found", null, 1));
                return;
            }
        }
    }
}

