/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.TranslatedCode;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.stages.CompileHtmlStage;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.render.Concatenator;
import com.google.caja.reporting.RenderContext;
import java.net.URI;
import java.util.Collections;
import org.w3c.dom.Node;

public final class HtmlToJsStage
extends CompileHtmlStage {
    public HtmlToJsStage(CssSchema cssSchema, HtmlSchema htmlSchema) {
        super(cssSchema, htmlSchema);
    }

    Job makeJobFromHtml(JobCache.Keys keys, Node html, URI baseUri) {
        return Job.jsJob(keys, HtmlToJsStage.makeEmitStaticStmt(html), baseUri);
    }

    private static Statement makeEmitStaticStmt(Node node) {
        return (Statement)QuasiBuilder.substV("'use strict'; 'use cajita'; @stmt;", "stmt", new TranslatedCode(new Block(FilePosition.UNKNOWN, Collections.singletonList(new ExpressionStmt((Expression)QuasiBuilder.substV("IMPORTS___./*@synthetic*/htmlEmitter___./*@synthetic*/emitStatic(@html)", "html", HtmlToJsStage.renderDomAsJsStringLiteral(node)))))));
    }

    private static StringLiteral renderDomAsJsStringLiteral(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        Concatenator tc = new Concatenator(stringBuilder);
        Nodes.render(node, new RenderContext(tc).withEmbeddable(true));
        return StringLiteral.valueOf(Nodes.getFilePositionFor(node), stringBuilder);
    }
}

