/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.personalfolder.component;

import org.exoplatform.ecms.personalfolder.services.ManagePersonalFolderServiceImpl;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class})})
public class UIPersonalFolderForm
extends UIForm {
    private static final String USERNAME_FIELD = "userName";

    public UIPersonalFolderForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(USERNAME_FIELD, USERNAME_FIELD, null));
    }

    private void installlPersonalFolder(String userName) {
        ManagePersonalFolderServiceImpl manageFolderSer = (ManagePersonalFolderServiceImpl)WCMCoreUtils.getService(ManagePersonalFolderServiceImpl.class);
        manageFolderSer.initUserFolder(userName);
    }

    private boolean isExisting(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
        return organizationService.getUserHandler().findUserByName(userName) != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPersonalFolderForm> {
        public void execute(Event<UIPersonalFolderForm> event) throws Exception {
            UIPersonalFolderForm uiForm = (UIPersonalFolderForm)((Object)event.getSource());
            String userName = (String)uiForm.getUIStringInput(UIPersonalFolderForm.USERNAME_FIELD).getValue();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            if (!uiForm.isExisting(userName)) {
                uiApp.addMessage(new ApplicationMessage("UIPersonalFolderForm.msg.notExisting", (Object[])new String[]{userName}, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp);
                return;
            }
            uiForm.installlPersonalFolder(userName);
            uiApp.addMessage(new ApplicationMessage("UIPersonalFolderForm.msg.initSuccessed", (Object[])new String[]{userName}, 2));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp);
        }
    }
}

