/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.manager.cache;

import java.util.ArrayList;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.wcm.manager.cache.UIWCMCacheManagerPanel;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ClearActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIWCMCacheManagerForm
extends UIForm {
    public static final String FIELD_LABEL_CURRENTSIZE = "currentSize";
    public static final String FIELD_LABEL_HIT = "hit";
    public static final String FIELD_LABEL_MISS = "miss";
    public static final String FIELD_LIVE_TIME = "livetime";
    public static final String FIELD_MAX_SIZE = "maxsize";
    public static final String CHECKBOX_ENABLE_CACHE = "isCacheEnable";
    public static final String FIELD_MODIFY = "cacheModify";
    public ExoCache cache = LockUtil.getLockCache();

    public UIWCMCacheManagerForm() throws Exception {
        int hit = this.cache.getCacheHit();
        long currentSize = this.cache.getCacheSize();
        int missHit = this.cache.getCacheHit();
        long livetime = this.cache.getLiveTime();
        int maxsize = this.cache.getMaxSize();
        ArrayList modifyOptions = new ArrayList();
        UIFormSelectBox typeModify = new UIFormSelectBox(FIELD_MODIFY, FIELD_MODIFY, modifyOptions);
        this.addUIFormInput((UIFormInput)typeModify);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LABEL_CURRENTSIZE, FIELD_LABEL_CURRENTSIZE, String.valueOf(currentSize)).setEditable(false));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LABEL_HIT, FIELD_LABEL_HIT, String.valueOf(hit)).setEditable(false));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LABEL_MISS, FIELD_LABEL_MISS, String.valueOf(missHit)).setEditable(false));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_MAX_SIZE, FIELD_MAX_SIZE, String.valueOf(maxsize)));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LIVE_TIME, FIELD_LIVE_TIME, String.valueOf(livetime)));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(CHECKBOX_ENABLE_CACHE, CHECKBOX_ENABLE_CACHE, null).setChecked(true));
        this.setActions(new String[]{"Clear", "Save", "Cancel"});
        this.update();
    }

    private void update() throws Exception {
        this.getUIStringInput(FIELD_LIVE_TIME).setValue((Object)String.valueOf(this.cache.getLiveTime()));
        this.getUIStringInput(FIELD_MAX_SIZE).setValue((Object)String.valueOf(this.cache.getMaxSize()));
        this.getUIStringInput(FIELD_LABEL_MISS).setValue((Object)String.valueOf(this.cache.getCacheHit()));
        this.getUIStringInput(FIELD_LABEL_HIT).setValue((Object)String.valueOf(this.cache.getCacheMiss()));
        this.getUIStringInput(FIELD_LABEL_CURRENTSIZE).setValue((Object)String.valueOf(this.cache.getCacheSize()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIWCMCacheManagerForm> {
        public void execute(Event<UIWCMCacheManagerForm> event) throws Exception {
            UIWCMCacheManagerForm uiForm = (UIWCMCacheManagerForm)((Object)event.getSource());
            UIWCMCacheManagerPanel wcmCache = (UIWCMCacheManagerPanel)uiForm.getAncestorOfType(UIWCMCacheManagerPanel.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)wcmCache);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClearActionListener
    extends EventListener<UIWCMCacheManagerForm> {
        public void execute(Event<UIWCMCacheManagerForm> event) throws Exception {
            UIWCMCacheManagerPanel uiCachePanel = (UIWCMCacheManagerPanel)((UIWCMCacheManagerForm)((Object)event.getSource())).getParent();
            UIWCMCacheManagerForm uiCacheForm = (UIWCMCacheManagerForm)((Object)event.getSource());
            uiCacheForm.cache.clearCache();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiCachePanel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIWCMCacheManagerForm> {
        public void execute(Event<UIWCMCacheManagerForm> event) throws Exception {
            UIWCMCacheManagerForm uiCacheForm = (UIWCMCacheManagerForm)((Object)event.getSource());
            UIWCMCacheManagerPanel uiCachePanel = (UIWCMCacheManagerPanel)((UIWCMCacheManagerForm)((Object)event.getSource())).getAncestorOfType(UIWCMCacheManagerPanel.class);
            String livetime = (String)uiCacheForm.getUIStringInput(UIWCMCacheManagerForm.FIELD_LIVE_TIME).getValue();
            String maxsize = (String)uiCacheForm.getUIStringInput(UIWCMCacheManagerForm.FIELD_MAX_SIZE).getValue();
            uiCacheForm.cache.setLiveTime(Long.parseLong(livetime));
            uiCacheForm.cache.setMaxSize(Integer.parseInt(maxsize));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiCachePanel);
        }
    }
}

