/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.manager.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.manager.cache.UIWCMCacheManagerPanel;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ClearActionListener.class}), @EventConfig(listeners={RefreshActionListener.class}), @EventConfig(listeners={OnChangeActionListener.class})})
public class UIWCMCacheManagerForm
extends UIForm {
    public static final String FIELD_LABEL_CURRENTSIZE = "currentSize";
    public static final String FIELD_LABEL_HIT = "hit";
    public static final String FIELD_LABEL_MISS = "miss";
    public static final String FIELD_LIVE_TIME = "livetime";
    public static final String FIELD_MAX_SIZE = "maxsize";
    public static final String CHECKBOX_ENABLE_CACHE = "isCacheEnable";
    public static final String FIELD_MODIFY = "cacheModify";
    public static UIFormInputBase<String> UI1;
    public static UIFormInputBase<String> UI2;
    public static UIFormInputBase<String> UI3;
    public static UIFormInputBase<String> UI4;
    public static UIFormInputBase<String> UI5;
    public Collection<ExoCache<? extends Serializable, ?>> caches = ((CacheService)WCMCoreUtils.getService(CacheService.class)).getAllCacheInstances();
    public static ExoCache cache;

    public UIWCMCacheManagerForm() throws Exception {
        ArrayList<SelectItemOption> modifyOptions = new ArrayList<SelectItemOption>();
        Iterator<ExoCache<Serializable, ?>> it = this.caches.iterator();
        while (it.hasNext()) {
            SelectItemOption itm = new SelectItemOption((Object)it.next().getName());
            modifyOptions.add(itm);
        }
        UIFormSelectBox typeModify = new UIFormSelectBox(FIELD_MODIFY, FIELD_MODIFY, modifyOptions);
        typeModify.setOnChange("OnChange");
        this.addUIFormInput((UIFormInput)typeModify);
        int hit = 0;
        long currentSize = 0L;
        int missHit = 0;
        long livetime = 0L;
        int maxsize = 0;
        UIFormInputBase UI1 = new UIFormStringInput(FIELD_LABEL_CURRENTSIZE, FIELD_LABEL_CURRENTSIZE, String.valueOf(currentSize)).setEditable(false);
        this.addUIFormInput((UIFormInput)UI1);
        UIFormInputBase UI2 = new UIFormStringInput(FIELD_LABEL_HIT, FIELD_LABEL_HIT, String.valueOf(hit)).setEditable(false);
        this.addUIFormInput((UIFormInput)UI2);
        UIFormInputBase UI3 = new UIFormStringInput(FIELD_LABEL_MISS, FIELD_LABEL_MISS, String.valueOf(missHit)).setEditable(false);
        this.addUIFormInput((UIFormInput)UI3);
        UIFormStringInput UI4 = new UIFormStringInput(FIELD_MAX_SIZE, FIELD_MAX_SIZE, String.valueOf(maxsize));
        this.addUIFormInput((UIFormInput)UI4);
        UIFormStringInput UI5 = new UIFormStringInput(FIELD_LIVE_TIME, FIELD_LIVE_TIME, String.valueOf(livetime));
        this.addUIFormInput((UIFormInput)UI5);
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(CHECKBOX_ENABLE_CACHE, CHECKBOX_ENABLE_CACHE, null).setChecked(true));
        this.setActions(new String[]{"Clear", "Save", "Refresh"});
    }

    private void update(ExoCache cache) throws Exception {
        this.getUIStringInput(FIELD_LIVE_TIME).setValue((Object)String.valueOf(cache.getLiveTime()));
        this.getUIStringInput(FIELD_MAX_SIZE).setValue((Object)String.valueOf(cache.getMaxSize()));
        this.getUIStringInput(FIELD_LABEL_MISS).setValue((Object)String.valueOf(cache.getCacheMiss()));
        this.getUIStringInput(FIELD_LABEL_HIT).setValue((Object)String.valueOf(cache.getCacheHit()));
        this.getUIStringInput(FIELD_LABEL_CURRENTSIZE).setValue((Object)String.valueOf(cache.getCacheSize()));
    }

    static {
        cache = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OnChangeActionListener
    extends EventListener<UIWCMCacheManagerForm> {
        public void execute(Event<UIWCMCacheManagerForm> event) throws Exception {
            UIWCMCacheManagerForm uiCacheForm = (UIWCMCacheManagerForm)((Object)event.getSource());
            String cacheOpt = (String)uiCacheForm.getUIFormSelectBox(UIWCMCacheManagerForm.FIELD_MODIFY).getValue();
            cache = ((CacheService)WCMCoreUtils.getService(CacheService.class)).getCacheInstance(cacheOpt);
            uiCacheForm.update(cache);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiCacheForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefreshActionListener
    extends EventListener<UIWCMCacheManagerForm> {
        public void execute(Event<UIWCMCacheManagerForm> event) throws Exception {
            UIWCMCacheManagerForm uiCacheForm = (UIWCMCacheManagerForm)((Object)event.getSource());
            UIWCMCacheManagerPanel wcmCache = (UIWCMCacheManagerPanel)uiCacheForm.getAncestorOfType(UIWCMCacheManagerPanel.class);
            uiCacheForm.update(cache);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)wcmCache);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClearActionListener
    extends EventListener<UIWCMCacheManagerForm> {
        public void execute(Event<UIWCMCacheManagerForm> event) throws Exception {
            UIWCMCacheManagerPanel uiCachePanel = (UIWCMCacheManagerPanel)((UIWCMCacheManagerForm)((Object)event.getSource())).getParent();
            UIWCMCacheManagerForm uiCacheForm = (UIWCMCacheManagerForm)((Object)event.getSource());
            cache.clearCache();
            uiCacheForm.update(cache);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiCachePanel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIWCMCacheManagerForm> {
        public void execute(Event<UIWCMCacheManagerForm> event) throws Exception {
            UIWCMCacheManagerForm uiCacheForm = (UIWCMCacheManagerForm)((Object)event.getSource());
            UIWCMCacheManagerPanel uiCachePanel = (UIWCMCacheManagerPanel)uiCacheForm.getAncestorOfType(UIWCMCacheManagerPanel.class);
            Boolean isChecked = uiCacheForm.getUIFormCheckBoxInput(UIWCMCacheManagerForm.CHECKBOX_ENABLE_CACHE).isChecked();
            if (!isChecked.booleanValue()) {
                throw new Exception("cache enable is not set");
            }
            String livetime = (String)uiCacheForm.getUIStringInput(UIWCMCacheManagerForm.FIELD_LIVE_TIME).getValue();
            String maxsize = (String)uiCacheForm.getUIStringInput(UIWCMCacheManagerForm.FIELD_MAX_SIZE).getValue();
            cache.setLiveTime(Long.parseLong(livetime));
            cache.setMaxSize(Integer.parseInt(maxsize));
            uiCacheForm.update(cache);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiCachePanel);
        }
    }
}

