/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.authoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.wcm.webui.authoring.UIDashboardForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/authoring/UIDashboardForm.gtmpl", events={@EventConfig(listeners={ShowDocumentActionListener.class}), @EventConfig(listeners={RefreshActionListener.class})})
public class UIDashboardForm
extends UIForm {
    public List<Node> getContents(String fromstate) {
        return this.getContents(fromstate, null, null);
    }

    public List<Node> getContents(String fromstate, String tostate) {
        return this.getContents(fromstate, tostate, null);
    }

    public List<Node> getContents(String fromstate, String tostate, String date) {
        PublicationManager manager = (PublicationManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PublicationManager.class);
        String user = PortalRequestContext.getCurrentInstance().getRemoteUser();
        String lang = Util.getPortalRequestContext().getLocale().getLanguage();
        List nodes = new ArrayList();
        ArrayList<Node> temp = new ArrayList<Node>();
        try {
            nodes = manager.getContents(fromstate, tostate, date, user, lang, "collaboration");
            HashSet<String> uuidList = new HashSet<String>();
            for (Node node : nodes) {
                String currentState = null;
                if (node.hasProperty("publication:currentState")) {
                    currentState = node.getProperty("publication:currentState").getString();
                }
                if (currentState != null && currentState.equals("published") || Utils.isInTrash((Node)node) || uuidList.contains(node.getSession().getWorkspace().getName() + node.getUUID())) continue;
                uuidList.add(node.getSession().getWorkspace().getName() + node.getUUID());
                temp.add(node);
            }
        }
        catch (Exception e) {
            temp = new ArrayList();
        }
        return temp;
    }
}

