/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.extensions.component.rest;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/authoring/")
public class LifecycleConnector
implements ResourceContainer {
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

    @GET
    @Path(value="/bystate/")
    public Response byState(@QueryParam(value="fromstate") String fromstate, @QueryParam(value="user") String user, @QueryParam(value="lang") String lang, @QueryParam(value="workspace") String workspace, @QueryParam(value="json") String json) throws Exception {
        return this.getContents(fromstate, null, null, user, lang, workspace, json);
    }

    @GET
    @Path(value="/tostate/")
    public Response toState(@QueryParam(value="fromstate") String fromstate, @QueryParam(value="tostate") String tostate, @QueryParam(value="user") String user, @QueryParam(value="lang") String lang, @QueryParam(value="workspace") String workspace, @QueryParam(value="json") String json) throws Exception {
        return this.getContents(fromstate, tostate, null, user, lang, workspace, json);
    }

    @GET
    @Path(value="/bydate/")
    public Response byDate(@QueryParam(value="fromstate") String fromstate, @QueryParam(value="date") String date, @QueryParam(value="lang") String lang, @QueryParam(value="workspace") String workspace, @QueryParam(value="json") String json) throws Exception {
        return this.getContents(fromstate, null, date, null, lang, workspace, json);
    }

    private Response getContents(String fromstate, String tostate, String date, String user, String lang, String workspace, String asJSon) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        try {
            StringBuffer json = new StringBuffer();
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("contents");
            document.appendChild(root);
            PublicationManager manager = (PublicationManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PublicationManager.class);
            List<Node> nodes = manager.getContents(fromstate, tostate, date, user, lang, workspace);
            json.append("[");
            boolean first = true;
            for (Node node : nodes) {
                String name = node.getName();
                String path = node.getPath();
                String title = null;
                String pubDate = null;
                if (node.hasProperty("exo:title")) {
                    title = node.getProperty("exo:title").getString();
                }
                if (node.hasProperty("publication:startPublishedDate")) {
                    pubDate = node.getProperty("publication:startPublishedDate").getString();
                }
                if (!first) {
                    json.append(",");
                }
                first = false;
                json.append("{");
                json.append("\"name\":\"" + name + "\"");
                if (title != null) {
                    json.append(",\"title\":\"" + title + "\"");
                }
                json.append(",\"path\":\"" + path + "\"");
                Element element = document.createElement("content");
                element.setAttribute("name", name);
                if (title != null) {
                    element.setAttribute("title", title);
                }
                element.setAttribute("path", path);
                if (pubDate != null) {
                    json.append(",\"publishedDate\":\"" + pubDate + "\"");
                    element.setAttribute("publishedDate", pubDate);
                }
                root.appendChild(element);
                json.append("}");
            }
            json.append("]");
            if ("true".equals(asJSon)) {
                return Response.ok((Object)json.toString(), (String)"text/plain").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
            }
            return Response.ok((Object)new DOMSource(document), (String)"text/xml").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        catch (Exception e) {
            Response.serverError().build();
            return Response.ok().header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
    }
}

