/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.component.browsecontent.BCTreeNode;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContainer;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContentPortlet;
import org.exoplatform.ecm.webui.component.browsecontent.UICategoryTree;
import org.exoplatform.ecm.webui.component.browsecontent.UIDocumentDetail;
import org.exoplatform.ecm.webui.component.browsecontent.UISearchController;
import org.exoplatform.ecm.webui.component.browsecontent.UITagList;
import org.exoplatform.ecm.webui.component.browsecontent.UIToolBar;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.cms.scripts.DataTransfer;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(events={@EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={BackActionListener.class}), @EventConfig(listeners={ViewByTagActionListener.class}), @EventConfig(listeners={BackViewActionListener.class}), @EventConfig(listeners={SelectActionListener.class}), @EventConfig(listeners={ChangePageActionListener.class})}), @ComponentConfig(type=UIPageIterator.class, id="UICBPageIterator", template="system:/groovy/webui/core/UIPageIterator.gtmpl", events={@EventConfig(listeners={ShowPageActionListener.class})})})
public class UIBrowseContainer
extends UIContainer {
    public static final String CATEGORYPATH = "categoryPath";
    public static final String CURRENTNODE = "currentNode";
    public static final String HISTORY = "history";
    public static final String ISSHOWALLDOCUMENT = "isShowAllDocument";
    public static final String ISSHOWCATEGORYTREE = "isShowCategoryTree";
    public static final String ISSHOWDOCUMENTBYTAG = "isShowDocumentByTag";
    public static final String ISSHOWDOCUMENTDETAIL = "isShowDocumentDetail";
    public static final String ISSHOWDOCUMENTLIST = "isShowDocumentList";
    public static final String ISSHOWPAGEACTION = "isShowPageAction";
    public static final String ISSHOWSEARCHFORM = "isShowSearchForm";
    public static final String KEY_CURRENT = "currentNode";
    public static final String KEY_SELECTED = "selectedNode";
    public static final String NODESHISTORY = "nodesHistory";
    public static final String OLDTEMPLATE = "oldTemplate";
    public static final String ROOTNODE = "rootNode";
    public static final String ROWPERBLOCK = "rowPerBlock";
    public static final String SELECTEDTAB = "selectedTab";
    public static final String TAGPATH = "tagPath";
    public static final String TEMPLATEDETAIL = "templateDetail";
    public static final String TEMPLATEPATH = "templatePath";
    public static final String TREELIST = "TreeList";
    public static final String TREEROOT = "treeRoot";
    public static final String USECASE = "usecase";
    private static final Log LOG = ExoLogger.getLogger(UIBrowseContainer.class);
    private String categoryPath_;
    private String currentPath_;
    private String rootPath_;
    private String selectedTabPath_;
    private String detailTemplate_;
    private boolean isShowAllDocument_;
    private boolean isShowCategoriesTree_ = true;
    private boolean isShowDetailDocument_ = false;
    private boolean isShowDocumentByTag_ = false;
    private boolean isShowDocumentList_ = false;
    private boolean isShowPageAction_;
    private boolean isShowSearchForm_;
    private JCRResourceResolver jcrTemplateResourceResolver_;
    private boolean isSetted_ = false;
    private int totalRecord_;
    private String wsName_ = null;
    private LinkedList<String> nodesHistory_ = new LinkedList();
    private Map<String, Node> nodesHistoryMap_ = new HashMap();
    private int rowPerBlock_ = 6;
    private String tagPath_;
    private String keyValue_;
    private String templatePath_;
    private BCTreeNode treeRoot_;
    private UIPageIterator uiPageIterator_;
    private HashMap<String, WindowState> windowState_ = new HashMap();
    private String windowId_;
    private List<Node> listHistoryNode = new ArrayList();

    public UIBrowseContainer() throws Exception {
        ManageViewService vservice = (ManageViewService)this.getApplicationComponent(ManageViewService.class);
        this.uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, "UICBPageIterator", "UICBPageIterator");
        this.addChild(UITagList.class, null, null);
        UICategoryTree uiTree = (UICategoryTree)this.createUIComponent(UICategoryTree.class, null, null);
        this.addChild((UIComponent)uiTree);
        this.addChild(UIToolBar.class, null, null);
        this.addChild(UISearchController.class, null, null);
        this.addChild(UIDocumentDetail.class, null, "DocumentDetail");
    }

    public void changeNode(Node selectNode) throws Exception {
        this.setShowAllChildren(false);
        this.setShowDocumentByTag(false);
        this.setShowDocumentDetail(false);
        if (selectNode.equals(this.getRootNode())) {
            this.setCurrentNodePath(null);
            this.setSelectedTabPath(null);
        } else {
            this.setSelectedTabPath(selectNode.getPath());
            this.setCurrentNodePath(selectNode.getPath());
            this.setPageIterator(this.getSubDocumentList(this.getSelectedTab()));
        }
    }

    public String[] getActions() {
        return new String[]{"back"};
    }

    public SessionProvider getAnonimProvider() {
        return SessionProviderFactory.createAnonimProvider();
    }

    public String getCategoryPath() {
        return this.categoryPath_;
    }

    public List<?> getCurrentList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public Node getCurrentNode() throws Exception {
        if (this.getNodeByPath(this.currentPath_) == null) {
            return this.getNodeByPath(this.rootPath_);
        }
        return this.getNodeByPath(this.currentPath_);
    }

    public List<Node> getDocumentByTag() throws Exception {
        String repository = this.getRepository();
        String workspace = this.getWorkSpace();
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List documentsType = templateService.getDocumentTemplates(repository);
        ArrayList<Node> documentsOnTag = new ArrayList<Node>();
        WebuiRequestContext ctx = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        SessionProvider sessionProvider = ctx.getRemoteUser() == null ? SessionProviderFactory.createAnonimProvider() : SessionProviderFactory.createSessionProvider();
        try {
            for (Node node : newFolksonomyService.getAllDocumentsByTag(this.tagPath_, repository, workspace, sessionProvider)) {
                if (!documentsType.contains(node.getPrimaryNodeType().getName())) continue;
                documentsOnTag.add(node);
            }
        }
        catch (PathNotFoundException ex) {
            // empty catch block
        }
        return documentsOnTag;
    }

    public String getIcons(Node node, String type) throws Exception {
        try {
            return Utils.getNodeTypeIcon((Node)node, (String)type);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getImage(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node contentNode = null;
        if (node.hasNode("exo:image")) {
            contentNode = node.getNode("exo:image");
        } else if (node.hasNode("jcr:content")) {
            if (!node.getPrimaryNodeType().getName().equals("nt:file")) {
                return "";
            }
            contentNode = node.getNode("jcr:content");
            String mimeType = contentNode.getProperty("jcr:mimeType").getString();
            if (mimeType.startsWith("text")) {
                return contentNode.getProperty("jcr:data").getString();
            }
        }
        if (contentNode == null) {
            return null;
        }
        InputStream input = contentNode.getProperty("jcr:data").getStream();
        if (input.available() == 0) {
            return null;
        }
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getImage(Node node, String nodeTypeName) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node contentNode = null;
        if (node.hasNode(nodeTypeName)) {
            contentNode = node.getNode(nodeTypeName);
        } else if (node.hasNode("jcr:content")) {
            if (!node.getPrimaryNodeType().getName().equals("nt:file")) {
                return "";
            }
            contentNode = node.getNode("jcr:content");
            String mimeType = contentNode.getProperty("jcr:mimeType").getString();
            if (mimeType.startsWith("text")) {
                return contentNode.getProperty("jcr:data").getString();
            }
        }
        if (contentNode == null) {
            return null;
        }
        InputStream input = contentNode.getProperty("jcr:data").getStream();
        if (input.available() == 0) {
            return null;
        }
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public int getItemPerPage() {
        return Integer.parseInt(this.getPortletPreferences().getValue(Utils.CB_NB_PER_PAGE, ""));
    }

    public Node getNodeByPath(String nodePath) throws Exception {
        if (nodePath == null) {
            return null;
        }
        NodeFinder nodeFinder = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
        String repository = this.getRepository();
        try {
            if (this.wsName_ == null) {
                this.wsName_ = this.getWorkSpace();
            }
            return (Node)nodeFinder.getItem(repository, this.wsName_, nodePath);
        }
        catch (PathNotFoundException path) {
            String[] wsNames;
            RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
            for (String wsName : wsNames = repositoryService.getRepository(repository).getWorkspaceNames()) {
                Node targetNode = null;
                try {
                    targetNode = (Node)nodeFinder.getItem(repository, wsName, nodePath);
                }
                catch (Exception e) {
                    targetNode = null;
                }
                if (targetNode == null) continue;
                return targetNode;
            }
            LOG.error((Object)("PathNotFoundException when get node by path = " + nodePath), (Throwable)path);
            return null;
        }
        catch (AccessDeniedException ace) {
            LOG.error((Object)("AccessDeniedException when get node by path = " + nodePath), (Throwable)ace);
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)("Exception when get node by path = " + nodePath), (Throwable)e);
            return null;
        }
    }

    public Node getNodeByPath(String nodePath, String workspace) throws Exception {
        NodeFinder nodeFinder = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
        try {
            return (Node)nodeFinder.getItem(this.getRepository(), workspace, nodePath);
        }
        catch (PathNotFoundException path) {
            return null;
        }
        catch (AccessDeniedException ace) {
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)("Exception when get node by path = " + nodePath + " in workspace " + workspace), (Throwable)e);
            return null;
        }
    }

    public String getCapacityOfFile(Node file) throws Exception {
        Node contentNode = file.getNode("jcr:content");
        InputStream in = contentNode.getProperty("jcr:data").getStream();
        float capacity = in.available() / 1024;
        String strCapacity = Float.toString(capacity);
        if (strCapacity.indexOf(".") > -1) {
            return strCapacity.substring(0, strCapacity.lastIndexOf("."));
        }
        return strCapacity;
    }

    public boolean isPublishedNode(Node node) throws Exception {
        PublicationService publicationService;
        return this.isAllowPublish() && (publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class)).isNodeEnrolledInLifecycle(node) && publicationService.getCurrentState(node).equals("published");
    }

    public Node getViewNode(Node node) throws Exception {
        if (this.isPublishedNode(node)) {
            PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
            return publicationService.getNodePublish(node, null);
        }
        return node;
    }

    private void addNodePublish(List<Node> listNode, Node node) throws Exception {
        if (this.isPublishedNode(node)) {
            listNode.add(node);
        } else {
            listNode.add(node);
        }
    }

    public List<Node> getNodeByQuery(int recordNumber) throws Exception {
        ArrayList<Node> queryDocuments = new ArrayList<Node>();
        try {
            QueryResult queryResult = null;
            queryResult = Boolean.parseBoolean(this.getPortletPreferences().getValue(Utils.CB_QUERY_ISNEW, "")) ? this.getQueryResultNew() : this.getQueryResultStored();
            NodeIterator iter = queryResult.getNodes();
            int count = 0;
            while (iter.hasNext() && count++ != recordNumber) {
                Node node = iter.nextNode();
                if (this.isAllowPublish() && !this.isPublishedNode(node)) continue;
                queryDocuments.add(node);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"An error occured while loading the result", (Throwable)e);
        }
        return queryDocuments;
    }

    public QueryResult getQueryResultNew() throws Exception {
        String queryStatement = this.getQueryStatement();
        QueryManager queryManager = this.getSession(false).getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryStatement, this.getQueryLanguage());
        return query.execute();
    }

    public QueryResult getQueryResultStored() throws Exception {
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        String queryPath = this.getPortletPreferences().getValue(Utils.CB_QUERY_STORE, "");
        String workspace = this.getWorkSpace();
        String repository = this.getRepository();
        return queryService.execute(queryPath, workspace, repository, this.getSystemProvider(), this.getSession(true).getUserID());
    }

    public boolean nodeIsLocked(Node node) throws Exception {
        if (node.isLocked()) {
            return !Utils.isLockTokenHolder((Node)node);
        }
        return false;
    }

    public boolean hasAddPermission(Node node) {
        ExtendedNode eNode = (ExtendedNode)node;
        try {
            eNode.checkPermission("add_node");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setKeyValue(String keyValue) {
        this.keyValue_ = keyValue;
    }

    public String getKeyValue() {
        return this.keyValue_;
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        String[] workspaces;
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(this.getRepository());
        for (String ws : workspaces = manageRepo.getWorkspaceNames()) {
            try {
                if (Boolean.parseBoolean(this.getPortletPreferences().getValue(Utils.CB_FILTER_CATEGORY, ""))) {
                    return SessionProviderFactory.createSessionProvider().getSession(ws, manageRepo).getNodeByUUID(uuid);
                }
                return SessionProviderFactory.createSystemProvider().getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public List<Node> getNodeByQuery(int recoderNumber, Session session) throws Exception {
        ArrayList<Node> queryDocuments = new ArrayList<Node>();
        QueryManager queryManager = null;
        try {
            queryManager = session.getWorkspace().getQueryManager();
        }
        catch (Exception e) {
            LOG.error((Object)"An error occured while retrieving the query manager", (Throwable)e);
            return queryDocuments;
        }
        String queryStatiement = this.getQueryStatement();
        if (!Boolean.parseBoolean(this.getPortletPreferences().getValue(Utils.CB_QUERY_ISNEW, ""))) {
            String queryPath = this.getPortletPreferences().getValue(Utils.CB_QUERY_STORE, "");
            Node queryNode = this.getNodeByPath(queryPath);
            queryStatiement = queryNode.getProperty("jcr:statement").getString();
        }
        Query query = queryManager.createQuery(queryStatiement, this.getQueryLanguage());
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        int count = 0;
        while (iter.hasNext() && count++ != recoderNumber) {
            Node node = iter.nextNode();
            this.addNodePublish(queryDocuments, node);
        }
        return queryDocuments;
    }

    public List<Node> getNodeByQuery(String queryType, String queryString) throws Exception {
        ArrayList<Node> queryDocuments = new ArrayList<Node>();
        try {
            ManageableRepository repository = this.getRepositoryService().getRepository(this.getRepository());
            String workspace = repository.getConfiguration().getDefaultWorkspaceName();
            QueryManager queryManager = null;
            Session session = this.getSystemProvider().getSession(workspace, repository);
            queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString, queryType);
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                this.addNodePublish(queryDocuments, node);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception when execute query: " + queryString), (Throwable)e);
        }
        this.totalRecord_ = queryDocuments.size();
        return queryDocuments;
    }

    public LinkedList<String> getNodesHistory() {
        return this.nodesHistory_;
    }

    public int getTotalNodeByQuery() {
        return this.totalRecord_;
    }

    public int getNumberOfPage() {
        return this.uiPageIterator_.getAvailablePage();
    }

    public String getOwner(Node node) throws Exception {
        if (node.hasProperty("exo:owner")) {
            return node.getProperty("exo:owner").getString();
        }
        return SystemIdentity.ANONIM;
    }

    public Map getPathContent() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        List templates = templateService.getDocumentTemplates(this.getRepository());
        ArrayList<String> tabList = new ArrayList<String>();
        ArrayList<String> subCategoryList = new ArrayList<String>();
        ArrayList<Node> subDocumentList = new ArrayList<Node>();
        HashMap<String, Object> content = new HashMap<String, Object>();
        boolean isShowDocument = this.isEnableChildDocument();
        boolean isShowReferenced = this.isEnableRefDocument();
        int itemCounter = this.getRowPerBlock();
        if (this.isShowAllDocument()) {
            itemCounter = this.getItemPerPage();
        }
        if (this.selectedTabPath_.equals(this.currentPath_)) {
            Node currentNode = this.getCurrentNode();
            LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
            if (currentNode.isNodeType("exo:symlink")) {
                currentNode = linkManager.getTarget(currentNode);
            }
            NodeIterator tabIter = currentNode.getNodes();
            while (tabIter.hasNext()) {
                Node childNode = tabIter.nextNode();
                if (!this.canRead(childNode) || childNode.isNodeType("exo:hiddenable")) continue;
                NodeType nt = childNode.getPrimaryNodeType();
                if (templates.contains(nt.getName()) && isShowDocument) {
                    subDocumentList.add(childNode);
                }
                if (isShowReferenced) {
                    subDocumentList.addAll(this.getReferences(repositoryService, childNode, this.isShowAllDocument(), subDocumentList.size(), templates));
                }
                if (!this.isCategories(childNode) || templates.contains(nt.getName())) continue;
                HashMap childOfSubCategory = new HashMap();
                ArrayList<Node> subCategoryDoc = new ArrayList<Node>();
                ArrayList<String> subCategoryCat = new ArrayList<String>();
                Node tempChildNode = childNode;
                if (childNode.isNodeType("exo:symlink")) {
                    try {
                        childNode = linkManager.getTarget(childNode);
                    }
                    catch (ItemNotFoundException ie) {
                        continue;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                NodeIterator item = childNode.getNodes();
                while (item.hasNext()) {
                    Node nodecheck;
                    PublicationService publicationService;
                    Node node = item.nextNode();
                    if (!this.canRead(node) || node.isNodeType("exo:hiddenable")) continue;
                    NodeType nodeType = node.getPrimaryNodeType();
                    String typeName = nodeType.getName();
                    if (node.isNodeType("exo:symlink")) {
                        typeName = node.getProperty("exo:primaryType").getString();
                    }
                    if (templates.contains(typeName) && isShowDocument && subCategoryDoc.size() < this.getRowPerBlock()) {
                        if (this.isAllowPublish()) {
                            publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
                            nodecheck = publicationService.getNodePublish(node, null);
                            if (nodecheck != null) {
                                subCategoryDoc.add(node);
                                if (PermissionUtil.canRead((Node)node) && node.isNodeType("exo:symlink")) {
                                    try {
                                        linkManager.getTarget(node);
                                    }
                                    catch (ItemNotFoundException ie) {
                                        subCategoryDoc.remove(node);
                                    }
                                    catch (Exception e) {
                                        subCategoryDoc.remove(node);
                                    }
                                }
                            }
                        } else {
                            subCategoryDoc.add(node);
                            if (PermissionUtil.canRead((Node)node) && node.isNodeType("exo:symlink")) {
                                try {
                                    linkManager.getTarget(node);
                                }
                                catch (ItemNotFoundException ie) {
                                    subCategoryDoc.remove(node);
                                }
                                catch (Exception e) {
                                    subCategoryDoc.remove(node);
                                }
                            }
                        }
                    }
                    if (!this.isCategories(node) || templates.contains(nodeType.getName())) continue;
                    if (this.isAllowPublish()) {
                        publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
                        nodecheck = publicationService.getNodePublish(node, null);
                        if (nodecheck == null) continue;
                        subCategoryCat.add(nodecheck.getPath());
                        continue;
                    }
                    subCategoryCat.add(node.getPath());
                }
                if (isShowReferenced) {
                    subCategoryDoc.addAll(this.getReferences(repositoryService, childNode, false, subCategoryDoc.size(), templates));
                }
                childOfSubCategory.put("doc", subCategoryDoc);
                childOfSubCategory.put("sub", subCategoryCat);
                childNode = tempChildNode;
                String path = childNode.getPath();
                String keyPath = path.substring(path.lastIndexOf("/") + 1);
                content.put(keyPath, childOfSubCategory);
                subCategoryList.add(path);
            }
            content.put("tabList", tabList);
            content.put("subDocumentList", subDocumentList);
            content.put("subCategoryList", subCategoryList);
            return content;
        }
        NodeIterator tabIter = null;
        try {
            tabIter = this.getCurrentNode().getNodes();
        }
        catch (Exception e) {
            tabIter = this.getRootNode().getNodes();
        }
        while (tabIter.hasNext()) {
            Node tab = tabIter.nextNode();
            if (!this.canRead(tab) || tab.isNodeType("exo:hiddenable") || templates.contains(tab.getPrimaryNodeType().getName())) continue;
            if (this.isCategories(tab)) {
                tabList.add(tab.getPath());
            }
            if (!tab.getPath().equals(this.getSelectedTab().getPath())) continue;
            NodeIterator childs = tab.getNodes();
            while (childs.hasNext()) {
                Node child = childs.nextNode();
                String nt = child.getPrimaryNodeType().getName();
                if (Utils.isSymLink((Node)child)) {
                    nt = child.getProperty("exo:primaryType").getString();
                }
                if (templates.contains(nt) && isShowDocument && subDocumentList.size() < itemCounter) {
                    subDocumentList.add(child);
                }
                if (!this.isCategories(child) || templates.contains(nt)) continue;
                Map childOfSubCategory = this.getChildOfSubCategory(repositoryService, child, templates);
                content.put(child.getName(), childOfSubCategory);
                subCategoryList.add(child.getPath());
            }
            if (!isShowReferenced) continue;
            subDocumentList.addAll(this.getReferences(repositoryService, this.getSelectedTab(), this.isShowAllDocument(), subDocumentList.size(), templates));
        }
        content.put("tabList", tabList);
        content.put("subCategoryList", subCategoryList);
        content.put("subDocumentList", subDocumentList);
        List history = new ArrayList();
        Node currentNode = null;
        try {
            currentNode = this.getCurrentNode();
            currentNode.getParent();
        }
        catch (Exception e) {
            currentNode = this.getRootNode();
        }
        if (!currentNode.getPath().equals("/") && currentNode.getSession().getWorkspace().getName().equals(this.getWorkSpace())) {
            Node parent = currentNode.getParent();
            if (!parent.getPath().equals(this.getRootNode().getPath())) {
                content.put("previous", parent.getPath());
            }
            history = this.getHistory(templates, parent);
        }
        content.put(HISTORY, history);
        return content;
    }

    public PortletPreferences getPortletPreferences() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest prequest = pcontext.getRequest();
        PortletPreferences portletPref = prequest.getPreferences();
        return portletPref;
    }

    public String getQueryLanguage() {
        return this.getPortletPreferences().getValue(Utils.CB_QUERY_LANGUAGE, "");
    }

    public String getQueryStatement() {
        return this.getPortletPreferences().getValue(Utils.CB_QUERY_STATEMENT, "");
    }

    public String getRepository() {
        return this.getPortletPreferences().getValue(Utils.REPOSITORY, "");
    }

    public String getUserName() {
        try {
            return this.getSession(this.getRepository(), this.getWorkSpace()).getUserID();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getRootPath() {
        return this.rootPath_;
    }

    public Node getRootNode() throws Exception {
        return this.getNodeByPath(this.rootPath_);
    }

    public int getRowPerBlock() {
        return this.rowPerBlock_;
    }

    public void setSelectedTabPath(String selectedTabPath) {
        if (selectedTabPath == null) {
            selectedTabPath = this.rootPath_;
        } else {
            this.selectedTabPath_ = selectedTabPath;
        }
    }

    public Node getSelectedTab() throws Exception {
        if (this.selectedTabPath_ == null) {
            return this.getCurrentNode();
        }
        return this.getNodeByPath(this.selectedTabPath_);
    }

    public Session getSession(boolean flag) throws Exception {
        Session session = null;
        String workspace = "";
        workspace = flag ? this.getDmsSystemWorkspace() : this.getWorkSpace();
        ManageableRepository manageableRepository = this.getRepositoryService().getRepository(this.getRepository());
        session = this.categoryPath_ != null && this.categoryPath_.startsWith("/jcr:system") ? (!Boolean.parseBoolean(this.getPortletPreferences().getValue(Utils.CB_FILTER_CATEGORY, "")) ? this.getSystemProvider().getSession(workspace, manageableRepository) : this.getSessionProvider().getSession(workspace, manageableRepository)) : (SessionProviderFactory.isAnonim() ? this.getAnonimProvider().getSession(workspace, manageableRepository) : this.getSessionProvider().getSession(workspace, manageableRepository));
        return session;
    }

    public Session getSession(String repository, String workspace) throws Exception {
        Session session = null;
        ManageableRepository manageableRepository = this.getRepositoryService().getRepository(repository);
        session = this.categoryPath_ != null && this.categoryPath_.startsWith("/jcr:system") ? (!Boolean.parseBoolean(this.getPortletPreferences().getValue(Utils.CB_FILTER_CATEGORY, "")) ? this.getSystemProvider().getSession(workspace, manageableRepository) : this.getSessionProvider().getSession(workspace, manageableRepository)) : (SessionProviderFactory.isAnonim() ? this.getAnonimProvider().getSession(workspace, manageableRepository) : this.getSessionProvider().getSession(workspace, manageableRepository));
        return session;
    }

    public SessionProvider getSessionProvider() {
        return SessionProviderFactory.createSessionProvider();
    }

    public List<Node> getSubDocumentList(Node selectedNode) throws Exception {
        List templates;
        ArrayList<Node> subDocumentList;
        block11: {
            subDocumentList = new ArrayList<Node>();
            if (selectedNode == null) {
                return subDocumentList;
            }
            LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
            if (selectedNode.isNodeType("exo:symlink")) {
                selectedNode = linkManager.getTarget(selectedNode);
            }
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            templates = templateService.getDocumentTemplates(this.getRepository());
            try {
                NodeIterator item = selectedNode.getNodes();
                if (!this.isEnableChildDocument()) break block11;
                while (item.hasNext()) {
                    Node node = item.nextNode();
                    String typeName = node.getPrimaryNodeType().getName();
                    if (node.isNodeType("exo:symlink")) {
                        typeName = node.getProperty("exo:primaryType").getString();
                    }
                    if (!templates.contains(typeName) || !this.canRead(node)) continue;
                    if (node.isNodeType("exo:symlink")) {
                        try {
                            linkManager.getTarget(node);
                        }
                        catch (ItemNotFoundException ie) {
                            subDocumentList.remove(node);
                        }
                        catch (Exception e) {
                            subDocumentList.remove(node);
                        }
                    }
                    if (this.isAllowPublish() && !this.isPublishedNode(node)) continue;
                    subDocumentList.add(node);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                return new ArrayList<Node>();
            }
        }
        if (this.isEnableRefDocument()) {
            subDocumentList.addAll(this.getReferences(this.getRepositoryService(), selectedNode, this.isShowAllDocument(), subDocumentList.size(), templates));
        }
        return subDocumentList;
    }

    public SessionProvider getSystemProvider() {
        return SessionProviderFactory.createSystemProvider();
    }

    public List<Node> getTagLink() throws Exception {
        String repository = this.getRepository();
        String workspace = this.getWorkSpace();
        String user = this.getSession(repository, workspace).getUserID();
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        return newFolksonomyService.getAllPrivateTags(user, repository, workspace);
    }

    public String getTagPath() {
        return this.tagPath_;
    }

    public Map<String, String> getTagStyle() throws Exception {
        String repository = this.getRepository();
        String workspace = this.getWorkSpace();
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        HashMap<String, String> tagStyle = new HashMap<String, String>();
        for (Node tag : newFolksonomyService.getAllTagStyle(repository, workspace)) {
            tagStyle.put(tag.getName(), tag.getProperty("exo:htmlStyle").getValue().getString());
        }
        return tagStyle;
    }

    public String getTemplate() {
        PortletRequestContext context = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        PortletRequest portletRequest = context.getRequest();
        WindowState currentWindowState = portletRequest.getWindowState();
        if (this.windowState_.containsKey(this.windowId_)) {
            WindowState keptWindowState = (WindowState)this.windowState_.get(this.windowId_);
            if (this.isShowDetailDocument_ && currentWindowState.equals((Object)WindowState.NORMAL) && keptWindowState.equals((Object)WindowState.MAXIMIZED)) {
                this.setShowDocumentDetail(false);
                this.windowState_.clear();
                return this.templatePath_;
            }
        }
        if (this.isShowDetailDocument_) {
            return this.detailTemplate_;
        }
        return this.templatePath_;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        if (this.jcrTemplateResourceResolver_ == null) {
            this.newJCRTemplateResourceResolver();
        }
        return this.jcrTemplateResourceResolver_;
    }

    public List<Node> getSortedListNode(Node node, boolean isASC) throws Exception {
        NodeIterator nodeIter = node.getNodes();
        ArrayList<Node> nodes = new ArrayList<Node>();
        while (nodeIter.hasNext()) {
            Node childNode = nodeIter.nextNode();
            nodes.add(childNode);
        }
        if (isASC) {
            Collections.sort(nodes, new NodeNameASCComparator());
        } else {
            Collections.sort(nodes, new NodeNameDESCComparator());
        }
        return nodes;
    }

    public List<Node> getSortedListFolderNode(Node node, boolean isASC) throws Exception {
        NodeIterator nodeIter = node.getNodes();
        ArrayList<Node> nodes = new ArrayList<Node>();
        while (nodeIter.hasNext()) {
            Node childNode = nodeIter.nextNode();
            String primaryType = childNode.getPrimaryNodeType().getName();
            if (!primaryType.equals("nt:unstructured") && !primaryType.equals("nt:folder")) continue;
            nodes.add(childNode);
        }
        if (isASC) {
            Collections.sort(nodes, new NodeNameASCComparator());
        } else {
            Collections.sort(nodes, new NodeNameDESCComparator());
        }
        return nodes;
    }

    public List<Node> getSortedListNodeByDate(Node node, boolean isASC) throws Exception {
        NodeIterator nodeIter = node.getNodes();
        ArrayList<Node> nodes = new ArrayList<Node>();
        while (nodeIter.hasNext()) {
            Node childNode = nodeIter.nextNode();
            nodes.add(childNode);
        }
        if (isASC) {
            Collections.sort(nodes, new DateASCComparator());
        } else {
            Collections.sort(nodes, new DateDESCComparator());
        }
        return nodes;
    }

    public boolean isSymLink(String nodePath) throws Exception {
        Node node = (Node)this.getSession(false).getItem(nodePath);
        return Utils.isSymLink((Node)node);
    }

    public Map getTreeContent() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        List templates = templateService.getDocumentTemplates(this.getRepository());
        ArrayList<String> subCategoryList = new ArrayList<String>();
        ArrayList<Node> subDocumentList = new ArrayList<Node>();
        Node currentNode = this.getCurrentNode();
        HashMap<String, Object> content = new HashMap<String, Object>();
        if (currentNode != null) {
            LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
            if (currentNode.isNodeType("exo:symlink")) {
                currentNode = linkManager.getTarget(currentNode);
            }
            NodeIterator childIter = currentNode.getNodes();
            boolean isShowDocument = this.isEnableChildDocument();
            boolean isShowReferenced = this.isEnableRefDocument();
            while (childIter.hasNext()) {
                Node child = childIter.nextNode();
                if (!this.canRead(child) || child.isNodeType("exo:hiddenable")) continue;
                String typeName = child.getPrimaryNodeType().getName();
                if (child.isNodeType("exo:symlink")) {
                    typeName = child.getProperty("exo:primaryType").getString();
                }
                if (templates.contains(typeName) && isShowDocument) {
                    if (!this.canRead(child)) continue;
                    subDocumentList.add(child);
                    continue;
                }
                if (!this.isCategories(child)) continue;
                Map childOfSubCategory = this.getChildOfSubCategory(repositoryService, child, templates);
                String path = child.getPath();
                String keyPath = path.substring(path.lastIndexOf("/") + 1);
                content.put(keyPath, childOfSubCategory);
                subCategoryList.add(path);
            }
            if (isShowReferenced) {
                subDocumentList.addAll(this.getReferences(repositoryService, currentNode, this.isShowAllDocument(), subDocumentList.size(), templates));
            }
            content.put("subCategoryList", subCategoryList);
            content.put("subDocumentList", subDocumentList);
        }
        return content;
    }

    public BCTreeNode getTreeRoot() {
        return this.treeRoot_;
    }

    public UIPageIterator getUIPageIterator() throws Exception {
        return this.uiPageIterator_;
    }

    public String getUseCase() {
        return this.getPortletPreferences().getValue(Utils.CB_USECASE, "");
    }

    public void setWorkspaceName(String wsName) {
        this.wsName_ = wsName;
    }

    public String getWorkSpace() {
        return this.getPortletPreferences().getValue(Utils.WORKSPACE_NAME, "");
    }

    public String getDMSSystemWorkspace(String repository) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        DMSConfiguration dmsConfiguration = (DMSConfiguration)container.getComponentInstanceOfType(DMSConfiguration.class);
        DMSRepositoryConfiguration dmsRepoConfig = dmsConfiguration.getConfig(repository);
        return dmsRepoConfig.getSystemWorkspace();
    }

    public void initToolBar(boolean showTree, boolean showPath, boolean showSearch) throws Exception {
        UIToolBar toolBar = (UIToolBar)this.getChild(UIToolBar.class);
        toolBar.setEnableTree(showTree);
        toolBar.setEnablePath(showPath);
        toolBar.setEnableSearch(showSearch);
        toolBar.setRendered(true);
    }

    public boolean isCommentAndVote() {
        return this.isShowVoteForm() || this.isShowCommentForm();
    }

    public boolean isEnableChildDocument() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(Utils.CB_CHILD_DOCUMENT, ""));
    }

    public boolean isAllowPublish() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(Utils.CB_ALLOW_PUBLISH, ""));
    }

    public boolean isEnableRefDocument() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(Utils.CB_REF_DOCUMENT, ""));
    }

    public boolean isEnableToolBar() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(Utils.CB_VIEW_TOOLBAR, ""));
    }

    public boolean isRootNode() throws Exception {
        return this.getCurrentNode().equals(this.getRootNode());
    }

    public boolean isShowAllDocument() {
        return this.isShowAllDocument_;
    }

    public boolean isShowCategoryTree() {
        return this.isShowCategoriesTree_;
    }

    public boolean isShowCommentForm() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(Utils.CB_VIEW_COMMENT, ""));
    }

    public boolean isShowDocumentByTag() {
        return this.isShowDocumentByTag_;
    }

    public boolean isShowDocumentDetail() {
        return this.isShowDetailDocument_;
    }

    public boolean isShowDocumentList() {
        return this.isShowDocumentList_;
    }

    public boolean isShowSearchForm() {
        return this.isShowSearchForm_;
    }

    public boolean isShowTagmap() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(Utils.CB_VIEW_TAGMAP, ""));
    }

    public boolean isShowVoteForm() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(Utils.CB_VIEW_VOTE, ""));
    }

    public void loadPortletConfig(PortletPreferences preferences) throws Exception {
        String tempName = preferences.getValue("template", "");
        String repoName = preferences.getValue(Utils.REPOSITORY, "");
        ManageViewService viewService = (ManageViewService)this.getApplicationComponent(ManageViewService.class);
        this.setShowDocumentByTag(false);
        this.setShowDocumentDetail(false);
        if (this.getUseCase().equals(Utils.CB_USE_JCR_QUERY)) {
            this.setTemplate(viewService.getTemplateHome("cbQueryTemplates", repoName, SessionProviderFactory.createSystemProvider()).getNode(tempName).getPath());
            if (this.isShowCommentForm() || this.isShowVoteForm()) {
                this.initToolBar(false, false, false);
            }
            if (!this.isShowDocumentByTag()) {
                this.setPageIterator(this.getNodeByQuery(-1));
            }
            return;
        }
        if (this.getUseCase().equals(Utils.CB_USE_SCRIPT)) {
            this.setTemplate(viewService.getTemplateHome("cbScriptTemplates", repoName, SessionProviderFactory.createSystemProvider()).getNode(tempName).getPath());
            if (this.isShowCommentForm() || this.isShowVoteForm()) {
                this.initToolBar(false, false, false);
            }
            String scriptName = preferences.getValue(Utils.CB_SCRIPT_NAME, "");
            if (!this.isShowDocumentByTag()) {
                this.setPageIterator(this.getNodeByScript(repoName, scriptName));
            }
            return;
        }
        String categoryPath = preferences.getValue(Utils.JCR_PATH, "");
        NodeFinder nodeFinder_ = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
        LinkManager linkManager_ = (LinkManager)this.getApplicationComponent(LinkManager.class);
        Node categoryNode = null;
        try {
            categoryNode = (Node)nodeFinder_.getItem(repoName, this.getWorkSpace(), categoryPath);
            this.setRootPath(categoryPath);
            this.setCategoryPath(categoryPath);
            this.setSelectedTabPath(categoryPath);
            this.setCurrentNodePath(categoryPath);
        }
        catch (Exception e) {
            this.setRootPath(null);
            this.setCategoryPath(null);
            this.setSelectedTabPath(null);
            this.setCurrentNodePath(null);
        }
        if (linkManager_.isLink((Item)categoryNode) && linkManager_.isTargetReachable(categoryNode)) {
            categoryNode = linkManager_.getTarget(categoryNode);
        }
        if (this.getUseCase().equals(Utils.CB_USE_FROM_PATH)) {
            this.setTemplate(viewService.getTemplateHome("cbPathTemplates", repoName, SessionProviderFactory.createSystemProvider()).getNode(tempName).getPath());
            this.initToolBar(false, this.isEnableToolBar(), this.isEnableToolBar());
            if (this.getTemplateName().equals(TREELIST)) {
                if (this.isEnableToolBar()) {
                    this.initToolBar(true, false, true);
                }
                ((UICategoryTree)this.getChild(UICategoryTree.class)).setTreeRoot(this.getRootNode());
                if (this.getCurrentNode() != null) {
                    ((UICategoryTree)this.getChild(UICategoryTree.class)).buildTree(this.getCurrentNode().getPath());
                }
            }
            if (!this.isShowDocumentByTag()) {
                this.setPageIterator(this.getSubDocumentList(this.getSelectedTab()));
            }
            return;
        }
        if (this.getUseCase().equals(Utils.CB_USE_DOCUMENT)) {
            this.setTemplateDetail(viewService.getTemplateHome("cbDetaiViewTemplates", repoName, SessionProviderFactory.createSystemProvider()).getNode(tempName).getPath());
            String documentPath = categoryPath.equals("/") && preferences.getValue(Utils.CB_DOCUMENT_NAME, "").indexOf("/") == 0 ? preferences.getValue(Utils.CB_DOCUMENT_NAME, "") : categoryPath + preferences.getValue(Utils.CB_DOCUMENT_NAME, "");
            Node documentNode = null;
            try {
                documentNode = (Node)nodeFinder_.getItem(repoName, this.getWorkSpace(), documentPath);
                if (linkManager_.isLink((Item)documentNode) && linkManager_.isTargetReachable(documentNode)) {
                    documentNode = linkManager_.getTarget(documentNode);
                }
            }
            catch (Exception e) {
                this.setRootPath(null);
                this.setCategoryPath(null);
                this.setSelectedTabPath(null);
                this.setCurrentNodePath(null);
                return;
            }
            this.viewDocument(documentNode, false);
            if (this.isEnableToolBar()) {
                this.initToolBar(false, false, false);
            }
            return;
        }
    }

    public String getDmsSystemWorkspace() {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        DMSRepositoryConfiguration dmsRepoConfig = dmsConfiguration.getConfig(this.getRepository());
        return dmsRepoConfig.getSystemWorkspace();
    }

    public void newJCRTemplateResourceResolver() {
        try {
            this.jcrTemplateResourceResolver_ = new JCRResourceResolver(this.getRepository(), this.getDmsSystemWorkspace(), "exo:templateFile");
        }
        catch (Exception e) {
            LOG.error((Object)"An error occured while creating a new JCR Resource resolver", (Throwable)e);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        try {
            ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(this.getRepository());
            if (this.getCurrentNode() != null) {
                super.processRender(context);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"An error occured while displaying the content", (Throwable)e);
            ((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).setPorletMode(PortletMode.HELP);
            return;
        }
    }

    public void record(String str) {
        this.getNodesHistory().add(str);
    }

    public void refreshContent() throws Exception {
        if (!this.showPageAction()) {
            if (this.isShowDocumentByTag()) {
                this.setPageIterator(this.getDocumentByTag());
            } else {
                if (this.getUseCase().equals(Utils.CB_USE_FROM_PATH)) {
                    if (this.getCategoryPath() != null && this.getRootNode() != null && (this.getNodeByPath(this.getSelectedTab().getPath()) == null || this.getNodeByPath(this.getCurrentNode().getPath()) == null)) {
                        this.setSelectedTabPath(null);
                        this.setCurrentNodePath(null);
                    }
                    this.setPageIterator(this.getSubDocumentList(this.getSelectedTab()));
                } else if (this.getUseCase().equals(Utils.CB_USE_SCRIPT)) {
                    PortletPreferences preferences = this.getPortletPreferences();
                    String tempName = preferences.getValue("template", "");
                    String repoName = preferences.getValue(Utils.REPOSITORY, "");
                    ManageViewService viewService = (ManageViewService)this.getApplicationComponent(ManageViewService.class);
                    this.setTemplate(viewService.getTemplateHome("cbScriptTemplates", repoName, SessionProviderFactory.createSystemProvider()).getNode(tempName).getPath());
                    if (this.isShowCommentForm() || this.isShowVoteForm()) {
                        this.initToolBar(false, false, false);
                    }
                    String scriptName = preferences.getValue(Utils.CB_SCRIPT_NAME, "");
                    if (!this.isShowDocumentByTag()) {
                        this.setPageIterator(this.getNodeByScript(repoName, scriptName));
                    }
                } else if (this.getUseCase().equals(Utils.CB_USE_JCR_QUERY)) {
                    this.setPageIterator(this.getNodeByQuery(-1));
                } else if (this.getUseCase().equals(Utils.USE_DOCUMENT)) {
                    if (((UIDocumentDetail)this.getChild(UIDocumentDetail.class)).isValidNode()) {
                        ((UIDocumentDetail)this.getChild(UIDocumentDetail.class)).setRendered(true);
                    } else {
                        ((UIDocumentDetail)this.getChild(UIDocumentDetail.class)).setRendered(false);
                        UIBrowseContentPortlet uiPortlet = (UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class);
                        ((UIPopupContainer)uiPortlet.getChild(UIPopupContainer.class)).deActivate();
                    }
                }
                if (this.isShowDocumentDetail()) {
                    UIDocumentDetail uiDocumentDetail = (UIDocumentDetail)this.getChild(UIDocumentDetail.class);
                    if (((UIDocumentDetail)this.getChild(UIDocumentDetail.class)).isValidNode()) {
                        ((UIDocumentDetail)this.getChild(UIDocumentDetail.class)).setRendered(true);
                    } else if (this.isShowDocumentByTag() && this.isShowDocumentDetail()) {
                        this.setShowDocumentDetail(false);
                        uiDocumentDetail.setRendered(false);
                    } else {
                        this.setShowDocumentByTag(false);
                        this.setShowDocumentDetail(false);
                        uiDocumentDetail.setRendered(false);
                        if (this.getUseCase().equals(Utils.CB_USE_FROM_PATH) && this.getHistory() != null) {
                            this.setCurrentNodePath(((Node)this.getHistory().get("currentNode")).getPath());
                            this.setSelectedTabPath(((Node)this.getHistory().get(KEY_SELECTED)).getPath());
                            this.getHistory().clear();
                        }
                        UIBrowseContentPortlet uiPortlet = (UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class);
                        ((UIPopupContainer)uiPortlet.getChild(UIPopupContainer.class)).deActivate();
                    }
                }
            }
            this.setShowPageAction(false);
        }
    }

    public void setCategoryPath(String path) {
        this.categoryPath_ = path;
    }

    public void setCurrentNodePath(String currentPath) {
        if (currentPath == null) {
            currentPath = this.rootPath_;
        }
        this.currentPath_ = currentPath;
    }

    public void setPageIterator(List<Node> data) throws Exception {
        if (!this.isSetted_) {
            ObjectPageList objPageList = new ObjectPageList(data, this.getItemPerPage());
            this.uiPageIterator_.setPageList((PageList)objPageList);
        }
    }

    public boolean isSetted() {
        return this.isSetted_;
    }

    public void setPageStatus(boolean isSetted) {
        this.isSetted_ = isSetted;
    }

    public void setRowPerBlock(int number) {
        this.rowPerBlock_ = number;
    }

    public void setShowAllChildren(boolean isShowAll) {
        this.isShowAllDocument_ = isShowAll;
    }

    public void setShowCategoryTree(boolean isShowCategoryTree) {
        this.isShowCategoriesTree_ = isShowCategoryTree;
    }

    public void setShowDocumentByTag(boolean isShowByTag) {
        this.isShowDocumentByTag_ = isShowByTag;
    }

    public void setShowDocumentDetail(boolean isShowDocument) {
        this.isShowDetailDocument_ = isShowDocument;
    }

    public void setShowDocumentList(boolean isShowDocumentList) {
        this.isShowDocumentList_ = isShowDocumentList;
    }

    public void setShowSearchForm(boolean isShowSearch) {
        this.isShowSearchForm_ = isShowSearch;
    }

    public void setTagPath(String tagPath) {
        this.tagPath_ = tagPath;
    }

    public void setTemplate(String temp) {
        this.templatePath_ = temp;
    }

    public void setTreeRoot(Node node) throws Exception {
        this.treeRoot_ = new BCTreeNode(node);
    }

    public void storeHistory() throws Exception {
        this.getHistory().clear();
        this.getHistory().put("currentNode", this.getCurrentNode());
        this.getHistory().put(KEY_SELECTED, this.getSelectedTab());
    }

    public List<Node> getListHistoryNode() {
        this.listHistoryNode.remove(null);
        return this.listHistoryNode;
    }

    public List<Node> storeListHistory(Node selectedNode) throws Exception {
        Node child;
        NodeIterator nodeIter;
        LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
        Node rootNode = this.getRootNode();
        Node parentNode = null;
        int countHistoryNode = this.listHistoryNode.size();
        if (rootNode != null && selectedNode.getPath().equals(rootNode.getPath())) {
            this.listHistoryNode.clear();
        } else {
            Node tempNode;
            parentNode = selectedNode.getParent();
            if (parentNode != null && countHistoryNode > 0 && (tempNode = (Node)this.listHistoryNode.get(countHistoryNode - 1)).isNodeType("exo:symlink")) {
                try {
                    tempNode = linkManager.getTarget(tempNode);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    return this.getListHistoryNode();
                }
                if (tempNode.getPath().equals(parentNode.getPath())) {
                    parentNode = null;
                }
            }
            Node grandParentNode = null;
            if (this.listHistoryNode.size() == 0) {
                grandParentNode = rootNode;
            } else if (this.listHistoryNode.get(this.listHistoryNode.size() - 1) != null) {
                grandParentNode = (Node)this.listHistoryNode.get(this.listHistoryNode.size() - 1);
            }
            if (grandParentNode != null && grandParentNode.hasNodes()) {
                nodeIter = grandParentNode.getNodes();
                while (nodeIter.hasNext()) {
                    Node tempChild = child = nodeIter.nextNode();
                    if (child.isNodeType("exo:symlink")) {
                        try {
                            child = linkManager.getTarget(child);
                        }
                        catch (ItemNotFoundException ie) {
                            continue;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    if (parentNode == null || !child.getPath().equals(parentNode.getPath())) continue;
                    parentNode = tempChild;
                    break;
                }
            }
        }
        if (this.listHistoryNode.size() == 0) {
            if (parentNode != null && !this.listHistoryNode.contains(parentNode)) {
                this.listHistoryNode.add(parentNode);
            }
            if (!this.listHistoryNode.contains(selectedNode)) {
                this.listHistoryNode.add(selectedNode);
            }
        } else if (this.listHistoryNode.contains(selectedNode)) {
            ArrayList listHistoryTmp = new ArrayList();
            boolean addOk = true;
            countHistoryNode = this.listHistoryNode.size();
            for (int i = 0; i < countHistoryNode; ++i) {
                if (((Node)this.listHistoryNode.get(i)).getPath().equals(selectedNode.getPath())) {
                    listHistoryTmp.add(this.listHistoryNode.get(i));
                    addOk = false;
                }
                if (!addOk) continue;
                listHistoryTmp.add(this.listHistoryNode.get(i));
            }
            this.listHistoryNode.clear();
            this.listHistoryNode.addAll(listHistoryTmp);
        } else {
            countHistoryNode = this.listHistoryNode.size();
            for (int i = 0; i < countHistoryNode; ++i) {
                if (parentNode != null && this.listHistoryNode.get(i) != null && this.listHistoryNode.get(i) == parentNode) {
                    if (!this.listHistoryNode.contains(parentNode)) {
                        this.listHistoryNode.add(i + 1, parentNode);
                        if (!this.listHistoryNode.contains(selectedNode)) {
                            this.listHistoryNode.add(i + 2, selectedNode);
                        }
                    } else if (!this.listHistoryNode.contains(selectedNode)) {
                        this.listHistoryNode.add(i + 1, selectedNode);
                    }
                } else {
                    if (!this.listHistoryNode.contains(parentNode) && parentNode != null) {
                        Node tempNode;
                        if (parentNode != null && countHistoryNode > 1 && (tempNode = (Node)this.listHistoryNode.get(countHistoryNode - 2)).isNodeType("exo:symlink") && (tempNode = linkManager.getTarget(tempNode)).getPath().equals(parentNode.getPath())) {
                            parentNode = null;
                        }
                        if (parentNode != null) {
                            this.listHistoryNode.add(parentNode);
                        }
                    }
                    if (parentNode != null && parentNode.hasNodes()) {
                        nodeIter = parentNode.getNodes();
                        while (nodeIter.hasNext()) {
                            child = nodeIter.nextNode();
                            this.listHistoryNode.remove(child);
                        }
                    }
                    if (!this.listHistoryNode.contains(selectedNode)) {
                        this.listHistoryNode.add(selectedNode);
                    }
                }
                countHistoryNode = this.listHistoryNode.size();
            }
        }
        if (this.listHistoryNode.contains(rootNode)) {
            this.listHistoryNode.remove(rootNode);
        }
        if (rootNode != null && rootNode.isNodeType("exo:symlink") && this.listHistoryNode.size() > 0) {
            Node historyNode1 = (Node)this.listHistoryNode.get(0);
            Node targetRootNode = linkManager.getTarget(rootNode);
            if (historyNode1.getPath().equals(targetRootNode.getPath())) {
                this.listHistoryNode.remove(historyNode1);
            }
        }
        return this.getListHistoryNode();
    }

    public void viewDocument(Node docNode, boolean hasDocList) throws Exception {
        this.setShowDocumentDetail(true);
        this.setShowDocumentList(hasDocList);
        UIDocumentDetail uiDocumetDetail = (UIDocumentDetail)this.getChild(UIDocumentDetail.class);
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        uiDocumetDetail.setOriginalNode(docNode);
        if (this.isAllowPublish()) {
            if (this.isPublishedNode(docNode)) {
                uiDocumetDetail.setNode(publicationService.getNodePublish(docNode, null));
            }
        } else {
            uiDocumetDetail.setNode(docNode);
        }
        uiDocumetDetail.setLanguage(null);
        uiDocumetDetail.setRendered(true);
    }

    protected Map<String, Node> getHistory() {
        return this.nodesHistoryMap_;
    }

    protected List<Node> getNodeByScript(String repository, String scriptName) throws Exception {
        DataTransfer data = new DataTransfer();
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        data.setWorkspace(this.getPortletPreferences().getValue(Utils.WORKSPACE_NAME, ""));
        data.setRepository(repository);
        Node scripts = scriptService.getCBScriptHome(repository, SessionProviderFactory.createSystemProvider());
        try {
            CmsScript cmsScript = scriptService.getScript(scripts.getName() + "/" + scriptName, repository);
            cmsScript.execute((Object)data);
        }
        catch (Exception e) {
            LOG.error((Object)"An error occured while executing the script", (Throwable)e);
            return new ArrayList<Node>();
        }
        List listNode = data.getContentList();
        ArrayList<Node> listNodeAfterCheck = new ArrayList<Node>();
        for (Node node : listNode) {
            if (this.isAllowPublish() && !this.isPublishedNode(node)) continue;
            listNodeAfterCheck.add(node);
        }
        return listNodeAfterCheck;
    }

    protected String getTemlateDetail() {
        return this.detailTemplate_;
    }

    protected String getTemplateName() {
        return this.getPortletPreferences().getValue("template", "");
    }

    protected void historyBack() throws Exception {
        if (this.getTemplateName().equals(TREELIST)) {
            this.setSelectedTabPath(null);
            this.setCurrentNodePath(this.getNodeByPath((String)this.getNodesHistory().removeLast()).getPath());
        } else {
            this.setSelectedTabPath(this.getNodeByPath((String)this.getNodesHistory().removeLast()).getPath());
        }
    }

    protected void historyNext() {
    }

    protected boolean isCategories(Node node) throws RepositoryException {
        NodeType nodeType = node.getPrimaryNodeType();
        String primaryTypeName = nodeType.getName();
        if (node.isNodeType("exo:symlink")) {
            primaryTypeName = node.getProperty("exo:primaryType").getString();
        }
        for (String type : Utils.CATEGORY_NODE_TYPES) {
            if (!primaryTypeName.equals(type)) continue;
            return true;
        }
        return false;
    }

    protected boolean isCategories(NodeType nodeType) {
        for (String type : Utils.CATEGORY_NODE_TYPES) {
            if (!nodeType.getName().equals(type)) continue;
            return true;
        }
        return false;
    }

    protected void setRootPath(String rootPath) {
        this.rootPath_ = rootPath;
    }

    protected void setShowPageAction(boolean isShowPage) {
        this.isShowPageAction_ = isShowPage;
    }

    protected void setTemplateDetail(String template) {
        this.detailTemplate_ = template;
    }

    protected boolean showPageAction() {
        return this.isShowPageAction_;
    }

    private boolean canRead(Node node) {
        ExtendedNode eNode = (ExtendedNode)node;
        try {
            eNode.checkPermission("read");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Map<String, List<? extends Object>> getChildOfSubCategory(RepositoryService repositoryService, Node subCat, List<?> documentTemplates) throws Exception {
        LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
        ArrayList<String> subCategories = new ArrayList<String>();
        ArrayList<Node> childDocOrReferencedDoc = new ArrayList<Node>();
        HashMap<String, List<? extends Object>> childMap = new HashMap<String, List<? extends Object>>();
        NodeIterator items = subCat.getNodes();
        boolean isShowDocument = this.isEnableChildDocument();
        boolean isShowReferenced = this.isEnableRefDocument();
        while (items.hasNext()) {
            Node item = items.nextNode();
            if (!this.canRead(item)) continue;
            NodeType nt = item.getPrimaryNodeType();
            String typeName = nt.getName();
            if (item.isNodeType("exo:symlink")) {
                typeName = item.getProperty("exo:primaryType").getString();
            }
            if (documentTemplates.contains(typeName) && isShowDocument) {
                if (childDocOrReferencedDoc.size() < this.getRowPerBlock()) {
                    if (this.isAllowPublish()) {
                        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
                        Node nodecheck = publicationService.getNodePublish(item, null);
                        if (nodecheck != null) {
                            childDocOrReferencedDoc.add(item);
                        }
                    } else {
                        childDocOrReferencedDoc.add(item);
                    }
                }
                if (!PermissionUtil.canRead((Node)item) || !item.isNodeType("exo:symlink")) continue;
                try {
                    linkManager.getTarget(item);
                }
                catch (ItemNotFoundException ie) {
                    childDocOrReferencedDoc.remove(item);
                }
                catch (Exception e) {
                    childDocOrReferencedDoc.remove(item);
                }
                continue;
            }
            if (!this.isCategories(item)) continue;
            subCategories.add(item.getPath());
        }
        if (isShowReferenced) {
            childDocOrReferencedDoc.addAll(this.getReferences(repositoryService, subCat, false, childDocOrReferencedDoc.size(), documentTemplates));
        }
        childMap.put("sub", subCategories);
        childMap.put("doc", childDocOrReferencedDoc);
        return childMap;
    }

    private List<String> getHistory(List<String> documentTemplates, Node parentNode) throws Exception {
        ArrayList<String> historyList = new ArrayList<String>();
        NodeIterator iter = parentNode.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            String nt = node.getPrimaryNodeType().getName();
            if (documentTemplates.contains(nt)) continue;
            historyList.add(node.getPath());
        }
        return historyList;
    }

    private List<Node> getReferences(RepositoryService repositoryService, Node node, boolean isShowAll, int size, List<?> templates) throws Exception {
        ArrayList<Node> refDocuments = new ArrayList<Node>();
        String repository = this.getRepository();
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        SessionProvider provider = null;
        provider = SessionProviderFactory.isAnonim() ? this.getSystemProvider() : this.getSessionProvider();
        if (this.isEnableRefDocument() && this.isReferenceableNode(node)) {
            String uuid = node.getUUID();
            String[] workspaces = manageableRepository.getWorkspaceNames();
            int itemCounter = this.getRowPerBlock() - size;
            if (isShowAll) {
                itemCounter = this.getItemPerPage() - size;
            }
            for (String workspace : workspaces) {
                Session session = provider.getSession(workspace, manageableRepository);
                try {
                    Node taxonomyNode = session.getNodeByUUID(uuid);
                    PropertyIterator iter = taxonomyNode.getReferences();
                    while (iter.hasNext() && refDocuments.size() < itemCounter) {
                        Node refNode = iter.nextProperty().getParent();
                        if (!templates.contains(refNode.getPrimaryNodeType().getName())) continue;
                        if (this.isAllowPublish()) {
                            PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
                            Node nodecheck = publicationService.getNodePublish(refNode, null);
                            if (nodecheck == null) continue;
                            refDocuments.add(refNode);
                            continue;
                        }
                        refDocuments.add(refNode);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return refDocuments;
    }

    private RepositoryService getRepositoryService() {
        return (RepositoryService)this.getApplicationComponent(RepositoryService.class);
    }

    private boolean isReferenceableNode(Node node) throws Exception {
        NodeType[] nodeTypes;
        for (NodeType type : nodeTypes = node.getMixinNodeTypes()) {
            if (!type.getName().equals("mix:referenceable")) continue;
            return true;
        }
        return false;
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    static /* synthetic */ List access$000(UIBrowseContainer x0) {
        return x0.listHistoryNode;
    }

    static /* synthetic */ String access$100(UIBrowseContainer x0) {
        return x0.categoryPath_;
    }

    static /* synthetic */ String access$202(UIBrowseContainer x0, String x1) {
        x0.windowId_ = x1;
        return x0.windowId_;
    }

    static /* synthetic */ String access$200(UIBrowseContainer x0) {
        return x0.windowId_;
    }

    static /* synthetic */ HashMap access$300(UIBrowseContainer x0) {
        return x0.windowState_;
    }

    static /* synthetic */ String access$400(UIBrowseContainer x0) {
        return x0.wsName_;
    }

    static /* synthetic */ String access$402(UIBrowseContainer x0, String x1) {
        x0.wsName_ = x1;
        return x0.wsName_;
    }

    static /* synthetic */ Log access$500() {
        return LOG;
    }
}

