/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContainer;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContentHelp;
import org.exoplatform.ecm.webui.component.browsecontent.UIConfigTabPane;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UIBrowseContentPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getLogger(UIBrowseContentPortlet.class);
    private boolean isViewModing_ = true;

    public UIBrowseContentPortlet() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String minWidth = portletPref.getValue(Utils.MIN_WIDTH, "");
        if (minWidth != null && minWidth.length() > 0) {
            this.setMinWidth(Integer.parseInt(minWidth));
        }
        this.addChild(UIBrowseContentHelp.class, null, null);
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPopupContainer popup = (UIPopupContainer)this.addChild(UIPopupContainer.class, null, null);
        popup.setId("UICBPopupAction");
        ((UIPopupWindow)popup.getChild(UIPopupWindow.class)).setId("UICBPopupWindow");
        this.addChild(UIPopupContainer.class, null, "UICBPopupComment");
        UIBrowseContainer uiBrowseContainer = (UIBrowseContainer)this.addChild(UIBrowseContainer.class, null, null);
        this.addChild(UIConfigTabPane.class, null, null);
        try {
            uiBrowseContainer.loadPortletConfig(this.getPortletPreferences());
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot initialize the UIBrowseContentPortlet", (Throwable)e);
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        context.getJavascriptManager().importJavascript("eXo.ecm.ECMUtils", "/ecm-wcm-extension/javascript/");
        context.getJavascriptManager().addJavascript((CharSequence)"eXo.ecm.ECMUtils.init('UIBrowseContentPortlet');");
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        PortletRequest portletRequest = portletReqContext.getRequest();
        String userAgent = portletRequest.getProperty("User-Agent");
        if (userAgent != null && userAgent.contains("MSIE 6.0")) {
            context.getJavascriptManager().importJavascript("eXo.ecm.Select_fix", "/ecm-wcm-extension/javascript/");
            context.getJavascriptManager().addJavascript((CharSequence)"SelectFix.autoRepairFloatingElements(100) ;");
        }
        UIConfigTabPane uiTabPane = (UIConfigTabPane)this.getChild(UIConfigTabPane.class);
        UIBrowseContainer uiContainer = (UIBrowseContainer)this.getChild(UIBrowseContainer.class);
        UIBrowseContentHelp uiBCHelp = (UIBrowseContentHelp)this.getChild(UIBrowseContentHelp.class);
        if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
            uiTabPane.setRendered(false);
            uiBCHelp.setRendered(false);
            uiContainer.setRendered(true);
            if (this.isViewModing_) {
                uiContainer.refreshContent();
            }
            this.isViewModing_ = true;
        } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT) {
            if (!SessionProviderFactory.isAnonim()) {
                if (!uiTabPane.isNewConfig()) {
                    uiTabPane.getCurrentConfig();
                }
                uiTabPane.setRendered(true);
                uiBCHelp.setRendered(false);
                uiContainer.setRendered(false);
                uiContainer.getListHistoryNode().clear();
                this.isViewModing_ = false;
            }
        } else if (portletReqContext.getApplicationMode() == PortletMode.HELP) {
            uiTabPane.setRendered(false);
            uiBCHelp.setRendered(true);
            uiContainer.setRendered(false);
            this.isViewModing_ = false;
        }
        try {
            super.processRender(app, context);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot display the content of the UIBrowseContentPortlet", (Throwable)e);
        }
    }

    protected void reload() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        WebuiApplication app = (WebuiApplication)context.getApplication();
        this.processRender(app, context);
    }

    protected void setPorletMode(PortletMode mode) throws PortletModeException {
        PortletRequestContext portletReqContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        portletReqContext.setApplicationMode(mode);
    }

    protected boolean isExitsRepo(String repoName) {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        try {
            rService.getRepository(repoName);
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)("The repository " + repoName + " cannot be found"), (Throwable)e);
            return false;
        }
    }

    public PortletPreferences getPortletPreferences() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest prequest = pcontext.getRequest();
        PortletPreferences portletPref = prequest.getPreferences();
        return portletPref;
    }

    public String getPreferenceRepository() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return portletPref.getValue(Utils.REPOSITORY, "");
    }
}

