/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterSubscriptionHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UISubscriptions;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/newsletter/NewsletterManager/UISubscriptions.gtmpl", events={@EventConfig(listeners={AddEntryActionListener.class}), @EventConfig(listeners={BackToCategoriesActionListener.class}), @EventConfig(listeners={AddSubcriptionActionListener.class}), @EventConfig(listeners={EditSubscriptionActionListener.class}), @EventConfig(listeners={DeleteSubscriptionActionListener.class}, confirm="UISubscription.msg.confirmDeleteSubscription"), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UISubscription.msg.confirmDeleteCategory"), @EventConfig(listeners={OpenSubscriptionActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={ManagerUsersActionListener.class}), @EventConfig(listeners={SelectSubscriptionActionListener.class}), @EventConfig(listeners={SelectSubscriptionCheckboxActionListener.class}), @EventConfig(listeners={SelectSubscriptionCheckboxHeaderActionListener.class})})
public class UISubscriptions
extends UIForm {
    NewsletterSubscriptionHandler subscriptionHandler;
    NewsletterCategoryHandler categoryHandler;
    NewsletterCategoryConfig categoryConfig;
    NewsletterManageUserHandler userHandler = null;
    String selectSubscriptionCheckboxHeader = "SelectSubscriptionCheckboxHeader";
    String selectSubscriptionCheckbox = "SelectSubscriptionCheckbox";
    String uiSubscriptionsCheckAll = "UISubscriptionsCheckAll";
    List<NewsletterSubscriptionConfig> listSubs = null;
    String portalName;
    String userId;

    public UISubscriptions() throws Exception {
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        this.subscriptionHandler = newsletterManagerService.getSubscriptionHandler();
        this.categoryHandler = newsletterManagerService.getCategoryHandler();
        this.userHandler = newsletterManagerService.getManageUserHandler();
        this.portalName = NewsLetterUtil.getPortalName();
        this.userId = NewsLetterUtil.getCurrentUser();
    }

    public void setCategory(NewsletterCategoryConfig categoryConfig) {
        this.categoryConfig = categoryConfig;
    }

    public void init() {
        this.getChildren().clear();
        this.updateListSubscription();
        UIFormCheckBoxInput checkboxHeader = new UIFormCheckBoxInput(this.uiSubscriptionsCheckAll, this.uiSubscriptionsCheckAll, (Object)false);
        checkboxHeader.setOnChange(this.selectSubscriptionCheckboxHeader);
        this.addChild((UIComponent)checkboxHeader);
        UIFormCheckBoxInput checkBoxInput = null;
        for (NewsletterSubscriptionConfig subscription : this.listSubs) {
            checkBoxInput = new UIFormCheckBoxInput(subscription.getName(), subscription.getName(), (Object)false);
            checkBoxInput.setOnChange(this.selectSubscriptionCheckbox);
            this.addChild((UIComponent)checkBoxInput);
        }
    }

    private int getNumberOfUser(String subscriptionName) {
        return this.userHandler.getQuantityUserBySubscription(Utils.getSessionProvider(), this.portalName, this.categoryConfig.getName(), subscriptionName);
    }

    public List<NewsletterSubscriptionConfig> getListSubscription() {
        return this.listSubs;
    }

    public void updateListSubscription() {
        this.listSubs = new ArrayList();
        try {
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            this.listSubs = this.userHandler.isAdministrator(this.portalName, this.userId) || this.userHandler.isModerator(this.userId, this.categoryConfig) ? this.subscriptionHandler.getSubscriptionsByCategory(sessionProvider, this.portalName, this.categoryConfig.getName()) : this.subscriptionHandler.getSubscriptionByRedactor(this.portalName, this.categoryConfig.getName(), this.userId, sessionProvider);
        }
        catch (Exception e) {
            Utils.createPopupMessage((UIContainer)this, (String)"UISubscription.msg.get-list-subscriptions", null, (int)0);
        }
    }

    private long getNumberOfWaitingNewsletter(String subscriptionName) {
        try {
            return this.subscriptionHandler.getNumberOfNewslettersWaiting(Utils.getSessionProvider(), this.portalName, this.categoryConfig.getName(), subscriptionName);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public String getChecked() {
        String subscriptionId = null;
        UIFormCheckBoxInput checkbox = null;
        for (UIComponent component : this.getChildren()) {
            try {
                checkbox = (UIFormCheckBoxInput)component;
                if (checkbox.getId().equals(this.uiSubscriptionsCheckAll) || !checkbox.isChecked()) continue;
                if (subscriptionId == null) {
                    subscriptionId = checkbox.getName();
                    continue;
                }
                return null;
            }
            catch (Exception e) {
            }
        }
        return subscriptionId;
    }

    private boolean isAdministrator() {
        return this.userHandler.isAdministrator(this.portalName, this.userId);
    }

    private boolean isModerator() {
        return this.userHandler.isModerator(this.userId, this.categoryConfig);
    }
}

