/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterPublicUserHandler {
    private static Log log = ExoLogger.getLogger(NewsletterPublicUserHandler.class);
    private RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
    private MailService mailService = (MailService)WCMCoreUtils.getService(MailService.class);
    private String repository;
    private String workspace;

    public NewsletterPublicUserHandler(String repository, String workspace) {
        this.repository = repository;
        this.workspace = workspace;
    }

    private List<String> convertValuesToArray(Value[] values) {
        ArrayList<String> listString = new ArrayList<String>();
        for (Value value : values) {
            try {
                listString.add(value.getString());
            }
            catch (Exception e) {
                log.error((Object)"Error when convert values to array: ", e.fillInStackTrace());
            }
        }
        return listString;
    }

    protected void updateSubscriptions(SessionProvider sessionProvider, List<String> listCategorySubscription, String portalName, String userMail) throws Exception {
        ArrayList<String> subscribedUsers = new ArrayList<String>();
        String categryHomePath = NewsletterConstant.generateCategoryPath(portalName);
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        for (String categoryAndSubscription : listCategorySubscription) {
            String categoryName = categoryAndSubscription.split("#")[0];
            String subscriptionName = categoryAndSubscription.split("#")[1];
            try {
                Node subscriptionNode = (Node)Node.class.cast(session.getItem(categryHomePath + "/" + categoryName + "/" + subscriptionName));
                if (subscriptionNode.hasProperty("exo:newsletterSubscribedUser")) {
                    subscribedUsers = new ArrayList();
                    Property subscribedUserProperty = subscriptionNode.getProperty("exo:newsletterSubscribedUser");
                    subscribedUsers.addAll(this.convertValuesToArray(subscribedUserProperty.getValues()));
                    subscribedUsers.add(userMail);
                    subscribedUserProperty.setValue(subscribedUsers.toArray(new String[0]));
                    continue;
                }
                subscriptionNode.setProperty("exo:newsletterSubscribedUser", new String[]{userMail});
            }
            catch (Exception ex) {
                log.error((Object)"updateSubscriptions() failed because of ", ex.fillInStackTrace());
            }
        }
        session.save();
    }

    protected void clearEmailInSubscription(SessionProvider sessionProvider, String email) {
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlQuery = "select * from exo:newsletterSubscription where exo:newsletterSubscribedUser like '%" + email + "%'";
            Query query = queryManager.createQuery(sqlQuery, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            while (nodeIterator.hasNext()) {
                Node subscriptionNode = nodeIterator.nextNode();
                Property subscribedUserProperty = subscriptionNode.getProperty("exo:newsletterSubscribedUser");
                List<Value> oldSubscribedUsers = Arrays.asList(subscribedUserProperty.getValues());
                ArrayList<Value> newSubscribedUsers = new ArrayList<Value>();
                for (Value value : oldSubscribedUsers) {
                    String subscribedUserMail = value.getString();
                    if (email.equals(subscribedUserMail)) continue;
                    newSubscribedUsers.add(value);
                }
                subscribedUserProperty.setValue(newSubscribedUsers.toArray(new Value[newSubscribedUsers.size()]));
            }
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Update user's subscription for user " + email + " failed because of "), e.fillInStackTrace());
        }
    }

    public void subscribe(SessionProvider sessionProvider, String portalName, String userMail, List<String> listCategorySubscription, String link, String[] emailContent) throws Exception {
        log.info((Object)("Trying to subscribe user " + userMail));
        try {
            NewsletterManagerService newsletterManagerService = (NewsletterManagerService)WCMCoreUtils.getService(NewsletterManagerService.class);
            NewsletterManageUserHandler manageUserHandler = newsletterManagerService.getManageUserHandler();
            Node userNode = manageUserHandler.add(sessionProvider, portalName, userMail);
            this.updateSubscriptions(sessionProvider, listCategorySubscription, portalName, userMail);
            String openTag = "<a href=\"" + link.replaceFirst("OBJECTID", userMail + "/" + userNode.getProperty("exo:newsletterUserValidationCode").getString()) + "\">";
            String mailContent = emailContent[1].replaceFirst("#", openTag).replace("#", "</a>");
            Message message = new Message();
            message.setMimeType("text/html");
            message.setTo(userMail);
            message.setSubject(emailContent[0]);
            message.setBody(mailContent);
            try {
                this.mailService.sendMessage(message);
            }
            catch (Exception e) {
                this.mailService.sendMessage(message);
            }
        }
        catch (Exception e) {
            log.error((Object)("Subscribe user " + userMail + " failed because of "), e.fillInStackTrace());
            throw e;
        }
    }

    public boolean confirmPublicUser(SessionProvider sessionProvider, String Email, String userCode, String portalName) throws Exception {
        String sqlQuery;
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(sqlQuery = "select * from exo:newsletterUser where exo:newsletterUserValidationCode = '" + userCode + "' and " + "exo:newsletterUserMail" + " = '" + Email + "'", "sql");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        if (nodeIterator.hasNext()) {
            nodeIterator.nextNode().setProperty("exo:newsletterUserConfirm", true);
            session.save();
            return true;
        }
        return false;
    }

    public void forgetEmail(SessionProvider sessionProvider, String portalName, String email) {
        log.info((Object)("Trying to update user's subscriptions for user " + email));
        try {
            this.clearEmailInSubscription(sessionProvider, email);
            NewsletterManagerService newsletterManagerService = (NewsletterManagerService)WCMCoreUtils.getService(NewsletterManagerService.class);
            NewsletterManageUserHandler manageUserHandler = newsletterManagerService.getManageUserHandler();
            manageUserHandler.delete(sessionProvider, portalName, email);
        }
        catch (Exception e) {
            log.error((Object)("Update user's subscription for user " + email + " failed because of "), e.fillInStackTrace());
        }
    }

    public void updateSubscriptions(SessionProvider sessionProvider, String portalName, String email, List<String> categoryAndSubscriptions) {
        log.info((Object)("Trying to update user's subscriptions for user " + email));
        try {
            this.clearEmailInSubscription(sessionProvider, email);
            this.updateSubscriptions(sessionProvider, categoryAndSubscriptions, portalName, email);
        }
        catch (Exception e) {
            log.error((Object)("Update user's subscription for user " + email + " failed because of "), e.fillInStackTrace());
        }
    }
}

