/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contentvalidation.webui;

import java.security.AccessControlException;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.workflow.webui.component.controller.UITask;
import org.exoplatform.workflow.webui.component.controller.UITaskManager;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})
public class UIDocumentForm
extends UIDialogForm {
    private String documentType_;
    private static final Log LOG = ExoLogger.getLogger(UIDocumentForm.class);

    public UIDocumentForm() throws Exception {
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }

    public void setTemplateNode(String type) {
        this.documentType_ = type;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setWorkspace(String workspace) {
        this.workspaceName = workspace;
    }

    private String getRepository() throws Exception {
        ManageableRepository manaRepo = (ManageableRepository)this.getCurrentNode().getSession().getRepository();
        return manaRepo.getConfiguration().getName();
    }

    public String getTemplate() {
        String userName = Util.getPortalRequestContext().getRemoteUser();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        try {
            return templateService.getTemplatePathByUser(true, this.documentType_, userName, this.getRepository());
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            String workspaceName = this.getCurrentNode().getSession().getWorkspace().getName();
            return new JCRResourceResolver(this.getRepository(), workspaceName, "exo:templateFile");
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return super.getTemplateResourceResolver(context, template);
        }
    }

    public Node getCurrentNode() throws Exception {
        return this.getNode();
    }

    public boolean isEditing() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIDocumentForm)((Object)event.getSource())).getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIDocumentForm)((Object)event.getSource())).getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UITaskManager uiTaskManager = (UITaskManager)((UIDocumentForm)((Object)event.getSource())).getParent();
            uiTaskManager.setRenderedChild(UITask.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaskManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIDocumentForm uiForm = (UIDocumentForm)((Object)event.getSource());
            List inputs = uiForm.getChildren();
            Map inputProperties = DialogFormUtil.prepareMap((List)inputs, (Map)uiForm.getInputProperties());
            Node homeNode = uiForm.getNode().getParent();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            try {
                String repository = uiForm.getRepository();
                CmsService cmsService = (CmsService)uiForm.getApplicationComponent(CmsService.class);
                cmsService.storeNode(uiForm.documentType_, homeNode, inputProperties, false, repository);
                homeNode.getSession().save();
                homeNode.save();
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            }
            catch (AccessControlException ace) {
                LOG.error((Object)"Unexpected error", (Throwable)ace);
                throw new AccessDeniedException(ace.getMessage());
            }
            catch (VersionException ve) {
                LOG.error((Object)"Unexpected error", (Throwable)ve);
                uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.in-versioning", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (ConstraintViolationException constraintViolationException) {
                LOG.error((Object)"Unexpected error occurrs", (Throwable)constraintViolationException);
                uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.constraintviolation-exception", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                String key = "UIDocumentForm.msg.cannot-save";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
        }
    }
}

