/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contentvalidation.webui;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.workflow.webui.component.controller.UITask;
import org.exoplatform.workflow.webui.component.controller.UITaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})
public class UIDocumentForm
extends UIDialogForm
implements UIPopupComponent,
UISelectable {
    public static final String FIELD_TAXONOMY = "categories";
    public static final String POPUP_TAXONOMY = "PopupComponent";
    public static final String PATH_TAXONOMY = "exoTaxonomiesPath";
    private List<String> listTaxonomyName = new ArrayList<String>();
    private String documentType_;
    private static final Log LOG = ExoLogger.getLogger(UIDocumentForm.class);

    public UIDocumentForm() throws Exception {
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public List<String> getlistTaxonomyName() {
        return this.listTaxonomyName;
    }

    public void setListTaxonomyName(List<String> listTaxonomyNameNew) {
        this.listTaxonomyName = listTaxonomyNameNew;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }

    public void setTemplateNode(String type) {
        this.documentType_ = type;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setWorkspace(String workspace) {
        this.workspaceName = workspace;
    }

    private String getRepository() throws Exception {
        ManageableRepository manaRepo = (ManageableRepository)this.getCurrentNode().getSession().getRepository();
        return manaRepo.getConfiguration().getName();
    }

    public String getTemplate() {
        String userName = Util.getPortalRequestContext().getRemoteUser();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        try {
            return templateService.getTemplatePathByUser(true, this.documentType_, userName, this.getRepository());
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
            String wsName = dmsConfiguration.getConfig(this.getRepository()).getSystemWorkspace();
            return new JCRResourceResolver(this.getRepository(), wsName, "exo:templateFile");
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return super.getTemplateResourceResolver(context, template);
        }
    }

    public Node getCurrentNode() throws Exception {
        return this.getNode();
    }

    public boolean isEditing() {
        return true;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Node getRootPathTaxonomy(Node node) throws Exception {
        try {
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            List allTaxonomyTrees = taxonomyService.getAllTaxonomyTrees(this.repositoryName);
            for (Node taxonomyTree : allTaxonomyTrees) {
                if (!node.getPath().startsWith(taxonomyTree.getPath())) continue;
                return taxonomyTree;
            }
            return null;
        }
        catch (AccessDeniedException accessDeniedException) {
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.contentType};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public void renderField(String name) throws Exception {
        if (name.equals(FIELD_TAXONOMY)) {
            UIComponent uiInput = this.findComponentById(name);
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            List listCategories = taxonomyService.getAllCategories(this.getCurrentNode());
            for (Node itemNode : listCategories) {
                Node taxonomyTree = this.getRootPathTaxonomy(itemNode);
                if (taxonomyTree == null) continue;
                String categoryPath = itemNode.getPath().replaceAll(taxonomyTree.getPath(), "");
                if (this.getListTaxonomy().contains(taxonomyTree.getName() + categoryPath)) continue;
                this.listTaxonomyName.add(this.getCategoryLabel(taxonomyTree.getName() + categoryPath));
                this.getListTaxonomy().add(taxonomyTree.getName() + categoryPath);
            }
            ((UIFormMultiValueInputSet)uiInput).setValue(this.listTaxonomyName);
        }
        super.renderField(name);
    }

    public void initFieldInput() throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        List listCategories = taxonomyService.getAllCategories(this.getCurrentNode());
        for (Node itemNode : listCategories) {
            Node taxonomyTree = this.getRootPathTaxonomy(itemNode);
            if (taxonomyTree == null) continue;
            String categoryPath = itemNode.getPath().replaceAll(taxonomyTree.getPath(), "");
            if (this.getListTaxonomy().contains(taxonomyTree.getName() + categoryPath)) continue;
            this.listTaxonomyName.add(this.getCategoryLabel(taxonomyTree.getName() + categoryPath));
            this.getListTaxonomy().add(taxonomyTree.getName() + categoryPath);
        }
        UIFormMultiValueInputSet uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        uiFormMultiValue.setId(FIELD_TAXONOMY);
        uiFormMultiValue.setName(FIELD_TAXONOMY);
        uiFormMultiValue.setType(UIFormStringInput.class);
        uiFormMultiValue.setValue(this.listTaxonomyName);
        uiFormMultiValue.setEditable(false);
        this.addUIFormInput((UIFormInput)uiFormMultiValue);
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.isUpdateSelect = true;
        UIFormInput formInput = this.getUIInput(selectField);
        if (formInput instanceof UIFormInputBase) {
            ((UIFormInputBase)formInput).setValue((Object)value.toString());
        } else if (formInput instanceof UIFormMultiValueInputSet) {
            UIFormMultiValueInputSet inputSet = (UIFormMultiValueInputSet)formInput;
            String valueTaxonomy = String.valueOf(value).trim();
            List values = inputSet.getValue();
            if (!this.getListTaxonomy().contains(valueTaxonomy)) {
                this.getListTaxonomy().add(valueTaxonomy);
                values.add(this.getCategoryLabel(valueTaxonomy));
            }
            this.listTaxonomyName = values;
            inputSet.setValue(values);
        }
        UITaskManager uiContainer = (UITaskManager)this.getParent();
        uiContainer.removeChildById(POPUP_TAXONOMY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIDocumentForm uiDocumentForm = (UIDocumentForm)((Object)event.getSource());
            String objectid = event.getRequestContext().getRequestParameter("objectId");
            String idx = objectid.replaceAll(UIDocumentForm.FIELD_TAXONOMY, "");
            try {
                int idxInput = Integer.parseInt(idx);
                uiDocumentForm.listTaxonomyName.remove(idxInput);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIDocumentForm uiDocumentForm = (UIDocumentForm)((Object)event.getSource());
            UITaskManager uiTaskManager = (UITaskManager)uiDocumentForm.getParent();
            String clickedField = event.getRequestContext().getRequestParameter("objectId");
            if (uiDocumentForm.isReference) {
                UIApplication uiApp = (UIApplication)uiDocumentForm.getAncestorOfType(UIApplication.class);
                try {
                    UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)uiDocumentForm.getChildById(UIDocumentForm.FIELD_TAXONOMY);
                    if (uiSet != null && uiSet.getName() != null && uiSet.getName().equals(UIDocumentForm.FIELD_TAXONOMY) && clickedField != null && clickedField.equals(UIDocumentForm.FIELD_TAXONOMY)) {
                        String repository = uiDocumentForm.getRepository();
                        DMSConfiguration dmsConfig = (DMSConfiguration)uiDocumentForm.getApplicationComponent(DMSConfiguration.class);
                        DMSRepositoryConfiguration dmsRepoConfig = dmsConfig.getConfig(repository);
                        String workspaceName = dmsRepoConfig.getSystemWorkspace();
                        if (uiSet.getValue().size() == 0) {
                            uiSet.setValue(new ArrayList());
                        }
                        UIOneTaxonomySelector uiOneTaxonomySelector = (UIOneTaxonomySelector)uiTaskManager.createUIComponent(UIOneTaxonomySelector.class, null, null);
                        uiOneTaxonomySelector.setIsDisable(workspaceName, false);
                        TaxonomyService taxonomyService = (TaxonomyService)uiDocumentForm.getApplicationComponent(TaxonomyService.class);
                        List lstTaxonomyTree = taxonomyService.getAllTaxonomyTrees(repository);
                        if (lstTaxonomyTree.size() == 0) {
                            throw new AccessDeniedException();
                        }
                        uiOneTaxonomySelector.setRootNodeLocation(repository, workspaceName, ((Node)lstTaxonomyTree.get(0)).getPath());
                        uiOneTaxonomySelector.setExceptedNodeTypesInPathPanel(new String[]{"exo:symlink"});
                        uiOneTaxonomySelector.init(SessionProviderFactory.createSystemProvider());
                        String param = "returnField=categories";
                        uiOneTaxonomySelector.setSourceComponent((UIComponent)uiDocumentForm, new String[]{param});
                        UIPopupWindow uiPopupWindow = (UIPopupWindow)uiTaskManager.getChildById(UIDocumentForm.POPUP_TAXONOMY);
                        if (uiPopupWindow == null) {
                            uiPopupWindow = (UIPopupWindow)uiTaskManager.addChild(UIPopupWindow.class, null, UIDocumentForm.POPUP_TAXONOMY);
                        }
                        uiPopupWindow.setWindowSize(700, 450);
                        uiPopupWindow.setUIComponent((UIComponent)uiOneTaxonomySelector);
                        uiPopupWindow.setRendered(true);
                        uiPopupWindow.setShow(true);
                    }
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaskManager);
                }
                catch (AccessDeniedException accessDeniedException) {
                    uiApp.addMessage(new ApplicationMessage("Taxonomy.msg.AccessDeniedException", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                catch (Exception e) {
                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiDocumentForm.getParent());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UITaskManager uiTaskManager = (UITaskManager)((UIDocumentForm)((Object)event.getSource())).getParent();
            uiTaskManager.setRenderedChild(UITask.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaskManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIFormMultiValueInputSet uiSet;
            UIDocumentForm uiForm = (UIDocumentForm)((Object)event.getSource());
            List inputs = uiForm.getChildren();
            String repository = uiForm.getRepository();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            int index = 0;
            boolean hasCategories = false;
            String categoriesPath = "";
            TaxonomyService taxonomyService = (TaxonomyService)uiForm.getApplicationComponent(TaxonomyService.class);
            List listTaxonomy = uiForm.getListTaxonomy();
            if (uiForm.isReference && (uiSet = (UIFormMultiValueInputSet)uiForm.getChild(UIFormMultiValueInputSet.class)) != null && uiSet.getName() != null && uiSet.getName().equals(UIDocumentForm.FIELD_TAXONOMY)) {
                hasCategories = true;
                for (String category : listTaxonomy) {
                    categoriesPath.concat(category).concat(",");
                }
                if (listTaxonomy != null && listTaxonomy.size() > 0) {
                    try {
                        for (String categoryPath : listTaxonomy) {
                            index = categoryPath.indexOf("/");
                            if (index < 0) {
                                taxonomyService.getTaxonomyTree(repository, categoryPath);
                                continue;
                            }
                            taxonomyService.getTaxonomyTree(repository, categoryPath.substring(0, index)).getNode(categoryPath.substring(index + 1));
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Unexpected error occurs", (Throwable)e);
                        uiApp.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.non-categories", null, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                }
            }
            Map inputProperties = DialogFormUtil.prepareMap((List)inputs, (Map)uiForm.getInputProperties());
            Node homeNode = uiForm.getNode().getParent();
            try {
                CmsService cmsService = (CmsService)uiForm.getApplicationComponent(CmsService.class);
                String addedPath = cmsService.storeNode(uiForm.documentType_, homeNode, inputProperties, false, repository);
                homeNode.getSession().save();
                homeNode.save();
                Node newNode = (Node)homeNode.getSession().getItem(addedPath);
                if (hasCategories) {
                    List listTaxonomyTrees = taxonomyService.getAllTaxonomyTrees(repository);
                    List listExistedTaxonomy = taxonomyService.getAllCategories(newNode);
                    block12: for (Node existedTaxonomy : listExistedTaxonomy) {
                        for (Node taxonomyTrees : listTaxonomyTrees) {
                            if (!existedTaxonomy.getPath().contains(taxonomyTrees.getPath())) continue;
                            taxonomyService.removeCategory(newNode, taxonomyTrees.getName(), existedTaxonomy.getPath().substring(taxonomyTrees.getPath().length()));
                            continue block12;
                        }
                    }
                }
                if (hasCategories && newNode != null && listTaxonomy != null && listTaxonomy.size() > 0) {
                    for (String categoryPath : listTaxonomy) {
                        index = categoryPath.indexOf("/");
                        try {
                            if (index != -1) {
                                taxonomyService.addCategory(newNode, categoryPath.substring(0, index), categoryPath.substring(index + 1));
                                continue;
                            }
                            taxonomyService.addCategory(newNode, categoryPath, "");
                        }
                        catch (AccessDeniedException accessDeniedException) {
                            uiApp.addMessage(new ApplicationMessage("AccessControlException.msg", null, 1));
                            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        }
                        catch (Exception e) {}
                    }
                } else {
                    ArrayList vals = new ArrayList();
                    if (newNode.hasProperty("exo:category")) {
                        newNode.setProperty("exo:category", vals.toArray(new Value[vals.size()]));
                    }
                    newNode.save();
                }
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            }
            catch (AccessControlException ace) {
                LOG.error((Object)"Unexpected error", (Throwable)ace);
                throw new AccessDeniedException(ace.getMessage());
            }
            catch (VersionException ve) {
                LOG.error((Object)"Unexpected error", (Throwable)ve);
                uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.in-versioning", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (ConstraintViolationException constraintViolationException) {
                LOG.error((Object)"Unexpected error occurrs", (Throwable)constraintViolationException);
                uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.constraintviolation-exception", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                String key = "UIDocumentForm.msg.cannot-save";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
        }
    }
}

