/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.publishing;

import java.util.Date;
import org.exoplatform.processes.publishing.BackupContentActionHandler;
import org.exoplatform.processes.publishing.ProcessUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.workflow.impl.jbpm.WorkflowServiceContainerImpl;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.instantiation.Delegation;
import org.jbpm.job.Timer;

public class ScheduleBackupTimerActionHandler
extends BackupContentActionHandler {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = ExoLogger.getLogger((String)ScheduleBackupTimerActionHandler.class.getName());

    public void execute(ExecutionContext context) {
        block6: {
            try {
                Date currentDate = new Date();
                Date endDate = null;
                if (context.getVariable("endDate") instanceof Date) {
                    endDate = (Date)context.getVariable("endDate");
                }
                if (endDate != null) {
                    if (endDate.after(currentDate)) {
                        Delegation delegation = new Delegation();
                        delegation.setClassName("org.exoplatform.processes.publishing.BackupContentActionHandler");
                        delegation.setProcessDefinition(context.getProcessDefinition());
                        Action backupAction = new Action();
                        backupAction.setName("backupAction");
                        backupAction.setActionDelegation(delegation);
                        backupAction.setProcessDefinition(context.getProcessDefinition());
                        context.getProcessDefinition().addAction(backupAction);
                        Timer jobTimer = new Timer(context.getToken());
                        jobTimer.setName("backupTimer");
                        jobTimer.setDueDate(endDate);
                        jobTimer.setGraphElement(context.getEventSource());
                        jobTimer.setTaskInstance(context.getTaskInstance());
                        jobTimer.setAction(backupAction);
                        jobTimer.setTransitionName("end");
                        ProcessUtil.createTimer((ExecutionContext)context, (Timer)jobTimer);
                        WorkflowServiceContainerImpl containerImpl = (WorkflowServiceContainerImpl)ProcessUtil.getService((ExecutionContext)context, WorkflowServiceContainerImpl.class);
                        JbpmContext jbpmContext = containerImpl.openJbpmContext();
                        jbpmContext.save(context.getProcessInstance());
                    } else {
                        this.backupContent(context);
                        context.getProcessInstance().getRootToken().signal("backup-done");
                    }
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)"Unexpected error", (Throwable)ex);
            }
        }
    }
}

