/*
 * Decompiled with CFR 0.152.
 */
package hero.mapper;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.ow2.bonita.definition.RoleMapper;
import org.ow2.bonita.facade.QueryAPIAccessor;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.def.majorElement.ParticipantDefinition;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.ParticipantNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoOrganizationMapper
implements RoleMapper {
    private static Log log = ExoLogger.getLogger((String)ExoOrganizationMapper.class.getName());

    public Set<String> searchMembers(QueryAPIAccessor readonlyapiaccessor, ProcessInstanceUUID instanceId, String roleId) {
        try {
            QueryRuntimeAPI queryAPI = readonlyapiaccessor.getQueryRuntimeAPI();
            ProcessDefinitionUUID processId = queryAPI.getProcessInstance(instanceId).getProcessDefinitionUUID();
            QueryDefinitionAPI definitionAPI = readonlyapiaccessor.getQueryDefinitionAPI();
            ParticipantDefinition participantDef = definitionAPI.getProcessParticipant(processId, roleId);
            return ExoOrganizationMapper.GetUsersFromMembershipAndGroup(participantDef.getName());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (ProcessNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParticipantNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Set<String> GetUsersFromMembershipAndGroup(String membershipAndGroup) {
        HashSet<String> users = new HashSet<String>();
        try {
            PortalContainer container = PortalContainer.getInstance();
            OrganizationService organization = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            String[] tokens = membershipAndGroup.split(":");
            String membership = null;
            String group = null;
            if (tokens.length == 2) {
                membership = tokens[0];
                group = tokens[1];
            } else {
                membership = "*";
                group = membershipAndGroup;
                log.error((Object)"Warning : The specified Bonita role does not conform to the syntax membership:group.");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Starting role mapping for [group,membership] : [" + group + "," + membership + "]"));
            }
            UserHandler userHandler = organization.getUserHandler();
            PageList pageList = userHandler.findUsersByGroup(group);
            List usersInGroup = pageList.getAll();
            for (User user : usersInGroup) {
                String userName = user.getUserName();
                if (!"*".equals(membership) && organization.getMembershipHandler().findMembershipByUserGroupAndType(userName, group, membership) == null) continue;
                users.add(userName);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Add user : " + userName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return users;
    }
}

