/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.workflow.FileDefinition;
import org.exoplatform.services.workflow.WorkflowFileDefinitionService;
import org.exoplatform.services.workflow.impl.bonita.BARFileDefinition;
import org.exoplatform.services.workflow.impl.bonita.WorkflowServiceContainerHelper;

public class JCRFileDefinitionServiceImpl
implements WorkflowFileDefinitionService {
    private static final String EXO_PORTALNAME = "ecm";
    private static final String NODE_TYPE = "exo:businessProcessModel";
    private static final String BPID_PROPERTY = "exo:businessProcessId";
    public static final String ECM_BUSINESS_PROCESSES_PATH = "businessProcessesPath";
    private String bpNodePath;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private Hashtable<String, FileDefinition> fileDefinitions = new Hashtable();

    private void addFilesToModelNode(Node modelNode, String filePath, byte[] value) throws Exception {
        if (!filePath.endsWith("class") && !filePath.startsWith("META")) {
            String fileName = null;
            String path = null;
            Node fileNode = null;
            if (filePath.contains("/")) {
                fileName = new File(filePath).getName();
                path = filePath.substring(0, filePath.length() - fileName.length());
                if (!modelNode.hasNode(path)) {
                    Node pathNode = JCRFileDefinitionServiceImpl.makePath(modelNode, path, "nt:unstructured");
                    fileNode = pathNode.addNode(fileName, "nt:file");
                } else {
                    fileNode = modelNode.getNode(path).addNode(fileName, "nt:file");
                }
            } else {
                fileName = filePath;
                fileNode = modelNode.addNode(fileName, "nt:file");
            }
            Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
            String mimeType = new MimeTypeResolver().getMimeType(fileName);
            contentNode.setProperty("jcr:mimeType", mimeType);
            if (mimeType.startsWith("text")) {
                contentNode.setProperty("jcr:encoding", "UTF-8");
            }
            contentNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
            contentNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(value));
        }
    }

    private Node getNodeByProcessId(String processId, Session session) throws RepositoryException {
        Node bpNode = session.getRootNode().getNode(this.bpNodePath.startsWith("/") ? this.bpNodePath.substring(1) : this.bpNodePath);
        try {
            String processName = WorkflowServiceContainerHelper.getProcessName(processId);
            if (bpNode.hasNode(processName)) {
                return bpNode.getNode(processName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        QueryManager qm = session.getWorkspace().getQueryManager();
        Query q = qm.createQuery("select * from exo:businessProcessModel where jcr:path like '" + this.bpNodePath + "/%' and " + BPID_PROPERTY + " = '" + processId + "'", "sql");
        QueryResult result = q.execute();
        NodeIterator it = result.getNodes();
        if (it.hasNext()) {
            return it.nextNode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession() {
        boolean checkpoint = false;
        try {
            PortalContainer container = PortalContainer.getInstance();
            if (container == null) {
                container = RootContainer.getInstance().getPortalContainer(EXO_PORTALNAME);
                PortalContainer.setInstance((PortalContainer)container);
                checkpoint = true;
            }
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            String wsName = repositoryService.getDefaultRepository().getConfiguration().getSystemWorkspaceName();
            Session session = repositoryService.getDefaultRepository().getSystemSession(wsName);
            return session;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (checkpoint) {
                PortalContainer.setInstance(null);
                checkpoint = false;
            }
        }
        return null;
    }

    public static Node makePath(Node rootNode, String path, String nodetype) throws PathNotFoundException, RepositoryException {
        return JCRFileDefinitionServiceImpl.makePath(rootNode, path, nodetype, null);
    }

    public static Node makePath(Node rootNode, String path, String nodetype, Map permissions) throws PathNotFoundException, RepositoryException {
        String[] tokens = path.split("/");
        Node node = rootNode;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (node.hasNode(token)) {
                node = node.getNode(token);
                continue;
            }
            if ((node = node.addNode(token, nodetype)).canAddMixin("exo:privilegeable")) {
                node.addMixin("exo:privilegeable");
            }
            if (permissions == null) continue;
            ((ExtendedNode)node).setPermissions(permissions);
        }
        return node;
    }

    public JCRFileDefinitionServiceImpl(NodeHierarchyCreator nodeHierarchyCreator) {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.bpNodePath = this.nodeHierarchyCreator_.getJcrPath(ECM_BUSINESS_PROCESSES_PATH);
    }

    public void remove(String processId) {
        this.removeFromCache(processId);
        try {
            Session session = this.getSession();
            Node node = this.getNodeByProcessId(processId, session);
            if (node != null) {
                node.remove();
            }
            session.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeFromCache(String processId) {
        if (this.fileDefinitions.containsKey(processId)) {
            this.fileDefinitions.remove(processId);
        }
    }

    public FileDefinition retrieve(String processId) {
        if (this.fileDefinitions.containsKey(processId)) {
            return this.fileDefinitions.get(processId);
        }
        try {
            Session session = this.getSession();
            Node modelNode = this.getNodeByProcessId(processId, session);
            if (modelNode == null) {
                return null;
            }
            BARFileDefinition fd = new BARFileDefinition(modelNode);
            this.fileDefinitions.put(processId, fd);
            return fd;
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void store(FileDefinition fileDefinition, String processId) {
        try {
            this.fileDefinitions.put(processId, fileDefinition);
            Hashtable entries = fileDefinition.getEntries();
            Session session = this.getSession();
            Node bpNode = session.getRootNode().getNode(this.bpNodePath.startsWith("/") ? this.bpNodePath.substring(1) : this.bpNodePath);
            if (bpNode.hasNode(fileDefinition.getProcessModelName())) {
                Node n = bpNode.getNode(fileDefinition.getProcessModelName());
                n.remove();
            }
            Node modelNode = bpNode.addNode(fileDefinition.getProcessModelName(), NODE_TYPE);
            modelNode.setProperty(BPID_PROPERTY, processId);
            Enumeration e = entries.keys();
            while (e.hasMoreElements()) {
                Object element = e.nextElement();
                byte[] entry = (byte[])entries.get(element);
                entries.get(element);
                String filename = element.toString();
                this.addFilesToModelNode(modelNode, filename, entry);
            }
            session.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

