/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.jaas.BasicCallbackHandler;
import org.exoplatform.services.workflow.FileDefinition;
import org.exoplatform.services.workflow.Form;
import org.exoplatform.services.workflow.PredefinedProcessesPlugin;
import org.exoplatform.services.workflow.Process;
import org.exoplatform.services.workflow.ProcessInstance;
import org.exoplatform.services.workflow.ProcessesConfig;
import org.exoplatform.services.workflow.Task;
import org.exoplatform.services.workflow.Timer;
import org.exoplatform.services.workflow.WorkflowFileDefinitionService;
import org.exoplatform.services.workflow.WorkflowFormsService;
import org.exoplatform.services.workflow.WorkflowServiceContainer;
import org.exoplatform.services.workflow.impl.bonita.BARFileDefinition;
import org.exoplatform.services.workflow.impl.bonita.ProcessComparator;
import org.exoplatform.services.workflow.impl.bonita.ProcessData;
import org.exoplatform.services.workflow.impl.bonita.ProcessInstanceComparator;
import org.exoplatform.services.workflow.impl.bonita.ProcessInstanceData;
import org.exoplatform.services.workflow.impl.bonita.TaskComparator;
import org.exoplatform.services.workflow.impl.bonita.TaskData;
import org.exoplatform.services.workflow.impl.bonita.XPDLFileDefinition;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.def.dataType.BasicTypeDefinition;
import org.ow2.bonita.facade.def.dataType.DataTypeValue;
import org.ow2.bonita.facade.def.dataType.EnumerationTypeDefinition;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.DataFieldNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.VariableNotFoundException;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.var.Enumeration;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.facade.uuid.TaskUUID;
import org.ow2.bonita.facade.uuid.UUIDFactory;
import org.ow2.bonita.identity.auth.BonitaPrincipal;
import org.ow2.bonita.util.AccessorUtil;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.Misc;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowServiceContainerImpl
implements WorkflowServiceContainer,
Startable {
    public static ThreadLocal<Map<String, Object>> InitialVariables = new ThreadLocal();
    private ArrayList<ProcessesConfig> configurations;
    private ConfigurationManager configurationManager = null;
    private WorkflowFileDefinitionService fileDefinitionService = null;
    private WorkflowFormsService formsService = null;
    private OrganizationService organizationService = null;
    private String superUser_ = "root";
    private String superPass_ = null;
    private String jaasLoginContext_ = "gatein-domain";
    private static final Log LOG = ExoLogger.getLogger((String)WorkflowServiceContainerImpl.class.getName());

    public WorkflowServiceContainerImpl(WorkflowFileDefinitionService fileDefinitionService, WorkflowFormsService formsService, OrganizationService organizationService, ConfigurationManager configurationManager, InitParams params) {
        this.fileDefinitionService = fileDefinitionService;
        this.formsService = formsService;
        this.organizationService = organizationService;
        this.configurationManager = configurationManager;
        this.configurations = new ArrayList();
        if (params != null) {
            ValueParam superPassParam;
            ValueParam jaasLoginContextParam;
            ValueParam superUserParam = params.getValueParam("super.user");
            if (superUserParam != null && superUserParam.getValue().length() > 0) {
                this.superUser_ = superUserParam.getValue();
            }
            if ((jaasLoginContextParam = params.getValueParam("jaas.login.context")) != null && jaasLoginContextParam.getValue().length() > 0) {
                this.jaasLoginContext_ = jaasLoginContextParam.getValue();
            }
            if ((superPassParam = params.getValueParam("super.pass")) != null && superPassParam.getValue().length() > 0) {
                this.superPass_ = superPassParam.getValue();
            }
        }
    }

    public void addPlugin(ComponentPlugin plugin) throws Exception {
        if (!(plugin instanceof PredefinedProcessesPlugin)) {
            throw new RuntimeException(plugin.getClass().getName() + " is an unknown plugin type.");
        }
        this.configurations.add(((PredefinedProcessesPlugin)plugin).getProcessesConfig());
    }

    public void deleteProcess(String processId) {
        block2: {
            this.commit();
            try {
                QueryDefinitionAPI dApi = AccessorUtil.getQueryAPIAccessor().getQueryDefinitionAPI();
                ProcessDefinition p = dApi.getProcess(UUIDFactory.getProcessDefinitionUUID(processId));
                ManagementAPI mAPI = AccessorUtil.getAPIAccessor().getManagementAPI();
                mAPI.deletePackage(p.getPackageDefinitionUUID());
                this.formsService.removeForms(processId);
                this.fileDefinitionService.remove(processId);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)("An unexpected problem occurs while deleting this process " + processId + " "));
            }
        }
    }

    public void deleteProcessInstance(String processInstanceId) {
        block2: {
            this.commit();
            try {
                RuntimeAPI rApi = AccessorUtil.getAPIAccessor().getRuntimeAPI();
                rApi.deleteProcessInstance(UUIDFactory.getProcessInstanceUUID(processInstanceId));
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e);
            }
        }
    }

    public void deployProcess(InputStream jarInputStream) throws IOException {
        this.commit();
        try {
            Collection processes;
            boolean xpdl = false;
            byte[] barFile = Misc.getAllContentFrom((InputStream)jarInputStream);
            ByteArrayInputStream in = new ByteArrayInputStream(barFile);
            ZipInputStream zis = null;
            zis = new ZipInputStream(in);
            try {
                zis.getNextEntry().getName();
                zis.close();
            }
            catch (Exception e1) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e1);
                }
                xpdl = true;
            }
            ((InputStream)in).close();
            ManagementAPI dAPI = AccessorUtil.getAPIAccessor().getManagementAPI();
            if (xpdl) {
                processes = dAPI.deployXpdl(barFile).values();
            } else {
                try {
                    processes = dAPI.deployBar(barFile).values();
                }
                catch (Exception e) {
                    Object processes2 = null;
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)e);
                    }
                    throw e;
                }
            }
            Iterator ite = processes.iterator();
            if (ite.hasNext()) {
                ProcessDefinition p = (ProcessDefinition)ite.next();
                String processId = p.getProcessDefinitionUUID().toString();
                BARFileDefinition fileDefinition = xpdl ? new XPDLFileDefinition(new ByteArrayInputStream(barFile)) : new BARFileDefinition(new ByteArrayInputStream(barFile));
                this.fileDefinitionService.store((FileDefinition)fileDefinition, processId);
            }
        }
        catch (Exception e) {
            IOException pde = new IOException();
            pde.initCause(e);
            throw pde;
        }
    }

    public void endTask(String taskId, Map variables) {
        block12: {
            this.commit();
            HashMap<String, Object> activityVariables = new HashMap<String, Object>();
            HashMap<String, Object> instanceVariables = new HashMap<String, Object>();
            try {
                Set keys;
                QueryRuntimeAPI qAPI = AccessorUtil.getQueryAPIAccessor().getQueryRuntimeAPI();
                RuntimeAPI rApi = AccessorUtil.getAPIAccessor().getRuntimeAPI();
                QueryDefinitionAPI dAPI = AccessorUtil.getQueryAPIAccessor().getQueryDefinitionAPI();
                ActivityInstance t = qAPI.getTask(UUIDFactory.getTaskUUID(taskId));
                if (variables != null) {
                    keys = variables.keySet();
                    for (String key : keys) {
                        try {
                            ActivityDefinition activity = dAPI.getProcessActivity(t.getProcessDefinitionUUID(), t.getActivityId());
                            DataFieldDefinition d = dAPI.getActivityDataField(activity.getUUID(), key);
                            DataTypeValue typeValue = d.getDataType().getValue();
                            Object v = this.getVariableValue(variables.get(key), typeValue);
                            if (v == null) continue;
                            activityVariables.put(key, v);
                        }
                        catch (DataFieldNotFoundException e) {
                            org.ow2.bonita.facade.runtime.ProcessInstance p = qAPI.getProcessInstance(t.getProcessInstanceUUID());
                            try {
                                DataFieldDefinition d = dAPI.getProcessDataField(p.getProcessDefinitionUUID(), key);
                                DataTypeValue typeValue = d.getDataType().getValue();
                                Object v = this.getVariableValue(variables.get(key), typeValue);
                                if (v == null) continue;
                                instanceVariables.put(key, v);
                            }
                            catch (DataFieldNotFoundException e1) {
                                if (!LOG.isWarnEnabled()) continue;
                                LOG.warn((Object)e1.getMessage());
                            }
                        }
                    }
                }
                rApi.startTask(UUIDFactory.getTaskUUID(taskId), true);
                if (activityVariables != null) {
                    keys = activityVariables.keySet();
                    for (String key : keys) {
                        rApi.setActivityInstanceVariable(t.getUUID(), key, activityVariables.get(key));
                    }
                }
                if (instanceVariables != null) {
                    keys = instanceVariables.keySet();
                    for (String key : keys) {
                        rApi.setProcessInstanceVariable(t.getProcessInstanceUUID(), key, instanceVariables.get(key));
                    }
                }
                rApi.finishTask(UUIDFactory.getTaskUUID(taskId), true);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block12;
                LOG.error((Object)e);
            }
        }
    }

    public void endTask(String taskId, Map variables, String transition) {
        this.endTask(taskId, variables);
    }

    public List<Task> getAllTasks(String user) throws Exception {
        ArrayList<Task> allTasks = new ArrayList<Task>();
        allTasks.addAll(this.getUserTaskList(user));
        allTasks.addAll(this.getGroupTaskList(user));
        return allTasks;
    }

    public WorkflowFileDefinitionService getFileDefinitionService() {
        return this.fileDefinitionService;
    }

    public List<Task> getGroupTaskList(String user) throws Exception {
        return new ArrayList<Task>();
    }

    public Process getProcess(String processId) {
        ProcessData p;
        block2: {
            p = null;
            this.commit();
            try {
                ProcessDefinitionUUID uuid = UUIDFactory.getProcessDefinitionUUID(processId);
                QueryDefinitionAPI dAPI = AccessorUtil.getQueryAPIAccessor().getQueryDefinitionAPI();
                ProcessDefinition pd = dAPI.getProcess(uuid);
                p = new ProcessData(pd);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e);
            }
        }
        return p;
    }

    public List<Process> getProcesses() {
        this.commit();
        QueryDefinitionAPI dAPI = AccessorUtil.getQueryAPIAccessor().getQueryDefinitionAPI();
        Set list = dAPI.getProcesses(ProcessDefinition.ProcessState.DEPLOYED);
        ArrayList<Process> rList = new ArrayList<Process>();
        for (ProcessDefinition pd : list) {
            rList.add(new ProcessData(pd));
        }
        Collections.sort(rList, new ProcessComparator());
        return rList;
    }

    public ProcessInstance getProcessInstance(String processInstanceId) {
        ProcessInstanceData p;
        block2: {
            p = null;
            this.commit();
            try {
                ProcessInstanceUUID uuid = UUIDFactory.getProcessInstanceUUID(processInstanceId);
                QueryRuntimeAPI rApi = AccessorUtil.getQueryAPIAccessor().getQueryRuntimeAPI();
                org.ow2.bonita.facade.runtime.ProcessInstance instance = rApi.getProcessInstance(uuid);
                p = new ProcessInstanceData(instance);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e);
            }
        }
        return p;
    }

    public List<ProcessInstance> getProcessInstances(String processId) {
        ArrayList<ProcessInstance> list;
        block3: {
            list = new ArrayList<ProcessInstance>();
            this.commit();
            try {
                ProcessDefinitionUUID uuid = UUIDFactory.getProcessDefinitionUUID(processId);
                QueryRuntimeAPI rApi = AccessorUtil.getQueryAPIAccessor().getQueryRuntimeAPI();
                Set pis = rApi.getProcessInstances(uuid);
                for (org.ow2.bonita.facade.runtime.ProcessInstance i : pis) {
                    list.add(new ProcessInstanceData(i));
                }
                Collections.sort(list, new ProcessInstanceComparator());
            }
            catch (BonitaException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e);
            }
        }
        return list;
    }

    public Task getTask(String taskId) {
        TaskData task;
        block3: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("get the task [taskId=" + taskId + "]"));
            }
            task = null;
            this.commit();
            try {
                TaskUUID uuid = UUIDFactory.getTaskUUID(taskId);
                QueryRuntimeAPI rApi = AccessorUtil.getQueryAPIAccessor().getQueryRuntimeAPI();
                ActivityInstance taskInstance = rApi.getTask(uuid);
                task = new TaskData((ActivityInstance<TaskInstance>)taskInstance);
            }
            catch (BonitaException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e);
            }
        }
        return task;
    }

    public List<Task> getTasks(String processInstanceId) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        this.commit();
        ProcessInstanceUUID uuid = UUIDFactory.getProcessInstanceUUID(processInstanceId);
        QueryRuntimeAPI rApi = AccessorUtil.getQueryAPIAccessor().getQueryRuntimeAPI();
        QueryDefinitionAPI dApi = AccessorUtil.getQueryAPIAccessor().getQueryDefinitionAPI();
        ArrayList todoList = new ArrayList();
        todoList.addAll(rApi.getTaskList(ActivityState.READY));
        todoList.addAll(rApi.getTaskList(ActivityState.EXECUTING));
        todoList.addAll(rApi.getTaskList(ActivityState.SUSPENDED));
        todoList.addAll(rApi.getTaskList(ActivityState.FINISHED));
        for (ActivityInstance task : todoList) {
            if (!task.getProcessInstanceUUID().equals((Object)uuid)) continue;
            try {
                tasks.add(new TaskData((ActivityInstance<TaskInstance>)task));
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e);
            }
        }
        Collections.sort(tasks, new TaskComparator());
        return tasks;
    }

    public List<Timer> getTimers() {
        return new ArrayList<Timer>();
    }

    public List<Task> getUserTaskList(String user) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        this.commit();
        QueryRuntimeAPI rApi = AccessorUtil.getQueryAPIAccessor().getQueryRuntimeAPI();
        ArrayList todoList = new ArrayList();
        todoList.addAll(rApi.getTaskList(ActivityState.READY));
        todoList.addAll(rApi.getTaskList(ActivityState.EXECUTING));
        todoList.addAll(rApi.getTaskList(ActivityState.SUSPENDED));
        for (ActivityInstance task : todoList) {
            try {
                tasks.add(new TaskData((ActivityInstance<TaskInstance>)task));
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e);
            }
        }
        Collections.sort(tasks, new TaskComparator());
        return tasks;
    }

    private Object getVariableValue(Object value, DataTypeValue typeValue) throws ParseException {
        if (EnumerationTypeDefinition.class.isInstance(typeValue)) {
            Set possibleValues = ((EnumerationTypeDefinition)EnumerationTypeDefinition.class.cast(typeValue)).getEnumerationValues();
            if (possibleValues.contains(value)) {
                value = new Enumeration(possibleValues, (String)value);
            }
        } else if (BasicTypeDefinition.class.isInstance(typeValue)) {
            BasicTypeDefinition type = (BasicTypeDefinition)BasicTypeDefinition.class.cast(typeValue);
            switch (type.getType()) {
                case BOOLEAN: {
                    value = Boolean.valueOf((String)value);
                    break;
                }
                case DATETIME: {
                    if (Date.class.isInstance(value) || value == null || ((String)value).length() == 0) break;
                    SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                    value = formatter.parse((String)value);
                    break;
                }
                case INTEGER: {
                    if (((String)value).trim().compareTo("") == 0) {
                        value = 0;
                        break;
                    }
                    value = Integer.decode((String)value);
                    break;
                }
                case FLOAT: {
                    value = ((String)value).trim().compareTo("") == 0 ? Double.valueOf(0.0) : Double.valueOf(Double.parseDouble((String)value));
                }
            }
        }
        return value;
    }

    private Map<String, Object> cleanVariables(Map<String, Object> vList) {
        if (vList == null) {
            return null;
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (String key : vList.keySet()) {
            if (Enumeration.class.isInstance(vList.get(key))) {
                variables.put(key, ((Enumeration)Enumeration.class.cast(vList.get(key))).getSelectedValue());
                continue;
            }
            variables.put(key, vList.get(key));
        }
        return variables;
    }

    public Map getVariables(String InstanceId, String taskId) {
        Map<Object, Object> variables;
        block2: {
            variables = new HashMap();
            QueryRuntimeAPI rApi = AccessorUtil.getQueryAPIAccessor().getQueryRuntimeAPI();
            TaskUUID uuid = UUIDFactory.getTaskUUID(taskId);
            try {
                ActivityInstance task = rApi.getTask(uuid);
                variables = this.cleanVariables(rApi.getProcessInstanceVariables(task.getProcessInstanceUUID()));
                variables.putAll(this.cleanVariables(rApi.getActivityInstanceVariables(task.getUUID())));
            }
            catch (BonitaException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e);
            }
        }
        return variables;
    }

    public boolean hasStartTask(String processId) {
        Form form = this.formsService.getForm(processId, ProcessData.START_STATE_NAME, Locale.getDefault());
        return !form.getVariables().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LoginContext lc = null;
        try {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)this.organizationService));
            UserHandler userHandler = this.organizationService.getUserHandler();
            User user = userHandler.findUserByName(this.superUser_);
            char[] password = user.getPassword() == null ? this.superPass_.toCharArray() : user.getPassword().toCharArray();
            BasicCallbackHandler handler = new BasicCallbackHandler(this.superUser_, password);
            lc = new LoginContext(this.jaasLoginContext_, (CallbackHandler)handler);
            lc.login();
            List<Process> projects = this.getProcesses();
            if (projects.isEmpty()) {
                for (ProcessesConfig processConfig : this.configurations) {
                    HashSet predefinedProcesses = processConfig.getPredefinedProcess();
                    String processLoc = processConfig.getProcessLocation();
                    for (String parFile : predefinedProcesses) {
                        URL url = this.configurationManager.getURL(processLoc + parFile);
                        try {
                            InputStream iS = this.configurationManager.getInputStream(processLoc + parFile);
                            this.deployProcess(iS);
                        }
                        catch (Exception e) {
                            if (!LOG.isErrorEnabled()) continue;
                            LOG.error((Object)e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
        }
        finally {
            try {
                lc.logout();
                RequestLifeCycle.end();
            }
            catch (Exception exception) {}
        }
    }

    public void startProcess(String processId) {
        this.startProcess(null, processId, new HashMap());
    }

    public void startProcess(String remoteUser, String processId, Map initialVariables) {
        block18: {
            this.commit();
            try {
                RuntimeAPI rApi = AccessorUtil.getAPIAccessor().getRuntimeAPI();
                QueryDefinitionAPI dAPI = AccessorUtil.getQueryAPIAccessor().getQueryDefinitionAPI();
                ProcessDefinitionUUID uuid = UUIDFactory.getProcessDefinitionUUID(processId);
                HashMap<String, Object> variables = new HashMap<String, Object>();
                if (initialVariables != null) {
                    Set dataFields = dAPI.getProcessDataFields(uuid);
                    block10: for (DataFieldDefinition dataField : dataFields) {
                        if (!initialVariables.containsKey(dataField.getDataFieldId())) continue;
                        DataTypeValue typeValue = dataField.getDataType().getValue();
                        if (EnumerationTypeDefinition.class.isInstance(typeValue)) {
                            String strEnumValue;
                            Set possibleValues = ((EnumerationTypeDefinition)EnumerationTypeDefinition.class.cast(typeValue)).getEnumerationValues();
                            if (!possibleValues.contains(strEnumValue = (String)initialVariables.get(dataField.getDataFieldId()))) continue;
                            variables.put(dataField.getDataFieldId(), new Enumeration(possibleValues, strEnumValue));
                            continue;
                        }
                        if (!BasicTypeDefinition.class.isInstance(typeValue)) continue;
                        BasicTypeDefinition type = (BasicTypeDefinition)BasicTypeDefinition.class.cast(typeValue);
                        Object value = initialVariables.get(dataField.getDataFieldId());
                        switch (type.getType()) {
                            case BOOLEAN: {
                                variables.put(dataField.getDataFieldId(), Boolean.valueOf((String)value));
                                continue block10;
                            }
                            case DATETIME: {
                                if (!Date.class.isInstance(value)) {
                                    SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                                    variables.put(dataField.getDataFieldId(), formatter.parse((String)value));
                                    continue block10;
                                }
                                variables.put(dataField.getDataFieldId(), value);
                                continue block10;
                            }
                            case INTEGER: {
                                if (((String)value).trim().compareTo("") == 0) {
                                    variables.put(dataField.getDataFieldId(), 0);
                                    continue block10;
                                }
                                variables.put(dataField.getDataFieldId(), Integer.decode((String)value));
                                continue block10;
                            }
                            case FLOAT: {
                                if (((String)value).trim().compareTo("") == 0) {
                                    value = 0.0;
                                    continue block10;
                                }
                                value = Double.parseDouble((String)value);
                                continue block10;
                            }
                        }
                        variables.put(dataField.getDataFieldId(), (String)value);
                    }
                }
                ProcessInstanceUUID instanceUuid = rApi.instantiateProcess(uuid, variables);
            }
            catch (ProcessNotFoundException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (ParseException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (VariableNotFoundException e) {
                if (!LOG.isErrorEnabled()) break block18;
                LOG.error((Object)e);
            }
        }
    }

    public void startProcessFromName(String remoteUser, String processName, Map variables) {
        block4: {
            this.commit();
            try {
                QueryDefinitionAPI dAPI = AccessorUtil.getQueryAPIAccessor().getQueryDefinitionAPI();
                Set processes = dAPI.getProcesses(processName);
                ProcessDefinition process = null;
                for (ProcessDefinition p : processes) {
                    if (dAPI.getPackage(p.getPackageDefinitionUUID()).getUndeployedDate() != null) continue;
                    process = p;
                    break;
                }
                if (process != null) {
                    String uuid = process.getProcessDefinitionUUID().toString();
                    this.startProcess(remoteUser, uuid, variables);
                }
            }
            catch (BonitaException e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)e);
            }
        }
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit() {
        block10: {
            LoginContext lc = null;
            try {
                block9: {
                    Identity identity = ConversationState.getCurrent().getIdentity();
                    if (identity.getSubject() != null) {
                        Subject s = new Subject();
                        s.getPrincipals().add((Principal)new BonitaPrincipal(identity.getUserId()));
                        try {
                            lc = new LoginContext("Bonita", s);
                        }
                        catch (LoginException le) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)le);
                            }
                            break block9;
                        }
                    }
                    try {
                        RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)this.organizationService));
                        UserHandler userHandler = this.organizationService.getUserHandler();
                        User user = userHandler.findUserByName(identity.getUserId());
                        char[] password = user.getPassword() == null ? this.superPass_.toCharArray() : user.getPassword().toCharArray();
                        BasicCallbackHandler handler = new BasicCallbackHandler(identity.getUserId(), password);
                        lc = new LoginContext(this.jaasLoginContext_, (CallbackHandler)handler);
                    }
                    finally {
                        RequestLifeCycle.end();
                    }
                }
                lc.login();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block10;
                LOG.warn((Object)e.getMessage());
            }
        }
    }
}

