/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.jbpm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.workflow.PredefinedProcessesPlugin;
import org.exoplatform.services.workflow.Process;
import org.exoplatform.services.workflow.ProcessInstance;
import org.exoplatform.services.workflow.ProcessesConfig;
import org.exoplatform.services.workflow.Task;
import org.exoplatform.services.workflow.Timer;
import org.exoplatform.services.workflow.WorkflowFileDefinitionService;
import org.exoplatform.services.workflow.WorkflowFormsService;
import org.exoplatform.services.workflow.WorkflowServiceContainer;
import org.exoplatform.services.workflow.impl.jbpm.ProcessData;
import org.exoplatform.services.workflow.impl.jbpm.ProcessInstanceData;
import org.exoplatform.services.workflow.impl.jbpm.TaskData;
import org.hibernate.cfg.Configuration;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.db.GraphSession;
import org.jbpm.db.JbpmSchema;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowServiceContainerImpl
implements WorkflowServiceContainer,
Startable,
ComponentRequestLifecycle {
    private ConfigurationManager configurationManager_;
    private List<ProcessesConfig> configs_;
    private JbpmConfiguration jbpmConfiguration;
    private OrganizationService orgService_;
    private ThreadLocal threadLocal_;
    private String hibernateServiceName_;
    private WorkflowFileDefinitionService fileDefinitionService_;
    private static final Log LOG = ExoLogger.getLogger((String)WorkflowServiceContainerImpl.class.getName());
    private String jbpm_cfg;

    public WorkflowServiceContainerImpl(OrganizationService orgService, WorkflowFileDefinitionService fileDefinitionService, ConfigurationManager conf, InitParams params) throws Exception {
        this.hibernateServiceName_ = params.getValueParam("hibernate.service").getValue();
        this.configs_ = new ArrayList<ProcessesConfig>();
        this.configurationManager_ = conf;
        this.threadLocal_ = new ThreadLocal();
        this.orgService_ = orgService;
        this.fileDefinitionService_ = fileDefinitionService;
        this.jbpm_cfg = params.getValueParam("jbpm_cfg").getValue();
    }

    public void addPlugin(ComponentPlugin plugin) throws Exception {
        if (!(plugin instanceof PredefinedProcessesPlugin)) {
            throw new RuntimeException(plugin.getClass().getName() + " is an unknown plugin type.");
        }
        this.configs_.add(((PredefinedProcessesPlugin)plugin).getProcessesConfig());
    }

    public void initComponent(ExoContainer container) throws Exception {
        HibernateService hservice = null;
        hservice = this.hibernateServiceName_ == null || this.hibernateServiceName_.length() == 0 || "default".equals(this.hibernateServiceName_) ? (HibernateService)container.getComponentInstanceOfType(HibernateService.class) : (HibernateService)container.getComponentInstance((Object)this.hibernateServiceName_);
        Configuration hconf = hservice.getHibernateConfiguration();
        this.jbpmConfiguration = JbpmConfiguration.parseInputStream((InputStream)this.configurationManager_.getInputStream(this.jbpm_cfg));
        DbPersistenceServiceFactory persistenceServiceFactory = (DbPersistenceServiceFactory)this.openJbpmContext().getServiceFactory("persistence");
        persistenceServiceFactory.setConfiguration(hconf);
        JbpmSchema jbpmSchema = persistenceServiceFactory.getJbpmSchema();
        if (jbpmSchema.getJbpmTables().size() == 0) {
            jbpmSchema.createSchema();
        }
        this.init();
    }

    public void start() {
        try {
            this.initComponent(ExoContainerContext.getCurrentContainer());
            this.jbpmConfiguration.startJobExecutor();
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public void destroyComponent(ExoContainer arg0) throws Exception {
    }

    public JbpmContext openJbpmContext() {
        JbpmContext currentJbpmcontext = (JbpmContext)this.threadLocal_.get();
        if (currentJbpmcontext == null) {
            this.threadLocal_.set(this.jbpmConfiguration.createJbpmContext());
        }
        return (JbpmContext)this.threadLocal_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        JbpmContext jbpmContext = this.openJbpmContext();
        try {
            if (!jbpmContext.getGraphSession().findAllProcessDefinitions().isEmpty()) {
                return;
            }
            for (ProcessesConfig processConfig : this.configs_) {
                HashSet predefinedProcesses = processConfig.getPredefinedProcess();
                String processLoc = processConfig.getProcessLocation();
                for (String parFile : predefinedProcesses) {
                    try {
                        InputStream iS = this.configurationManager_.getInputStream(processLoc + parFile);
                        ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream((ZipInputStream)new ZipInputStream(iS));
                        jbpmContext.deployProcessDefinition(processDefinition);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeJbpmContext();
        }
    }

    public void closeJbpmContext() {
        JbpmContext jbpmContext = (JbpmContext)this.threadLocal_.get();
        this.closeJbpmContext(jbpmContext);
    }

    public void closeJbpmContext(JbpmContext jbpmContext) {
        if (jbpmContext == null) {
            return;
        }
        try {
            jbpmContext.close();
            jbpmContext = null;
        }
        catch (Throwable t) {
            jbpmContext.setRollbackOnly();
            LOG.error((Object)t);
        }
        this.threadLocal_.set(null);
    }

    public List<Task> getAllTasks(String user) throws Exception {
        ArrayList<Task> allTasks = new ArrayList<Task>();
        allTasks.addAll(this.getUserTaskList(user));
        List<Task> groupTask = this.getGroupTaskList(user);
        for (Task task : allTasks) {
            for (Task checkTask : groupTask) {
                if (!checkTask.getId().equalsIgnoreCase(task.getId())) continue;
                groupTask.remove(checkTask);
            }
        }
        allTasks.addAll(groupTask);
        return allTasks;
    }

    public List<Task> getUserTaskList(String user) {
        JbpmContext jbpmContext = this.openJbpmContext();
        List taskInstances = jbpmContext.getTaskMgmtSession().findTaskInstances(user);
        return WorkflowServiceContainerImpl.wrapTasks(taskInstances);
    }

    public List<Task> getGroupTaskList(String user) throws Exception {
        ArrayList<Task> groupTasks = new ArrayList<Task>();
        HashSet hashSet = new HashSet();
        String key = null;
        Collection groups = this.orgService_.getGroupHandler().findGroupsOfUser(user);
        Collection membershipCollection = this.orgService_.getMembershipTypeHandler().findMembershipTypes();
        JbpmContext jbpmContext = this.openJbpmContext();
        for (Group group : groups) {
            Collection memberships = this.orgService_.getMembershipHandler().findMembershipsByUserAndGroup(user, group.getId());
            for (Membership membership : memberships) {
                List tasks;
                if (membership.getMembershipType().equals("*")) {
                    for (Object obj : membershipCollection) {
                        key = ((MembershipType)obj).getName() + ":" + group.getId();
                        List tasks2 = jbpmContext.getTaskMgmtSession().findTaskInstances(key);
                        if (tasks2.size() <= 0) continue;
                        hashSet.addAll(tasks2);
                    }
                    key = membership.getMembershipType() + ":" + group.getId();
                    tasks = jbpmContext.getTaskMgmtSession().findTaskInstances(key);
                    if (tasks.size() <= 0) continue;
                    hashSet.addAll(tasks);
                    continue;
                }
                key = membership.getMembershipType() + ":" + group.getId();
                tasks = jbpmContext.getTaskMgmtSession().findTaskInstances(key);
                if (tasks.size() > 0) {
                    hashSet.addAll(tasks);
                }
                String starKey = "*:" + group.getId();
                List tasksWithStar = jbpmContext.getTaskMgmtSession().findTaskInstances(starKey);
                if (tasksWithStar.size() <= 0) continue;
                hashSet.addAll(tasksWithStar);
            }
        }
        for (TaskInstance instance : hashSet) {
            groupTasks.add(new TaskData(instance));
        }
        return groupTasks;
    }

    private static List<Task> wrapTasks(List tasks) {
        ArrayList<Task> wrappedTokens = new ArrayList<Task>();
        for (TaskInstance task : tasks) {
            wrappedTokens.add(new TaskData(task));
        }
        return wrappedTokens;
    }

    public List<Process> getProcesses() {
        ArrayList<Process> processes = new ArrayList<Process>();
        JbpmContext jbpmContext = this.openJbpmContext();
        List definitions = jbpmContext.getGraphSession().findAllProcessDefinitions();
        for (ProcessDefinition def : definitions) {
            processes.add(new ProcessData(def));
        }
        return processes;
    }

    public boolean hasStartTask(String processId) {
        JbpmContext jbpmContext = this.openJbpmContext();
        ProcessDefinition processDef = jbpmContext.getGraphSession().loadProcessDefinition(Long.parseLong(processId));
        return processDef.getTaskMgmtDefinition().getStartTask() != null;
    }

    public void startProcess(String processId) {
        JbpmContext jbpmContext = this.openJbpmContext();
        ProcessDefinition processDef = jbpmContext.getGraphSession().loadProcessDefinition(Long.parseLong(processId));
        org.jbpm.graph.exe.ProcessInstance processInstance = new org.jbpm.graph.exe.ProcessInstance(processDef);
        processInstance.signal();
        jbpmContext.save(processInstance);
    }

    public void startProcess(String remoteUser, String processId, Map variables) {
        JbpmContext jbpmContext = this.openJbpmContext();
        GraphSession graphSession = jbpmContext.getGraphSession();
        ProcessDefinition processDef = graphSession.loadProcessDefinition(Long.parseLong(processId));
        org.jbpm.graph.exe.ProcessInstance instance = new org.jbpm.graph.exe.ProcessInstance(processDef);
        ContextInstance contextInstance = instance.getContextInstance();
        variables.put("initiator", remoteUser);
        contextInstance.addVariables(variables);
        TaskInstance taskInstance = instance.getTaskMgmtInstance().createStartTaskInstance();
        taskInstance.setActorId(remoteUser);
        taskInstance.end();
        jbpmContext.save(instance);
    }

    public void startProcessFromName(String remoteUser, String processName, Map variables) {
        JbpmContext jbpmContext = this.openJbpmContext();
        GraphSession graphSession = jbpmContext.getGraphSession();
        ProcessDefinition processDef = graphSession.findLatestProcessDefinition(processName);
        org.jbpm.graph.exe.ProcessInstance instance = new org.jbpm.graph.exe.ProcessInstance(processDef);
        ContextInstance contextInstance = instance.getContextInstance();
        contextInstance.addVariables(variables);
        TaskInstance taskInstance = instance.getTaskMgmtInstance().createStartTaskInstance();
        taskInstance.setActorId(remoteUser);
        taskInstance.end();
        jbpmContext.save(instance);
    }

    public List<ProcessInstance> getProcessInstances(String processId) {
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>();
        JbpmContext jbpmContext = this.openJbpmContext();
        List jbpmProcessInstances = jbpmContext.getGraphSession().findProcessInstances(new Long(processId).longValue());
        for (org.jbpm.graph.exe.ProcessInstance processInstance : jbpmProcessInstances) {
            processInstances.add(new ProcessInstanceData(processInstance));
        }
        return processInstances;
    }

    public List<Task> getTasks(String processInstanceId) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        JbpmContext jbpmContext = this.openJbpmContext();
        org.jbpm.graph.exe.ProcessInstance processInstance = jbpmContext.getGraphSession().loadProcessInstance(new Long(processInstanceId).longValue());
        Collection taskInstances = processInstance.getTaskMgmtInstance().getTaskInstances();
        for (TaskInstance task : taskInstances) {
            tasks.add(new TaskData(task));
        }
        return tasks;
    }

    public Process getProcess(String processId) {
        JbpmContext jbpmContext = this.openJbpmContext();
        ProcessDefinition processDef = jbpmContext.getGraphSession().loadProcessDefinition(Long.parseLong(processId));
        return new ProcessData(processDef);
    }

    public Task getTask(String taskId) {
        JbpmContext jbpmContext = this.openJbpmContext();
        TaskInstance task = jbpmContext.getTaskMgmtSession().loadTaskInstance(Long.parseLong(taskId));
        return new TaskData(task);
    }

    public ProcessInstance getProcessInstance(String processInstance) {
        JbpmContext jbpmContext = this.openJbpmContext();
        org.jbpm.graph.exe.ProcessInstance jbpmProcessInstance = jbpmContext.getGraphSession().loadProcessInstance(Long.parseLong(processInstance));
        return new ProcessInstanceData(jbpmProcessInstance);
    }

    public Map getVariables(String processInstanceId, String taskId) {
        JbpmContext jbpmContext = this.openJbpmContext();
        org.jbpm.graph.exe.ProcessInstance jbpmProcessInstance = jbpmContext.getGraphSession().loadProcessInstance(Long.parseLong(processInstanceId));
        return jbpmProcessInstance.getContextInstance().getVariables();
    }

    public void endTask(String taskId, Map variables) {
        JbpmContext jbpmContext = this.openJbpmContext();
        TaskInstance taskInstance = jbpmContext.getTaskMgmtSession().loadTaskInstance(Long.parseLong(taskId));
        org.jbpm.graph.exe.ProcessInstance processInstance = taskInstance.getToken().getProcessInstance();
        ContextInstance contextInstance = processInstance.getContextInstance();
        contextInstance.addVariables(variables);
        taskInstance.end();
        jbpmContext.save(processInstance);
    }

    public void endTask(String taskId, Map variables, String transition) {
        JbpmContext jbpmContext = this.openJbpmContext();
        TaskInstance taskInstance = jbpmContext.getTaskMgmtSession().loadTaskInstance(Long.parseLong(taskId));
        org.jbpm.graph.exe.ProcessInstance processInstance = taskInstance.getToken().getProcessInstance();
        ContextInstance contextInstance = processInstance.getContextInstance();
        contextInstance.addVariables(variables);
        taskInstance.end(transition);
        jbpmContext.save(processInstance);
    }

    public List<Timer> getTimers() {
        ArrayList<Timer> timers = new ArrayList<Timer>();
        return timers;
    }

    public void deployProcess(InputStream iS) throws IOException {
        this.openJbpmContext().deployProcessDefinition(ProcessDefinition.parseParZipInputStream((ZipInputStream)new ZipInputStream(iS)));
    }

    public void deleteProcess(String processId) {
        JbpmContext jbpmContext = this.openJbpmContext();
        jbpmContext.getGraphSession().deleteProcessDefinition(Long.parseLong(processId));
        WorkflowFormsService formsService = (WorkflowFormsService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WorkflowFormsService.class);
        formsService.removeForms(processId);
    }

    public void deleteProcessInstance(String processInstanceId) {
        JbpmContext jbpmContext = this.openJbpmContext();
        jbpmContext.getGraphSession().deleteProcessInstance(Long.parseLong(processInstanceId));
    }

    public void startRequest(ExoContainer arg0) {
    }

    public void endRequest(ExoContainer arg0) {
        this.closeJbpmContext();
    }

    public WorkflowFileDefinitionService getFileDefinitionService() {
        return this.fileDefinitionService_;
    }

    public void stop() {
        JobExecutor jobExecutor = this.jbpmConfiguration.getJobExecutor();
        if (jobExecutor != null) {
            jobExecutor.stop();
        }
    }
}

