/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.jbpm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.dom4j.Element;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ExoResourceBundle;
import org.exoplatform.services.resources.XMLResourceBundleParser;
import org.exoplatform.services.workflow.Form;
import org.jbpm.file.def.FileDefinition;

public class FormImpl
implements Form {
    private String stateName;
    private List variables;
    private List submitButtons;
    private ResourceBundle resourceBundle;
    private boolean customizedView;
    private boolean delegatedView;
    private String customizedViewString;
    private byte[] iconBytes;
    private byte[] stateImageBytes;
    private static final Log LOG = ExoLogger.getLogger((String)FormImpl.class.getName());

    public FormImpl(FileDefinition fileDefinition, Element element, Locale locale) {
        String content;
        String localisedFileName;
        Element childElement;
        block22: {
            URL url;
            ClassLoader cl;
            String formFileName;
            block21: {
                childElement = element.element("resource-bundle");
                formFileName = "";
                if (childElement != null) {
                    formFileName = childElement.getText();
                }
                cl = this.getClass().getClassLoader();
                localisedFileName = this.getLocalisedString(formFileName, locale);
                content = "";
                url = cl.getResource(localisedFileName);
                if (url == null) {
                    url = cl.getResource(formFileName + ".xml");
                }
                if (url != null) {
                    try {
                        Properties props = XMLResourceBundleParser.asProperties((InputStream)url.openStream());
                        StringBuilder sb = new StringBuilder();
                        for (Map.Entry<Object, Object> entry : props.entrySet()) {
                            sb.append(entry.getKey());
                            sb.append('=');
                            sb.append(entry.getValue());
                            sb.append('\n');
                        }
                        content = sb.toString();
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block21;
                        LOG.debug((Object)"resource bundle not found");
                    }
                }
            }
            if (content.length() == 0) {
                String fileName = formFileName + "_" + locale.getLanguage() + ".properties";
                url = cl.getResource(fileName);
                if (url == null) {
                    url = cl.getResource(formFileName + ".properties");
                }
                if (url != null) {
                    try {
                        InputStream is = url.openStream();
                        byte[] buf = IOUtil.getStreamContentAsBytes((InputStream)is);
                        content = new String(buf, "UTF-8");
                        is.close();
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block22;
                        LOG.debug((Object)"resource bundle not found");
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Try to find localised resource : " + localisedFileName));
        }
        if (content.length() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"resource bundle found true");
            }
            this.resourceBundle = new ExoResourceBundle(content);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"resource bundle not found");
        }
        childElement = element.element("state-name");
        if (childElement != null) {
            this.stateName = childElement.getText();
        }
        this.initializeVariables(element);
        this.initializeSubmitButtons(element);
        childElement = element.element("customized-view");
        if (childElement != null) {
            this.customizedViewString = childElement.getText();
        }
        if (this.customizedViewString != null && !"".equals(this.customizedViewString)) {
            this.customizedView = true;
        }
        childElement = element.element("delegated-view");
        String delegatedViewString = "";
        if (childElement != null) {
            delegatedViewString = childElement.getText();
        }
        if ("true".equals(delegatedViewString)) {
            this.delegatedView = true;
        }
        this.iconBytes = this.getBytes(fileDefinition, this.stateName + "-icon.gif");
        this.stateImageBytes = this.getBytes(fileDefinition, this.stateName + "-state.gif");
    }

    private String getLocalisedString(String fileName, Locale locale) {
        return fileName + "_" + locale.getLanguage() + ".xml";
    }

    private void initializeVariables(Element element) {
        this.variables = new ArrayList();
        HashMap<String, String> attributes = null;
        for (Element variableElement : element.elements("variable")) {
            attributes = new HashMap<String, String>();
            String variableName = variableElement.attributeValue("name");
            attributes.put("name", variableName);
            String componentName = variableElement.attributeValue("component");
            attributes.put("component", componentName);
            String editable = variableElement.attributeValue("editable");
            attributes.put("editable", editable);
            String mandatory = variableElement.attributeValue("mandatory");
            attributes.put("mandatory", mandatory);
            String visiable = variableElement.attributeValue("visiable");
            attributes.put("visiable", visiable);
            this.variables.add(attributes);
        }
    }

    private void initializeSubmitButtons(Element element) {
        this.submitButtons = new ArrayList();
        HashMap<String, String> attributes = null;
        for (Element submitButtonElement : element.elements("submitbutton")) {
            attributes = new HashMap<String, String>();
            String value = submitButtonElement.attributeValue("name");
            attributes.put("name", value);
            String transitionName = submitButtonElement.attributeValue("transition-name");
            attributes.put("transition", transitionName);
            this.submitButtons.add(attributes);
        }
    }

    public List getVariables() {
        return this.variables;
    }

    public List getSubmitButtons() {
        return this.submitButtons;
    }

    public String getStateName() {
        return this.stateName;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public boolean isCustomizedView() {
        return this.customizedView;
    }

    public String getCustomizedView() {
        return this.customizedViewString;
    }

    public boolean isDelegatedView() {
        return this.delegatedView;
    }

    public String getIconURL() {
        return this.getURL(this.iconBytes);
    }

    public String getStateImageURL() {
        return this.getURL(this.stateImageBytes);
    }

    public byte[] getBytes(FileDefinition fileDefinition, String file) {
        try {
            return fileDefinition.getBytes(file);
        }
        catch (Exception t) {
            return null;
        }
    }

    public String getURL(byte[] bytes) {
        DownloadService dS = (DownloadService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(DownloadService.class);
        ByteArrayInputStream iS = new ByteArrayInputStream(bytes);
        String id = dS.addDownloadResource((DownloadResource)new InputStreamDownloadResource((InputStream)iS, "image/gif"));
        return dS.getDownloadLink(id);
    }
}

