/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.exoplatform.ecms.xcmis.sp.BaseJcrStorage;
import org.exoplatform.ecms.xcmis.sp.BaseObjectData;
import org.exoplatform.ecms.xcmis.sp.DocumentDataImpl;
import org.exoplatform.ecms.xcmis.sp.DocumentOrderResultSorter;
import org.exoplatform.ecms.xcmis.sp.DocumentVersion;
import org.exoplatform.ecms.xcmis.sp.FolderDataImpl;
import org.exoplatform.ecms.xcmis.sp.JcrFile;
import org.exoplatform.ecms.xcmis.sp.JcrFolder;
import org.exoplatform.ecms.xcmis.sp.JcrNodeEntry;
import org.exoplatform.ecms.xcmis.sp.PWC;
import org.exoplatform.ecms.xcmis.sp.PolicyDataImpl;
import org.exoplatform.ecms.xcmis.sp.QueryResultIterator;
import org.exoplatform.ecms.xcmis.sp.RelationshipDataImpl;
import org.exoplatform.ecms.xcmis.sp.StorageConfiguration;
import org.exoplatform.ecms.xcmis.sp.TypeMapping;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.xcmis.search.InvalidQueryException;
import org.xcmis.search.SearchService;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.QueryElement;
import org.xcmis.search.model.constraint.And;
import org.xcmis.search.model.constraint.Constraint;
import org.xcmis.search.model.constraint.DescendantNode;
import org.xcmis.search.model.source.Selector;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.parser.CmisQueryParser;
import org.xcmis.search.parser.QueryParser;
import org.xcmis.search.query.QueryExecutionException;
import org.xcmis.spi.BaseItemsIterator;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.NotSupportedException;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectDataVisitor;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.PermissionService;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.Storage;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.ACLCapability;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.AccessControlPropagation;
import org.xcmis.spi.model.AllowableActions;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.CapabilityACL;
import org.xcmis.spi.model.CapabilityChanges;
import org.xcmis.spi.model.CapabilityContentStreamUpdatable;
import org.xcmis.spi.model.CapabilityJoin;
import org.xcmis.spi.model.CapabilityQuery;
import org.xcmis.spi.model.CapabilityRendition;
import org.xcmis.spi.model.ChangeEvent;
import org.xcmis.spi.model.Permission;
import org.xcmis.spi.model.PermissionMapping;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.Rendition;
import org.xcmis.spi.model.RepositoryCapabilities;
import org.xcmis.spi.model.RepositoryInfo;
import org.xcmis.spi.model.SupportedPermissions;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.UnfileObject;
import org.xcmis.spi.model.Updatability;
import org.xcmis.spi.model.VersioningState;
import org.xcmis.spi.model.impl.StringProperty;
import org.xcmis.spi.query.Query;
import org.xcmis.spi.query.Result;
import org.xcmis.spi.utils.CmisUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageImpl
extends BaseJcrStorage
implements Storage {
    private static final Comparator<ObjectData> CREATION_DATE_COMPARATOR = new Comparator<ObjectData>(){

        @Override
        public int compare(ObjectData object1, ObjectData object2) {
            Calendar c1 = object1.getCreationDate();
            Calendar c2 = object2.getCreationDate();
            return c2.compareTo(c1);
        }
    };
    private static final Log LOG = ExoLogger.getLogger(StorageImpl.class);
    private RepositoryInfo repositoryInfo;
    private final PermissionService permissionService;
    private SearchService searchService;
    private final QueryParser cmisQueryParser;

    public StorageImpl(Session session, StorageConfiguration configuration, SearchService searchService, PermissionService permissionService, Map<String, TypeMapping> nodeTypeMapping) {
        super(session, configuration, nodeTypeMapping);
        this.searchService = searchService;
        this.permissionService = permissionService;
        this.cmisQueryParser = new CmisQueryParser();
    }

    public AllowableActions calculateAllowableActions(ObjectData object) {
        ConversationState state = ConversationState.getCurrent();
        AllowableActions actions = this.permissionService.calculateAllowableActions(object, state != null ? state.getIdentity().getUserId() : null, this.getRepositoryInfo());
        if (object instanceof JcrFile) {
            actions.setCanCheckOut(false);
            actions.setCanCheckIn(false);
            actions.setCanCancelCheckOut(false);
        }
        return actions;
    }

    public DocumentData copyDocument(DocumentData source, FolderData parent, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies, VersioningState versioningState) throws ConstraintException, NameConstraintViolationException, StorageException {
        TypeDefinition typeDefinition = source.getTypeDefinition();
        Property<?> nameProperty = null;
        if (properties == null) {
            properties = new HashMap();
        } else {
            nameProperty = properties.get("cmis:name");
        }
        String name = null;
        if (nameProperty == null || nameProperty.getValues().size() == 0 || (name = (String)nameProperty.getValues().get(0)) == null || name.length() == 0) {
            name = source.getName();
            PropertyDefinition namePropertyDefinition = typeDefinition.getPropertyDefinition("cmis:name");
            properties.put(namePropertyDefinition.getId(), (Property<?>)new StringProperty(namePropertyDefinition.getId(), namePropertyDefinition.getQueryName(), namePropertyDefinition.getLocalName(), namePropertyDefinition.getDisplayName(), name));
        }
        try {
            return this.createDocument(parent, typeDefinition, properties, source.getContentStream(), acl, policies, versioningState);
        }
        catch (IOException ioe) {
            throw new CmisRuntimeException("Unable copy content for new document. " + ioe.getMessage(), (Throwable)ioe);
        }
    }

    public DocumentData createDocument(FolderData parent, TypeDefinition typeDefinition, Map<String, Property<?>> properties, ContentStream content, List<AccessControlEntry> acl, Collection<PolicyData> policies, VersioningState versioningState) throws ConstraintException, NameConstraintViolationException, IOException, StorageException {
        String contentFileName;
        String name = null;
        Property<?> nameProperty = properties.get("cmis:name");
        if (nameProperty != null && nameProperty.getValues().size() > 0) {
            name = (String)nameProperty.getValues().get(0);
        }
        if (name == null && content != null) {
            name = content.getFileName();
        }
        if (name == null || name.length() == 0) {
            throw new NameConstraintViolationException("Name for new document must be provided.");
        }
        JcrNodeEntry documentEntry = this.createDocumentEntry(parent != null ? ((FolderDataImpl)parent).getNodeEntry() : null, name, typeDefinition, versioningState);
        documentEntry.setValue("cmis:objectTypeId", typeDefinition.getId());
        documentEntry.setValue("cmis:baseTypeId", typeDefinition.getBaseId().value());
        documentEntry.setValue("cmis:createdBy", this.session.getUserID());
        documentEntry.setValue("cmis:creationDate", Calendar.getInstance());
        documentEntry.setValue("cmis:versionSeriesId", documentEntry.getString("jcr:versionHistory"));
        documentEntry.setValue("cmis:isLatestVersion", true);
        documentEntry.setValue("cmis:isMajorVersion", versioningState == VersioningState.MAJOR);
        documentEntry.setValue("cmis:versionLabel", "latest");
        Property<?> contentFileNameProperty = properties.get("cmis:contentStreamFileName");
        if (content != null && (contentFileNameProperty == null || contentFileNameProperty.getValues().isEmpty()) && (contentFileName = content.getFileName()) != null) {
            documentEntry.setValue("cmis:contentStreamFileName", contentFileName);
        }
        for (Property<?> property : properties.values()) {
            PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
            Updatability updatability = definition.getUpdatability();
            if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
            documentEntry.setProperty(property);
        }
        documentEntry.setContentStream(content);
        if (acl != null && acl.size() > 0) {
            documentEntry.setACL(acl);
        }
        if (policies != null && policies.size() > 0) {
            for (PolicyData policy : policies) {
                documentEntry.applyPolicy(((BaseObjectData)policy).getNodeEntry());
            }
        }
        DocumentDataImpl document = new DocumentDataImpl(documentEntry);
        document.save();
        return document;
    }

    public FolderData createFolder(FolderData parent, TypeDefinition typeDefinition, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws ConstraintException, NameConstraintViolationException, StorageException {
        if (parent == null) {
            throw new ConstraintException("Parent folder must be provided.");
        }
        String name = null;
        Property<?> nameProperty = properties.get("cmis:name");
        if (nameProperty != null && nameProperty.getValues().size() > 0) {
            name = (String)nameProperty.getValues().get(0);
        }
        if (name == null || name.length() == 0) {
            throw new NameConstraintViolationException("Name for new folder must be provided.");
        }
        JcrNodeEntry folderEntry = this.createFolderEntry(((FolderDataImpl)parent).getNodeEntry(), name, typeDefinition);
        folderEntry.setValue("cmis:objectTypeId", typeDefinition.getId());
        folderEntry.setValue("cmis:baseTypeId", typeDefinition.getBaseId().value());
        folderEntry.setValue("cmis:createdBy", this.session.getUserID());
        folderEntry.setValue("cmis:creationDate", Calendar.getInstance());
        for (Property<?> property : properties.values()) {
            PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
            Updatability updatability = definition.getUpdatability();
            if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
            folderEntry.setProperty(property);
        }
        if (acl != null && acl.size() > 0) {
            folderEntry.setACL(acl);
        }
        if (policies != null && policies.size() > 0) {
            for (PolicyData policy : policies) {
                folderEntry.applyPolicy(((BaseObjectData)policy).getNodeEntry());
            }
        }
        FolderDataImpl folder = new FolderDataImpl(folderEntry);
        folder.save();
        return folder;
    }

    public PolicyData createPolicy(FolderData parent, TypeDefinition typeDefinition, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws ConstraintException, NameConstraintViolationException, StorageException {
        String name = null;
        Property<?> nameProperty = properties.get("cmis:name");
        if (nameProperty != null && nameProperty.getValues().size() > 0) {
            name = (String)nameProperty.getValues().get(0);
        }
        if (name == null || name.length() == 0) {
            throw new NameConstraintViolationException("Name for new policy must be provided.");
        }
        JcrNodeEntry policyEntry = this.createPolicyEntry(name, typeDefinition);
        policyEntry.setValue("cmis:objectTypeId", typeDefinition.getId());
        policyEntry.setValue("cmis:baseTypeId", typeDefinition.getBaseId().value());
        policyEntry.setValue("cmis:createdBy", this.session.getUserID());
        policyEntry.setValue("cmis:creationDate", Calendar.getInstance());
        for (Property<?> property : properties.values()) {
            PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
            Updatability updatability = definition.getUpdatability();
            if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
            policyEntry.setProperty(property);
        }
        if (acl != null && acl.size() > 0) {
            policyEntry.setACL(acl);
        }
        if (policies != null && policies.size() > 0) {
            for (PolicyData policy : policies) {
                policyEntry.applyPolicy(((BaseObjectData)policy).getNodeEntry());
            }
        }
        PolicyDataImpl policy = new PolicyDataImpl(policyEntry);
        policy.save();
        return policy;
    }

    public RelationshipData createRelationship(ObjectData source, ObjectData target, TypeDefinition typeDefinition, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws NameConstraintViolationException, StorageException {
        String name = null;
        Property<?> nameProperty = properties.get("cmis:name");
        if (nameProperty != null) {
            name = (String)nameProperty.getValues().get(0);
        }
        if (name == null || name.length() == 0) {
            throw new NameConstraintViolationException("Name for new relationship must be provided.");
        }
        JcrNodeEntry relationshipEntry = this.createRelationshipEntry(name, typeDefinition, ((BaseObjectData)source).getNodeEntry(), ((BaseObjectData)target).getNodeEntry());
        relationshipEntry.setValue("cmis:objectTypeId", typeDefinition.getId());
        relationshipEntry.setValue("cmis:baseTypeId", typeDefinition.getBaseId().value());
        relationshipEntry.setValue("cmis:createdBy", this.session.getUserID());
        relationshipEntry.setValue("cmis:creationDate", Calendar.getInstance());
        for (Property<?> property : properties.values()) {
            PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
            Updatability updatability = definition.getUpdatability();
            if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
            relationshipEntry.setProperty(property);
        }
        if (acl != null && acl.size() > 0) {
            relationshipEntry.setACL(acl);
        }
        if (policies != null && policies.size() > 0) {
            for (PolicyData policy : policies) {
                relationshipEntry.applyPolicy(((BaseObjectData)policy).getNodeEntry());
            }
        }
        RelationshipDataImpl relationship = new RelationshipDataImpl(relationshipEntry);
        relationship.save();
        return relationship;
    }

    public void deleteObject(ObjectData object, boolean deleteAllVersions) throws UpdateConflictException, VersioningException, StorageException {
        if (object.getBaseType() == BaseType.DOCUMENT && object.getTypeDefinition().isVersionable() && !deleteAllVersions) {
            throw new VersioningException("Unable delete only specified version.");
        }
        ((BaseObjectData)object).delete();
    }

    public Collection<String> deleteTree(FolderData folder, boolean deleteAllVersions, UnfileObject unfileObject, boolean continueOnFailure) throws UpdateConflictException {
        if (!deleteAllVersions) {
            throw new CmisRuntimeException("Unable delete only specified version.");
        }
        String folderId = folder.getObjectId();
        TreeVisitor visitor = new TreeVisitor();
        folder.accept((ObjectDataVisitor)visitor);
        for (BaseObjectData o : visitor.items) {
            try {
                o.delete();
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)("Unable delete object " + o.getObjectId()));
                }
                if (continueOnFailure) continue;
                break;
            }
        }
        try {
            folder = (FolderData)this.getObjectById(folderId);
            visitor = new TreeVisitor();
            folder.accept((ObjectDataVisitor)visitor);
            ArrayList<String> failedToDelete = new ArrayList<String>(visitor.items.size());
            for (BaseObjectData o : visitor.items) {
                failedToDelete.add(o.getObjectId());
            }
            return failedToDelete;
        }
        catch (ObjectNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public Collection<DocumentData> getAllVersions(String versionSeriesId) throws ObjectNotFoundException {
        try {
            Node node = ((ExtendedSession)this.session).getNodeByIdentifier(versionSeriesId);
            VersionHistory vh = (VersionHistory)node;
            ArrayList<DocumentData> versions = new ArrayList<DocumentData>();
            VersionIterator iterator = vh.getAllVersions();
            iterator.next();
            while (iterator.hasNext()) {
                Version v = iterator.nextVersion();
                versions.add(new DocumentVersion(this.fromNode(v.getNode("jcr:frozenNode"))));
            }
            DocumentData latest = (DocumentData)this.getObjectById(vh.getVersionableUUID());
            versions.add(latest);
            String pwcId = latest.getVersionSeriesCheckedOutId();
            if (pwcId != null) {
                PWC pwc = (PWC)this.getObjectById(pwcId);
                versions.add(pwc);
            }
            Collections.sort(versions, CREATION_DATE_COMPARATOR);
            return versions;
        }
        catch (ItemNotFoundException infe) {
            throw new ObjectNotFoundException("Version series '" + versionSeriesId + "' does not exist.");
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get version series " + versionSeriesId + ". " + re.getMessage(), (Throwable)re);
        }
    }

    public ItemsIterator<ChangeEvent> getChangeLog(String changeLogToken) throws ConstraintException {
        throw new NotSupportedException("Changes log feature is not supported.");
    }

    public ItemsIterator<DocumentData> getCheckedOutDocuments(FolderData folder, String orderBy) {
        try {
            Node workingCopies = (Node)this.session.getItem("/xcmis:system/xcmis:workingCopyStore");
            ArrayList<PWC> checkedOut = new ArrayList<PWC>();
            NodeIterator iterator = workingCopies.getNodes();
            block3: while (iterator.hasNext()) {
                Node wc = iterator.nextNode();
                if (!wc.hasNodes()) {
                    LOG.error((Object)"PWC node not fould.");
                    continue;
                }
                Node node = wc.getNodes().nextNode();
                PWC pwc = new PWC(this.fromNode(node));
                if (folder != null) {
                    for (FolderData parent : pwc.getParents()) {
                        if (!parent.equals(folder)) continue;
                        checkedOut.add(pwc);
                        continue block3;
                    }
                    continue;
                }
                checkedOut.add(pwc);
            }
            return new BaseItemsIterator(checkedOut);
        }
        catch (ObjectNotFoundException onfe) {
            throw new CmisRuntimeException("Unable get checked-out documents. " + onfe.getMessage(), (Throwable)onfe);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get checked-out documents. " + re.getMessage(), (Throwable)re);
        }
    }

    public String getId() {
        return this.storageConfiguration.getId();
    }

    public ObjectData getObjectById(String objectId) throws ObjectNotFoundException {
        return this.getObject(this.getEntry(objectId));
    }

    public ObjectData getObjectByPath(String path) throws ObjectNotFoundException {
        if (path == null) {
            throw new CmisRuntimeException("Object path may not be null.");
        }
        try {
            Item item;
            String path1 = this.getJcrRootPath();
            if (!path1.equals("/")) {
                path = path1 + path;
            }
            if (!(item = this.session.getItem(path)).isNode()) {
                throw new ObjectNotFoundException("Object '" + path + "' does not exist.");
            }
            Node node = (Node)item;
            return this.getObject(this.fromNode(node));
        }
        catch (ItemNotFoundException nfe) {
            throw new ObjectNotFoundException("Object  '" + path + "' does not exist.");
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException(re.getMessage(), (Throwable)re);
        }
    }

    public ItemsIterator<Rendition> getRenditions(ObjectData object) {
        return RenditionManager.getInstance().getRenditions(object);
    }

    public RepositoryInfo getRepositoryInfo() {
        if (this.repositoryInfo == null) {
            PermissionMapping permissionMapping = new PermissionMapping();
            permissionMapping.put("canGetDescendents.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetFolderTree.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetChildren.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetObjectParents.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetFolderParent.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canCreateDocument.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canCreateFolder.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canCreateRelationship.Source", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canCreateRelationship.Target", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetProperties.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetContentStream.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canRenditions.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canUpdateProperties.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canMoveObject.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canMoveObject.Target", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canMoveObject.Source", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canDelete.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canDeleteTree.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canSetContentStream.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canDeleteContentStream.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canAddToFolder.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canAddToFolder.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canRemoveObjectFromFolder.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canRemoveObjectFromFolder.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canCheckout.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canCancelCheckout.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canCheckin.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canGetAllVersions.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetObjectRelationships.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canAddPolicy.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canAddPolicy.Policy", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canRemovePolicy.Object", Arrays.asList(Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canRemovePolicy.Policy", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetAppliedPolicies.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetACL.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canApplyACL.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            ArrayList<Permission> permissions = new ArrayList<Permission>(4);
            for (Permission.BasicPermissions b : Permission.BasicPermissions.values()) {
                permissions.add(new Permission(b.value(), ""));
            }
            String rootFolderPath = this.getJcrRootPath();
            String rootIdentifier = null;
            if ("/".equals(rootFolderPath)) {
                rootIdentifier = "00exo0jcr0root0uuid0000000000000";
            } else {
                try {
                    rootIdentifier = ((ExtendedNode)this.session.getItem(rootFolderPath)).getIdentifier();
                }
                catch (RepositoryException re) {
                    throw new CmisRuntimeException("Unable get root folder id. ", (Throwable)re);
                }
            }
            CapabilityQuery queryCapability = this.searchService != null ? CapabilityQuery.BOTHCOMBINED : CapabilityQuery.NONE;
            this.repositoryInfo = new RepositoryInfo(this.getId(), this.getId(), rootIdentifier, "1.0", new RepositoryCapabilities(CapabilityACL.MANAGE, CapabilityChanges.NONE, CapabilityContentStreamUpdatable.ANYTIME, CapabilityJoin.NONE, queryCapability, CapabilityRendition.READ, false, true, true, true, true, true, false, false), new ACLCapability(permissionMapping, Collections.unmodifiableList(permissions), AccessControlPropagation.REPOSITORYDETERMINED, SupportedPermissions.BASIC), IdentityConstants.ANONIM, IdentityConstants.ANY, null, null, true, "xCMIS (eXo SP)", "eXo", "xCMIS (eXo SP)", "1.1", null);
        }
        return this.repositoryInfo;
    }

    public Iterator<String> getUnfiledObjectsId() throws StorageException {
        return CmisUtils.emptyItemsIterator();
    }

    public ObjectData moveObject(ObjectData object, FolderData target, FolderData source) throws UpdateConflictException, VersioningException, NameConstraintViolationException, StorageException {
        String objectId = object.getObjectId();
        ((BaseObjectData)object).getNodeEntry().moveTo(((BaseObjectData)target).getNodeEntry());
        try {
            return this.getObject(this.getEntry(objectId));
        }
        catch (ObjectNotFoundException e) {
            throw new StorageException("Unable to retrieve the object after moving. " + e.getMessage(), (Throwable)e);
        }
    }

    public ItemsIterator<Result> query(Query query) throws InvalidArgumentException {
        if (this.searchService != null) {
            try {
                boolean isRootStorage = "/".equals(this.getJcrRootPath());
                org.xcmis.search.model.Query realQuery = this.cmisQueryParser.parseQuery(query.getStatement());
                if (!isRootStorage) {
                    DescendantNode rootDescendantConstraint = new DescendantNode(((Selector)realQuery.getSource()).getAlias(), "[" + this.getRepositoryInfo().getRootFolderId() + "]");
                    realQuery = new org.xcmis.search.model.Query(realQuery.getSource(), (Constraint)(realQuery.getConstraint() == null ? rootDescendantConstraint : new And(realQuery.getConstraint(), (Constraint)rootDescendantConstraint)), realQuery.getOrderings(), realQuery.getColumns(), realQuery.getLimits());
                }
                List rows = this.searchService.execute(realQuery);
                if (realQuery.getOrderings().size() == 0) {
                    Set selectorsReferencedBy = Visitors.getSelectorsReferencedBy((QueryElement)realQuery);
                    Collections.sort(rows, new DocumentOrderResultSorter(((SelectorName)selectorsReferencedBy.iterator().next()).getName(), this));
                }
                return new QueryResultIterator(rows, realQuery);
            }
            catch (InvalidQueryException e) {
                throw new InvalidArgumentException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (QueryExecutionException e) {
                throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        throw new NotSupportedException("Query is not supported. ");
    }

    public void unfileObject(ObjectData object) {
        throw new NotSupportedException("Unfiling is not supported.");
    }

    ObjectData getObject(JcrNodeEntry entry) {
        try {
            TypeDefinition typeDefinition = entry.getType();
            Node node = entry.getNode();
            if (typeDefinition.getBaseId() == BaseType.DOCUMENT) {
                if (node.getParent().isNodeType("xcmis:workingCopy")) {
                    return new PWC(entry);
                }
                if (node.isNodeType("nt:frozenNode")) {
                    return new DocumentVersion(entry);
                }
                if (!node.isNodeType("cmis:document")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn((Object)("Node " + node.getPath() + " has not 'cmis:document' mixin type. Some operations may be disabled."));
                    }
                    return new JcrFile(entry);
                }
                return new DocumentDataImpl(entry);
            }
            if (typeDefinition.getBaseId() == BaseType.FOLDER) {
                if (!node.isNodeType("cmis:folder")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn((Object)("Node " + node.getPath() + " has not 'cmis:document' mixin type. Some operation may be disabled."));
                    }
                    return new JcrFolder(entry);
                }
                return new FolderDataImpl(entry);
            }
            if (typeDefinition.getBaseId() == BaseType.POLICY) {
                return new PolicyDataImpl(entry);
            }
            if (typeDefinition.getBaseId() == BaseType.RELATIONSHIP) {
                return new RelationshipDataImpl(entry);
            }
            throw new CmisRuntimeException("Unknown base type. ");
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException(re.getMessage(), (Throwable)re);
        }
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    private class TreeVisitor
    implements ObjectDataVisitor {
        private final Collection<BaseObjectData> items = new LinkedHashSet<BaseObjectData>();

        private TreeVisitor() {
        }

        public void visit(ObjectData object) {
            TypeDefinition type = object.getTypeDefinition();
            if (type.getBaseId() == BaseType.FOLDER) {
                ItemsIterator<ObjectData> children = ((FolderDataImpl)object).getChildren(null);
                while (children.hasNext()) {
                    ((ObjectData)children.next()).accept((ObjectDataVisitor)this);
                }
                this.items.add((BaseObjectData)object);
            } else {
                this.items.add((BaseObjectData)object);
            }
        }
    }
}

