/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradePortletPreferencesPlugin
extends UpgradeProductPlugin {
    private static final String MOP_PORTLET_PREFERENCE = "mop:portletpreference";
    private RepositoryService repoService_;
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public UpgradePortletPreferencesPlugin(RepositoryService repoService, InitParams initParams) {
        super(initParams);
        this.repoService_ = repoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        String unchangedViews;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        if ((unchangedViews = "searches/WCMAdvanceSearchPortlet,detailParameterName,content-id") == null) {
            return;
        }
        String[] params = unchangedViews.split(",");
        if (params.length != 3) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Wrong format for '" + ((Object)((Object)this)).getClass().getName() + "', correct pattern is: " + "portletPreferencesChanged=PortletName,PreferenceName,PreferenceValue"));
            }
            return;
        }
        String portletName = params[0];
        String preferenceName = params[1];
        String preferenceValue = params[2];
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            ManageableRepository repository = this.repoService_.getCurrentRepository();
            Session session = sessionProvider.getSession("portal-system", repository);
            QueryManager manager = session.getWorkspace().getQueryManager();
            String statement = "SELECT * from mop:workspaceclone WHERE mop:contentid='" + portletName + "' and fn:name() = 'mop:customization'";
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodes = query.execute().getNodes();
            while (nodes.hasNext()) {
                Node stateNode;
                Node node = (Node)nodes.next();
                if (!node.hasNode("mop:state") || !(stateNode = node.getNode("mop:state")).isNodeType("mop:portletpreferences")) continue;
                this.addNode(stateNode, "mop:" + preferenceName, preferenceValue);
                stateNode.save();
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("An unexpected error occurs when add preference '" + preferenceName + "' for portlet " + portletName), (Throwable)e);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    private void addNode(Node stateNode, String nodeName, String value) {
        block4: {
            try {
                if (!stateNode.hasNode(nodeName)) {
                    Node prefNode = stateNode.addNode(nodeName, MOP_PORTLET_PREFERENCE);
                    prefNode.setProperty("mop:value", new String[]{value});
                    prefNode.setProperty("mop:readonly", false);
                    stateNode.save();
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("Add :: mop:portletpreference :: " + nodeName + " :-: " + value + " ::" + stateNode.getPath()));
                    }
                }
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block4;
                this.log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

