/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplateServiceImpl;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodeTypeTemplateUpgradePlugin
extends UpgradeProductPlugin {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private TemplateService templateService_;

    public NodeTypeTemplateUpgradePlugin(TemplateService templateService, InitParams initParams) {
        super(initParams);
        this.templateService_ = templateService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        String unchangedNodeTypes = PrivilegedSystemHelper.getProperty((String)"unchanged-nodetype-templates");
        SessionProvider sessionProvider = null;
        if (StringUtils.isEmpty((String)unchangedNodeTypes)) {
            unchangedNodeTypes = "";
        }
        try {
            HashSet<String> unchangedNodeTypeSet = new HashSet<String>();
            Set configuredNodeTypeSet = this.templateService_.getAllConfiguredNodeTypes();
            ArrayList<Node> removedNodes = new ArrayList<Node>();
            for (String unchangedNodeType : unchangedNodeTypes.split(",")) {
                unchangedNodeTypeSet.add(unchangedNodeType.trim());
            }
            sessionProvider = SessionProvider.createSystemProvider();
            Node templateHomeNode = this.templateService_.getTemplatesHome(sessionProvider);
            NodeIterator iter = templateHomeNode.getNodes();
            while (iter.hasNext()) {
                Node templateNode = iter.nextNode();
                if (!configuredNodeTypeSet.contains(templateNode.getName()) || unchangedNodeTypeSet.contains(templateNode.getName())) continue;
                removedNodes.add(templateNode);
            }
            for (Node removedNode : removedNodes) {
                try {
                    removedNode.remove();
                    templateHomeNode.save();
                }
                catch (Exception e) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.error((Object)("Error in " + this.getName() + ": Can not remove old template: " + removedNode.getPath()));
                }
            }
            ((TemplateServiceImpl)this.templateService_).start();
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"An unexpected error occurs when migrating node type template", (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

